/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.orchestrator.listeners;

import android.app.Instrumentation;
import android.os.Bundle;
import android.util.Log;
import androidx.test.orchestrator.junit.BundleJUnitUtils;
import androidx.test.orchestrator.junit.ParcelableDescription;
import androidx.test.orchestrator.junit.ParcelableFailure;
import androidx.test.orchestrator.listeners.OrchestrationRunListener;
import java.util.ArrayList;
import java.util.List;

public final class OrchestrationListenerManager {
    private static final String TAG = "ListenerManager";
    public static final String KEY_TEST_EVENT = "TestEvent";
    private final List<OrchestrationRunListener> listeners = new ArrayList<OrchestrationRunListener>();
    private final Instrumentation instrumentation;
    private boolean markTerminationAsFailure = false;
    private ParcelableDescription lastDescription;

    public OrchestrationListenerManager(Instrumentation instrumentation) {
        if (null == instrumentation) {
            throw new IllegalArgumentException("Instrumentation must not be null");
        }
        this.instrumentation = instrumentation;
    }

    public void addListener(OrchestrationRunListener listener) {
        listener.setInstrumentation(this.instrumentation);
        this.listeners.add(listener);
    }

    public void orchestrationRunStarted(int testCount) {
        for (OrchestrationRunListener listener : this.listeners) {
            listener.orchestrationRunStarted(testCount);
        }
    }

    public void testProcessStarted(ParcelableDescription description) {
        this.lastDescription = description;
        this.markTerminationAsFailure = true;
    }

    public void testProcessFinished(String outputFile) {
        if (this.markTerminationAsFailure) {
            for (OrchestrationRunListener listener : this.listeners) {
                listener.testFailure(new ParcelableFailure(this.lastDescription, new Throwable("Test instrumentation process crashed. Check " + outputFile + " for details")));
                listener.testFinished(this.lastDescription);
            }
        }
    }

    public void handleNotification(Bundle bundle) {
        bundle.setClassLoader(this.getClass().getClassLoader());
        this.cacheStatus(bundle);
        for (OrchestrationRunListener listener : this.listeners) {
            this.handleNotificationForListener(listener, bundle);
        }
    }

    private void cacheStatus(Bundle bundle) {
        if (BundleJUnitUtils.getDescription(bundle) != null) {
            this.lastDescription = BundleJUnitUtils.getDescription(bundle);
        }
        TestEvent status = TestEvent.valueOf(bundle.getString(KEY_TEST_EVENT));
        switch (status) {
            case TEST_RUN_STARTED: {
                this.markTerminationAsFailure = true;
                break;
            }
            case TEST_FAILURE: {
                this.markTerminationAsFailure = false;
                break;
            }
            case TEST_RUN_FINISHED: {
                this.markTerminationAsFailure = false;
                break;
            }
        }
    }

    private void handleNotificationForListener(OrchestrationRunListener listener, Bundle bundle) {
        TestEvent status = TestEvent.valueOf(bundle.getString(KEY_TEST_EVENT));
        switch (status) {
            case TEST_RUN_STARTED: {
                listener.testRunStarted(BundleJUnitUtils.getDescription(bundle));
                break;
            }
            case TEST_STARTED: {
                listener.testStarted(BundleJUnitUtils.getDescription(bundle));
                break;
            }
            case TEST_FINISHED: {
                listener.testFinished(BundleJUnitUtils.getDescription(bundle));
                break;
            }
            case TEST_FAILURE: {
                listener.testFailure(BundleJUnitUtils.getFailure(bundle));
                break;
            }
            case TEST_ASSUMPTION_FAILURE: {
                listener.testAssumptionFailure(BundleJUnitUtils.getFailure(bundle));
                break;
            }
            case TEST_IGNORED: {
                listener.testIgnored(BundleJUnitUtils.getDescription(bundle));
                break;
            }
            case TEST_RUN_FINISHED: {
                listener.testRunFinished(BundleJUnitUtils.getResult(bundle));
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Unknown notification type");
            }
        }
    }

    public static enum TestEvent {
        TEST_RUN_STARTED,
        TEST_RUN_FINISHED,
        TEST_STARTED,
        TEST_FINISHED,
        TEST_FAILURE,
        TEST_ASSUMPTION_FAILURE,
        TEST_IGNORED;

    }
}

