/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner;

import android.app.Application;
import android.app.Instrumentation;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.events.client.TestEventClient;
import androidx.test.internal.events.client.TestEventClientArgs;
import androidx.test.internal.events.client.TestEventClientConnectListener;
import androidx.test.internal.platform.reflect.ReflectionException;
import androidx.test.internal.platform.reflect.ReflectiveMethod;
import androidx.test.internal.runner.ClassPathScanner;
import androidx.test.internal.runner.RunnerArgs;
import androidx.test.internal.runner.TestExecutor;
import androidx.test.internal.runner.TestRequestBuilder;
import androidx.test.internal.runner.listener.ActivityFinisherRunListener;
import androidx.test.internal.runner.listener.CoverageListener;
import androidx.test.internal.runner.listener.DelayInjector;
import androidx.test.internal.runner.listener.InstrumentationResultPrinter;
import androidx.test.internal.runner.listener.LogRunListener;
import androidx.test.internal.runner.listener.SuiteAssignmentPrinter;
import androidx.test.internal.runner.listener.TraceRunListener;
import androidx.test.orchestrator.callback.OrchestratorV1Connection;
import androidx.test.platform.io.FileTestStorage;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.platform.io.PlatformTestStorageRegistry;
import androidx.test.runner.MonitoringInstrumentation;
import androidx.test.runner.lifecycle.ApplicationLifecycleCallback;
import androidx.test.runner.lifecycle.ApplicationLifecycleMonitorRegistry;
import androidx.test.runner.screenshot.ScreenCaptureProcessor;
import androidx.test.runner.screenshot.Screenshot;
import androidx.test.services.storage.TestStorage;
import androidx.tracing.Trace;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import org.junit.runner.Request;
import org.junit.runner.notification.RunListener;

public class AndroidJUnitRunner
extends MonitoringInstrumentation
implements TestEventClientConnectListener {
    private static final String LOG_TAG = "AndroidJUnitRunner";
    private Bundle arguments;
    private InstrumentationResultPrinter instrumentationResultPrinter;
    private RunnerArgs runnerArgs;
    private TestEventClient testEventClient = TestEventClient.NO_OP_CLIENT;
    private final Set<Throwable> appExceptionsHandled = Collections.newSetFromMap(new WeakHashMap());

    public Application newApplication(ClassLoader cl, String className, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Log.i((String)LOG_TAG, (String)("newApplication " + className));
        if (Build.VERSION.SDK_INT >= 16) {
            this.installMultidex();
        }
        if (this.instrumentationResultPrinter == null) {
            this.instrumentationResultPrinter = new InstrumentationResultPrinter();
        }
        return super.newApplication(cl, className, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate(Bundle arguments) {
        Log.i((String)LOG_TAG, (String)("onCreate " + arguments.toString()));
        Trace.beginSection((String)"AndroidJUnitRunner#onCreate");
        try {
            super.onCreate(arguments);
            if (this.instrumentationResultPrinter == null) {
                this.instrumentationResultPrinter = new InstrumentationResultPrinter();
            }
            this.arguments = arguments;
            this.registerTestStorage(this.arguments);
            this.parseRunnerArgs(this.arguments);
            if (this.waitForDebugger(this.runnerArgs)) {
                Log.i((String)LOG_TAG, (String)"Waiting for debugger to connect...");
                Debug.waitForDebugger();
                Log.i((String)LOG_TAG, (String)"Debugger connected.");
            }
            for (ApplicationLifecycleCallback listener : this.runnerArgs.appListeners) {
                ApplicationLifecycleMonitorRegistry.getInstance().addLifecycleCallback(listener);
            }
            this.addScreenCaptureProcessors(this.runnerArgs);
            if (this.shouldWaitForOrchestratorService()) {
                Log.v((String)LOG_TAG, (String)"Waiting to connect to the Orchestrator service...");
            } else {
                this.start();
            }
        }
        finally {
            Trace.endSection();
        }
    }

    private boolean shouldWaitForOrchestratorService() {
        TestEventClientArgs args = TestEventClientArgs.builder().setConnectionFactory(OrchestratorV1Connection::new).setOrchestratorService(this.runnerArgs.orchestratorService).setPrimaryInstProcess(this.isPrimaryInstrProcess(this.runnerArgs.targetProcess)).setTestDiscoveryRequested(this.runnerArgs.listTestsForOrchestrator).setTestRunEventsRequested(!this.runnerArgs.listTestsForOrchestrator).setTestDiscoveryService(this.runnerArgs.testDiscoveryService).setTestRunEventService(this.runnerArgs.testRunEventsService).setTestPlatformMigration(this.runnerArgs.testPlatformMigration).build();
        this.testEventClient = TestEventClient.connect(this.getContext(), this, args);
        return this.testEventClient.isOrchestrationServiceEnabled();
    }

    private boolean waitForDebugger(RunnerArgs arguments) {
        return arguments.debug && !arguments.listTestsForOrchestrator;
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onOrchestratorConnect() {
        this.onTestEventClientConnect();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onTestEventClientConnect() {
        this.testEventClient.setConnectedToOrchestrator(true);
        this.start();
    }

    private void parseRunnerArgs(Bundle arguments) {
        this.runnerArgs = new RunnerArgs.Builder().fromManifest((Instrumentation)this).fromBundle((Instrumentation)this, arguments).build();
    }

    private Bundle getArguments() {
        return this.arguments;
    }

    @VisibleForTesting
    InstrumentationResultPrinter getInstrumentationResultPrinter() {
        return this.instrumentationResultPrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart() {
        Log.d((String)LOG_TAG, (String)"onStart is called.");
        Trace.beginSection((String)"AndroidJUnitRunner#onStart");
        Bundle results = new Bundle();
        try {
            this.setJsBridgeClassName("androidx.test.espresso.web.bridge.JavaScriptBridge");
            super.onStart();
            Request testRequest = this.buildRequest(this.runnerArgs, this.getArguments());
            if (this.runnerArgs.remoteMethod != null) {
                try {
                    new ReflectiveMethod(this.runnerArgs.remoteMethod.testClassName, this.runnerArgs.remoteMethod.methodName, new Class[0]).invokeStatic(new Object[0]);
                }
                catch (ReflectionException e) {
                    Log.e((String)LOG_TAG, (String)String.format("Reflective call to remote method %s#%s failed", this.runnerArgs.remoteMethod.testClassName, this.runnerArgs.remoteMethod.methodName), (Throwable)e);
                }
            }
            if (!this.isPrimaryInstrProcess(this.runnerArgs.targetProcess)) {
                Log.i((String)LOG_TAG, (String)"Runner is idle...");
                return;
            }
            try {
                TestExecutor.Builder executorBuilder = new TestExecutor.Builder((Instrumentation)this);
                this.addListeners(this.runnerArgs, executorBuilder);
                results = executorBuilder.build().execute(testRequest);
            }
            catch (Throwable t) {
                String msg = "Fatal exception when running tests";
                Log.e((String)LOG_TAG, (String)"Fatal exception when running tests", (Throwable)t);
                this.onException(this, t);
            }
        }
        finally {
            Trace.endSection();
        }
        this.finish(-1, results);
    }

    @VisibleForTesting
    final void addListeners(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.newRunListenerMode) {
            this.addListenersNewOrder(args, builder);
        } else {
            this.addListenersLegacyOrder(args, builder);
        }
    }

    private void addListenersLegacyOrder(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.logOnly) {
            builder.addRunListener(this.getInstrumentationResultPrinter());
        } else if (args.suiteAssignment) {
            builder.addRunListener(new SuiteAssignmentPrinter());
        } else {
            builder.addRunListener(new LogRunListener());
            RunListener testEventClientListener = this.testEventClient.getRunListener();
            if (testEventClientListener != null) {
                builder.addRunListener(testEventClientListener);
            } else {
                builder.addRunListener(this.getInstrumentationResultPrinter());
            }
            if (this.shouldWaitForActivitiesToComplete()) {
                builder.addRunListener(new ActivityFinisherRunListener((Instrumentation)this, (Runnable)new MonitoringInstrumentation.ActivityFinisher((MonitoringInstrumentation)this), new Runnable(){

                    @Override
                    public void run() {
                        AndroidJUnitRunner.this.waitForActivitiesToComplete();
                    }
                }));
            }
            this.addDelayListener(args, builder);
            this.addCoverageListener(args, builder);
            builder.addRunListener(new TraceRunListener());
        }
        AndroidJUnitRunner.addListenersFromClasspath(builder);
        this.addListenersFromArg(args, builder);
    }

    private void addListenersNewOrder(RunnerArgs args, TestExecutor.Builder builder) {
        AndroidJUnitRunner.addListenersFromClasspath(builder);
        this.addListenersFromArg(args, builder);
        if (args.logOnly) {
            builder.addRunListener(this.getInstrumentationResultPrinter());
        } else if (args.suiteAssignment) {
            builder.addRunListener(new SuiteAssignmentPrinter());
        } else {
            builder.addRunListener(new LogRunListener());
            this.addDelayListener(args, builder);
            this.addCoverageListener(args, builder);
            RunListener testEventListener = this.testEventClient.getRunListener();
            if (testEventListener != null) {
                builder.addRunListener(testEventListener);
            } else {
                builder.addRunListener(this.getInstrumentationResultPrinter());
            }
            if (this.shouldWaitForActivitiesToComplete()) {
                builder.addRunListener(new ActivityFinisherRunListener((Instrumentation)this, (Runnable)new MonitoringInstrumentation.ActivityFinisher((MonitoringInstrumentation)this), new Runnable(){

                    @Override
                    public void run() {
                        AndroidJUnitRunner.this.waitForActivitiesToComplete();
                    }
                }));
            }
            builder.addRunListener(new TraceRunListener());
        }
    }

    private void addScreenCaptureProcessors(RunnerArgs args) {
        Screenshot.addScreenCaptureProcessors(new HashSet<ScreenCaptureProcessor>(args.screenCaptureProcessors));
    }

    private void addCoverageListener(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.codeCoverage) {
            builder.addRunListener(new CoverageListener(args.codeCoveragePath, PlatformTestStorageRegistry.getInstance()));
        }
    }

    private void addDelayListener(RunnerArgs args, TestExecutor.Builder builder) {
        if (args.delayInMillis > 0) {
            builder.addRunListener(new DelayInjector(args.delayInMillis));
        } else if (args.logOnly && Build.VERSION.SDK_INT < 16) {
            builder.addRunListener(new DelayInjector(15));
        }
    }

    private static void addListenersFromClasspath(TestExecutor.Builder builder) {
        for (RunListener listener : ServiceLoader.load(RunListener.class)) {
            builder.addRunListener(listener);
        }
    }

    private void addListenersFromArg(RunnerArgs args, TestExecutor.Builder builder) {
        for (RunListener listener : args.listeners) {
            builder.addRunListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onException(Object obj, Throwable e) {
        Throwable cause = this.unwrapException(e);
        if (this.appExceptionsHandled.contains(cause)) {
            Log.d((String)LOG_TAG, (String)String.format("We've already handled this exception %s. Ignoring.", cause.getClass().getName()));
            return false;
        }
        Log.w((String)LOG_TAG, (String)"An unhandled exception was thrown by the app.", (Throwable)e);
        this.appExceptionsHandled.add(cause);
        InstrumentationResultPrinter instResultPrinter = this.getInstrumentationResultPrinter();
        if (instResultPrinter != null) {
            if (instResultPrinter.getInstrumentation() == null) {
                instResultPrinter.setInstrumentation((Instrumentation)this);
            }
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
            try {
                instResultPrinter.reportProcessCrash(e);
            }
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
            }
        }
        if (this.testEventClient != null) {
            Log.d((String)LOG_TAG, (String)"Reporting the crash to an event service.");
            this.testEventClient.reportProcessCrash(e);
        }
        Log.i((String)LOG_TAG, (String)"Bringing down the entire Instrumentation process.");
        return super.onException(obj, e);
    }

    public void sendStatus(int resultCode, Bundle results) {
        Trace.beginSection((String)"sendStatus");
        try {
            super.sendStatus(resultCode, results);
        }
        finally {
            Trace.endSection();
        }
    }

    @VisibleForTesting
    Request buildRequest(RunnerArgs runnerArgs, Bundle bundleArgs) {
        TestRequestBuilder builder = this.createTestRequestBuilder((Instrumentation)this, bundleArgs);
        builder.addPathsToScan(runnerArgs.classpathToScan);
        if (runnerArgs.classpathToScan.isEmpty()) {
            builder.addPathsToScan(ClassPathScanner.getDefaultClasspaths((Instrumentation)this));
        }
        builder.addFromRunnerArgs(runnerArgs);
        return builder.build();
    }

    TestRequestBuilder createTestRequestBuilder(Instrumentation instr, Bundle arguments) {
        return new TestRequestBuilder(instr, arguments);
    }

    private void registerTestStorage(Bundle bundleArgs) {
        if (Boolean.parseBoolean(bundleArgs.getString("useTestStorageService"))) {
            Log.d((String)LOG_TAG, (String)"Use the test storage service for managing file I/O.");
            PlatformTestStorageRegistry.registerInstance((PlatformTestStorage)new TestStorage());
        } else {
            Log.d((String)LOG_TAG, (String)"Use the raw file system for managing file I/O.");
            PlatformTestStorageRegistry.registerInstance((PlatformTestStorage)new FileTestStorage());
        }
    }
}

