/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.coverage;

import android.app.Instrumentation;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.services.storage.TestStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class InstrumentationCoverageReporter {
    private static final String TAG = InstrumentationCoverageReporter.class.getSimpleName();
    private static final String EMMA_RUNTIME_CLASS = "com.vladium.emma.rt.RT";
    private static final String DEFAULT_COVERAGE_FILE_NAME = "coverage.ec";
    private final Instrumentation instrumentation;
    private final PlatformTestStorage testStorage;

    public InstrumentationCoverageReporter(Instrumentation instrumentation, PlatformTestStorage testStorage) {
        this.instrumentation = instrumentation;
        this.testStorage = testStorage;
    }

    public String generateCoverageReport(@Nullable String coverageFilePath, PrintStream instrumentationResultWriter) {
        coverageFilePath = this.testStorage instanceof TestStorage ? this.dumpCoverageToTestStorage(coverageFilePath, instrumentationResultWriter) : this.dumpCoverageToFile(coverageFilePath, instrumentationResultWriter);
        Log.d((String)TAG, (String)("Coverage file was generated to " + coverageFilePath));
        instrumentationResultWriter.format("\nGenerated code coverage data to %s", coverageFilePath);
        return coverageFilePath;
    }

    private String dumpCoverageToFile(String coverageFilePath, PrintStream instrumentationResultWriter) {
        if (coverageFilePath == null) {
            Log.d((String)TAG, (String)"No coverage file path was specified. Dumps to the default file path.");
            coverageFilePath = this.instrumentation.getTargetContext().getFilesDir().getAbsolutePath() + File.separator + DEFAULT_COVERAGE_FILE_NAME;
        }
        if (!this.generateCoverageInternal(coverageFilePath, instrumentationResultWriter)) {
            Log.w((String)TAG, (String)"Failed to generate the coverage data file. Please refer to the instrumentation result for more info.");
        }
        return coverageFilePath;
    }

    private String dumpCoverageToTestStorage(String coverageFilePath, PrintStream instrumentationResultWriter) {
        String tempCoverageFilePath;
        if (coverageFilePath == null) {
            Log.d((String)TAG, (String)"No coverage file path was specified. Dumps to the default coverage file using test storage.");
            coverageFilePath = DEFAULT_COVERAGE_FILE_NAME;
        }
        if (!this.generateCoverageInternal(tempCoverageFilePath = this.instrumentation.getTargetContext().getFilesDir().getAbsolutePath() + File.separator + DEFAULT_COVERAGE_FILE_NAME, instrumentationResultWriter)) {
            Log.w((String)TAG, (String)"Failed to generate the coverage data file. Please refer to the instrumentation result for more info.");
        }
        try {
            Log.d((String)TAG, (String)"Test service is available. Moving the coverage data file to be managed by the storage service.");
            this.moveFileToTestStorage(tempCoverageFilePath, coverageFilePath);
            return coverageFilePath;
        }
        catch (IOException e) {
            this.reportEmmaError(instrumentationResultWriter, e);
            return null;
        }
    }

    private void moveFileToTestStorage(String srcFilePath, String destFilePath) throws IOException {
        File srcFile = new File(srcFilePath);
        if (srcFile.exists()) {
            Log.d((String)TAG, (String)String.format("Moving coverage file [%s] to the internal test storage [%s].", srcFilePath, destFilePath));
            try (OutputStream outputStream = this.testStorage.openInternalOutputFile(destFilePath);
                 FileChannel srcChannel = new FileInputStream(srcFilePath).getChannel();
                 WritableByteChannel destChannel = Channels.newChannel(outputStream);){
                srcChannel.transferTo(0L, srcChannel.size(), destChannel);
            }
            if (!srcFile.delete()) {
                Log.e((String)TAG, (String)String.format("Failed to delete original coverage file [%s]", srcFile.getAbsolutePath()));
            }
        }
    }

    @VisibleForTesting
    public boolean generateCoverageInternal(String coverageFilePath, PrintStream instrumentationResultWriter) {
        File coverageFile = new File(coverageFilePath);
        try {
            Class<?> emmaRTClass;
            try {
                emmaRTClass = Class.forName(EMMA_RUNTIME_CLASS, true, this.instrumentation.getTargetContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                emmaRTClass = Class.forName(EMMA_RUNTIME_CLASS, true, this.instrumentation.getContext().getClassLoader());
                String msg = "Generating coverage for alternate test context.";
                Log.w((String)TAG, (String)msg);
                instrumentationResultWriter.format("\nWarning: %s", msg);
            }
            Method dumpCoverageMethod = emmaRTClass.getMethod("dumpCoverageData", coverageFile.getClass(), Boolean.TYPE, Boolean.TYPE);
            dumpCoverageMethod.invoke(null, coverageFile, false, false);
            return true;
        }
        catch (ClassNotFoundException e) {
            this.reportEmmaError(instrumentationResultWriter, "Is Emma/JaCoCo jar on classpath?", e);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.reportEmmaError(instrumentationResultWriter, e);
        }
        return false;
    }

    private void reportEmmaError(PrintStream writer, Exception e) {
        this.reportEmmaError(writer, "", e);
    }

    private void reportEmmaError(PrintStream writer, String hint, Exception e) {
        String msg = "Failed to generate Emma/JaCoCo coverage. " + hint;
        Log.e((String)TAG, (String)msg, (Throwable)e);
        writer.format("\nError: %s", msg);
    }
}

