/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.runner.permission;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.test.internal.platform.content.PermissionGranter;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.runner.permission.GrantPermissionCallable;
import androidx.test.runner.permission.RequestPermissionCallable;
import androidx.test.runner.permission.UiAutomationShellCommand;
import java.util.HashSet;
import junit.framework.Assert;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@TargetApi(value=23)
public class PermissionRequester
implements PermissionGranter {
    private static final String TAG = "PermissionRequester";
    @ChecksSdkIntAtLeast(extension=0)
    private int androidRuntimeVersion = Build.VERSION.SDK_INT;
    @NonNull
    private final Context targetContext;
    @VisibleForTesting
    final HashSet<RequestPermissionCallable> requestedPermissions = new HashSet();

    public PermissionRequester() {
        this(InstrumentationRegistry.getInstrumentation().getTargetContext());
    }

    @VisibleForTesting
    PermissionRequester(@NonNull Context targetContext) {
        this.targetContext = (Context)Checks.checkNotNull((Object)targetContext, (Object)"targetContext cannot be null!");
    }

    public void addPermissions(String ... permissions) {
        Checks.checkNotNull((Object)permissions, (Object)"permissions cannot be null!");
        if (this.deviceSupportsRuntimePermissions()) {
            for (String permission : permissions) {
                Assert.assertFalse((String)"Permission String is empty or null!", (boolean)TextUtils.isEmpty((CharSequence)permission));
                GrantPermissionCallable requestPermissionCallable = new GrantPermissionCallable(new UiAutomationShellCommand(this.targetContext.getPackageName(), permission, UiAutomationShellCommand.PmCommand.GRANT_PERMISSION), this.targetContext, permission);
                Checks.checkState((boolean)this.requestedPermissions.add(requestPermissionCallable));
            }
        }
    }

    public void requestPermissions() {
        if (this.deviceSupportsRuntimePermissions()) {
            for (RequestPermissionCallable requestPermissionCallable : this.requestedPermissions) {
                try {
                    if (RequestPermissionCallable.Result.FAILURE != requestPermissionCallable.call()) continue;
                    Assert.fail((String)"Failed to grant permissions, see logcat for details");
                    return;
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"An Exception was thrown while granting permission", (Throwable)exception);
                    Assert.fail((String)"Failed to grant permissions, see logcat for details");
                    return;
                }
            }
        }
    }

    @VisibleForTesting
    protected void setAndroidRuntimeVersion(int sdkInt) {
        this.androidRuntimeVersion = sdkInt;
    }

    private boolean deviceSupportsRuntimePermissions() {
        boolean supportsRuntimePermissions;
        boolean bl = supportsRuntimePermissions = this.getAndroidRuntimeVersion() >= 23;
        if (!supportsRuntimePermissions) {
            Log.w((String)TAG, (String)"Permissions can only be granted on devices running Android M (API 23) orhigher. This rule is ignored.");
        }
        return supportsRuntimePermissions;
    }

    private int getAndroidRuntimeVersion() {
        return this.androidRuntimeVersion;
    }
}

