/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.AnnotationValue;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class AnnotationInfo
implements Parcelable {
    @NonNull
    public final String name;
    @NonNull
    public final List<AnnotationValue> values;
    public static final Parcelable.Creator<AnnotationInfo> CREATOR = new Parcelable.Creator<AnnotationInfo>(){

        public AnnotationInfo createFromParcel(Parcel source) {
            return new AnnotationInfo(source);
        }

        public AnnotationInfo[] newArray(int size) {
            return new AnnotationInfo[size];
        }
    };

    public AnnotationInfo(@NonNull String annotationName, @NonNull List<AnnotationValue> annotationValues) {
        Checks.checkNotNull((Object)annotationName, (Object)"annotationName cannot be null");
        Checks.checkNotNull((Object)annotationName, (Object)"annotationValues cannot be null");
        this.name = annotationName;
        this.values = annotationValues;
    }

    private AnnotationInfo(@NonNull Parcel source) {
        this.name = source.readString();
        this.values = new ArrayList<AnnotationValue>();
        source.readTypedList(this.values, AnnotationValue.CREATOR);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.name);
        parcel.writeTypedList(this.values);
    }
}

