/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.junit4;

import androidx.test.internal.runner.RunnerArgs;
import androidx.test.internal.runner.junit4.statement.RunAfters;
import androidx.test.internal.runner.junit4.statement.RunBefores;
import androidx.test.internal.runner.junit4.statement.UiThreadStatement;
import androidx.test.internal.util.AndroidRunnerParams;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class AndroidJUnit4ClassRunner
extends BlockJUnit4ClassRunner {
    private final long perTestTimeout;

    @Deprecated
    public AndroidJUnit4ClassRunner(Class<?> klass, AndroidRunnerParams runnerParams) throws InitializationError {
        this(klass, runnerParams.getPerTestTimeout());
    }

    public AndroidJUnit4ClassRunner(Class<?> klass, long perTestTimeout) throws InitializationError {
        super(klass);
        this.perTestTimeout = perTestTimeout;
    }

    public AndroidJUnit4ClassRunner(Class<?> klass) throws InitializationError {
        this(klass, RunnerArgs.parseTestTimeout(InstrumentationRegistry.getArguments()));
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (UiThreadStatement.shouldRunOnUiThread(method)) {
            return new UiThreadStatement(super.methodInvoker(method, test), true);
        }
        return super.methodInvoker(method, test);
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        List befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return befores.isEmpty() ? statement : new RunBefores(method, statement, befores, target);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return afters.isEmpty() ? statement : new RunAfters(method, statement, afters, target);
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        long timeout = this.getTimeout((Test)method.getAnnotation(Test.class));
        if (timeout <= 0L && this.perTestTimeout > 0L) {
            timeout = this.perTestTimeout;
        }
        if (timeout <= 0L) {
            return next;
        }
        return new FailOnTimeout(next, timeout);
    }

    private long getTimeout(Test annotation) {
        if (annotation == null) {
            return 0L;
        }
        return annotation.timeout();
    }
}

