/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto;

import androidx.annotation.RestrictTo;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0006\u0014\u0015\u0016\u0017\u0018\u0019B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012-\u0010\u0004\u001a)\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t0\u0005\u0012!\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002R)\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u0004\u001a)\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/tracing/perfetto/PerfettoHandshake;", "", "targetPackage", "", "parseJsonMap", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "jsonString", "", "executeShellCommand", "command", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "enableTracing", "Landroidx/tracing/perfetto/PerfettoHandshake$EnableTracingResponse;", "libraryProvider", "Landroidx/tracing/perfetto/PerfettoHandshake$ExternalLibraryProvider;", "getDeviceAbi", "parseResponse", "rawResponse", "EnableTracingResponse", "EnableTracingResultCode", "ExternalLibraryProvider", "RequestKeys", "ResponseExitCodes", "ResponseKeys", "tracing-perfetto-common"})
@SourceDebugExtension(value={"SMAP\nPerfettoHandshake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoHandshake.kt\nandroidx/tracing/perfetto/PerfettoHandshake\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n288#2,2:276\n288#2,2:278\n*S KotlinDebug\n*F\n+ 1 PerfettoHandshake.kt\nandroidx/tracing/perfetto/PerfettoHandshake\n*L\n78#1:276,2\n98#1:278,2\n*E\n"})
public final class PerfettoHandshake {
    @NotNull
    private final String targetPackage;
    @NotNull
    private final Function1<String, Map<String, String>> parseJsonMap;
    @NotNull
    private final Function1<String, String> executeShellCommand;

    public PerfettoHandshake(@NotNull String targetPackage, @NotNull Function1<? super String, ? extends Map<String, String>> parseJsonMap, @NotNull Function1<? super String, String> executeShellCommand) {
        Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
        Intrinsics.checkNotNullParameter(parseJsonMap, (String)"parseJsonMap");
        Intrinsics.checkNotNullParameter(executeShellCommand, (String)"executeShellCommand");
        this.targetPackage = targetPackage;
        this.parseJsonMap = parseJsonMap;
        this.executeShellCommand = executeShellCommand;
    }

    @NotNull
    public final EnableTracingResponse enableTracing(@Nullable ExternalLibraryProvider libraryProvider) {
        EnableTracingResponse enableTracingResponse;
        Object object;
        block5: {
            block4: {
                object = libraryProvider;
                if (object == null) break block4;
                ExternalLibraryProvider it = object;
                boolean bl = false;
                String libPath = it.pushLibrary$tracing_perfetto_common(this.targetPackage, this.getDeviceAbi());
                String string = "--es path " + libPath;
                object = string;
                if (string != null) break block5;
            }
            object = "";
        }
        Object pathExtra = object;
        String command = "am broadcast -a androidx.tracing.perfetto.action.ENABLE_TRACING " + (String)pathExtra + ' ' + this.targetPackage + "/androidx.tracing.perfetto.TracingReceiver";
        String rawResponse = (String)this.executeShellCommand.invoke((Object)command);
        try {
            enableTracingResponse = this.parseResponse(rawResponse);
        }
        catch (IllegalArgumentException e) {
            String message = "Exception occurred while trying to parse a response. Error: " + e.getMessage() + ". Raw response: " + rawResponse + '.';
            enableTracingResponse = new EnableTracingResponse(99, null, message);
        }
        return enableTracingResponse;
    }

    public static /* synthetic */ EnableTracingResponse enableTracing$default(PerfettoHandshake perfettoHandshake, ExternalLibraryProvider externalLibraryProvider, int n, Object object) {
        if ((n & 1) != 0) {
            externalLibraryProvider = null;
        }
        return perfettoHandshake.enableTracing(externalLibraryProvider);
    }

    /*
     * WARNING - void declaration
     */
    private final EnableTracingResponse parseResponse(String rawResponse) {
        String string;
        Object v4;
        Object object;
        String $this$firstOrNull$iv;
        Integer broadcastResponseCode;
        Object object2;
        block10: {
            Object v0;
            Object element$iv;
            block9: {
                void $this$firstOrNull$iv2;
                Object object3 = rawResponse;
                Regex regex = new Regex("\r?\n");
                int n = 0;
                object3 = regex.split((CharSequence)object3, n);
                boolean $i$f$firstOrNull = false;
                object2 = $this$firstOrNull$iv2.iterator();
                while (object2.hasNext()) {
                    element$iv = object2.next();
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"Broadcast completed: result=", (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            String string2 = v0;
            if (string2 == null) {
                throw new IllegalArgumentException("Cannot parse: " + rawResponse);
            }
            String line = string2;
            if (Intrinsics.areEqual((Object)line, (Object)"Broadcast completed: result=0")) {
                return new EnableTracingResponse(0, null, null);
            }
            MatchResult matchResult = new Regex("Broadcast completed: (result=.*?)(, data=\".*?\")?(, extras: .*)?").matchEntire((CharSequence)line);
            if (matchResult == null) {
                throw new IllegalArgumentException("Cannot parse: " + rawResponse);
            }
            MatchResult matchResult2 = matchResult;
            MatchGroup $i$f$firstOrNull = matchResult2.getGroups().get(1);
            broadcastResponseCode = $i$f$firstOrNull != null && (object2 = $i$f$firstOrNull.getValue()) != null && (element$iv = StringsKt.substringAfter$default((String)object2, (String)"result=", null, (int)2, null)) != null ? StringsKt.toIntOrNull(element$iv) : null;
            element$iv = (Iterable)matchResult2.getGroups();
            boolean $i$f$firstOrNull2 = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                Object element$iv2 = object.next();
                MatchGroup it = (MatchGroup)element$iv2;
                boolean bl = false;
                Object object4 = it;
                if (!(object4 != null && (object4 = object4.getValue()) != null ? StringsKt.startsWith$default((String)object4, (String)", data=", (boolean)false, (int)2, null) : false)) continue;
                v4 = element$iv2;
                break block10;
            }
            v4 = null;
        }
        object2 = v4;
        if (object2 == null || ($this$firstOrNull$iv = object2.getValue()) == null || (string = StringsKt.substringAfter$default((String)$this$firstOrNull$iv, (String)", data=\"", null, (int)2, null)) == null || (object = StringsKt.dropLast((String)string, (int)1)) == null) {
            throw new IllegalArgumentException("Cannot parse: " + rawResponse + ". Unable to detect 'data=' section.");
        }
        Object dataString = object;
        Map dataMap = (Map)this.parseJsonMap.invoke(dataString);
        String string3 = (String)dataMap.get("exitCode");
        if (string3 == null) {
            throw new IllegalArgumentException("Response missing exitCode value");
        }
        String string4 = (String)dataMap.get("requiredVersion");
        if (string4 == null) {
            throw new IllegalArgumentException("Response missing requiredVersion value");
        }
        EnableTracingResponse response = new EnableTracingResponse(Integer.parseInt(string3), string4, (String)dataMap.get("message"));
        Integer n = broadcastResponseCode;
        int n2 = response.getExitCode();
        if (n == null || n != n2) {
            throw new IllegalStateException("Cannot parse: " + rawResponse + ". Exit code not matching broadcast exit code.");
        }
        return response;
    }

    private final String getDeviceAbi() {
        String[] stringArray = new String[]{","};
        return ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)((CharSequence)this.executeShellCommand.invoke((Object)"getprop ro.product.cpu.abilist")), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Object)this.executeShellCommand.invoke((Object)"getprop ro.product.cpu.abi")))))).toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00126\u0010\u0005\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0005\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/tracing/perfetto/PerfettoHandshake$ExternalLibraryProvider;", "", "libraryZip", "Ljava/io/File;", "tempDirectory", "moveTempDirectoryFileToDestination", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "tempFile", "destinationFile", "", "(Ljava/io/File;Ljava/io/File;Lkotlin/jvm/functions/Function2;)V", "pushLibrary", "", "targetPackage", "abi", "pushLibrary$tracing_perfetto_common", "tracing-perfetto-common"})
    @SourceDebugExtension(value={"SMAP\nPerfettoHandshake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoHandshake.kt\nandroidx/tracing/perfetto/PerfettoHandshake$ExternalLibraryProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,275:1\n179#2,2:276\n*S KotlinDebug\n*F\n+ 1 PerfettoHandshake.kt\nandroidx/tracing/perfetto/PerfettoHandshake$ExternalLibraryProvider\n*L\n155#1:276,2\n*E\n"})
    public static final class ExternalLibraryProvider {
        @NotNull
        private final File libraryZip;
        @NotNull
        private final File tempDirectory;
        @NotNull
        private final Function2<File, File, Unit> moveTempDirectoryFileToDestination;

        public ExternalLibraryProvider(@NotNull File libraryZip, @NotNull File tempDirectory, @NotNull Function2<? super File, ? super File, Unit> moveTempDirectoryFileToDestination) {
            Intrinsics.checkNotNullParameter((Object)libraryZip, (String)"libraryZip");
            Intrinsics.checkNotNullParameter((Object)tempDirectory, (String)"tempDirectory");
            Intrinsics.checkNotNullParameter(moveTempDirectoryFileToDestination, (String)"moveTempDirectoryFileToDestination");
            this.libraryZip = libraryZip;
            this.tempDirectory = tempDirectory;
            this.moveTempDirectoryFileToDestination = moveTempDirectoryFileToDestination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String pushLibrary$tracing_perfetto_common(@NotNull String targetPackage, @NotNull String abi) {
            Object v2;
            Object object;
            ZipFile zipFile;
            File tmpFile;
            File dstFile;
            String libFileName;
            block12: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
                Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
                libFileName = "libtracing_perfetto.so";
                File shellWriteableAppReadableDir = new File("/sdcard/Android/media/" + targetPackage + "/files");
                File dstDir = FilesKt.resolve((File)shellWriteableAppReadableDir, (String)("lib/" + abi));
                dstFile = FilesKt.resolve((File)dstDir, (String)libFileName);
                tmpFile = FilesKt.resolve((File)this.tempDirectory, (String)(".tmp_" + libFileName));
                Regex rxLibPathInsideZip = new Regex(".*(lib|jni)/[^/]*" + abi + "[^/]*/" + libFileName);
                zipFile = new ZipFile(this.libraryZip);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zipFile\n                .entries()");
                object = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ZipEntry it = (ZipEntry)element$iv;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    if (!rxLibPathInsideZip.matches((CharSequence)string)) continue;
                    v2 = element$iv;
                    break block12;
                }
                v2 = null;
            }
            ZipEntry zipEntry = v2;
            if (zipEntry == null) {
                throw new IllegalStateException("Unable to locate " + libFileName + " to enable Perfetto SDK. Tried inside " + this.libraryZip.getPath() + '.');
            }
            ZipEntry entry = zipEntry;
            Closeable closeable = zipFile.getInputStream(entry);
            object = null;
            try {
                long l;
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileOutputStream(tmpFile);
                Throwable throwable = null;
                try {
                    FileOutputStream outputStream = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
                long l2 = l;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            this.moveTempDirectoryFileToDestination.invoke((Object)tmpFile, (Object)dstFile);
            String string = dstFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dstFile.path");
            return string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Landroidx/tracing/perfetto/PerfettoHandshake$EnableTracingResponse;", "", "exitCode", "", "requiredVersion", "", "message", "(ILjava/lang/String;Ljava/lang/String;)V", "getExitCode", "()I", "getMessage", "()Ljava/lang/String;", "getRequiredVersion", "tracing-perfetto-common"})
    public static final class EnableTracingResponse {
        private final int exitCode;
        @Nullable
        private final String requiredVersion;
        @Nullable
        private final String message;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public EnableTracingResponse(int exitCode, @Nullable String requiredVersion, @Nullable String message) {
            this.exitCode = exitCode;
            this.requiredVersion = requiredVersion;
            this.message = message;
        }

        public final int getExitCode() {
            return this.exitCode;
        }

        @Nullable
        public final String getRequiredVersion() {
            return this.requiredVersion;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/tracing/perfetto/PerfettoHandshake$RequestKeys;", "", "()V", "ACTION_ENABLE_TRACING", "", "KEY_PATH", "RECEIVER_CLASS_NAME", "tracing-perfetto-common"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class RequestKeys {
        @NotNull
        public static final RequestKeys INSTANCE = new RequestKeys();
        @NotNull
        public static final String RECEIVER_CLASS_NAME = "androidx.tracing.perfetto.TracingReceiver";
        @NotNull
        public static final String ACTION_ENABLE_TRACING = "androidx.tracing.perfetto.action.ENABLE_TRACING";
        @NotNull
        public static final String KEY_PATH = "path";

        private RequestKeys() {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/tracing/perfetto/PerfettoHandshake$ResponseKeys;", "", "()V", "KEY_EXIT_CODE", "", "KEY_MESSAGE", "KEY_REQUIRED_VERSION", "tracing-perfetto-common"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class ResponseKeys {
        @NotNull
        public static final ResponseKeys INSTANCE = new ResponseKeys();
        @NotNull
        public static final String KEY_EXIT_CODE = "exitCode";
        @NotNull
        public static final String KEY_REQUIRED_VERSION = "requiredVersion";
        @NotNull
        public static final String KEY_MESSAGE = "message";

        private ResponseKeys() {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/tracing/perfetto/PerfettoHandshake$ResponseExitCodes;", "", "()V", "RESULT_CODE_ALREADY_ENABLED", "", "RESULT_CODE_CANCELLED", "RESULT_CODE_ERROR_BINARY_MISSING", "RESULT_CODE_ERROR_BINARY_VERIFICATION_ERROR", "RESULT_CODE_ERROR_BINARY_VERSION_MISMATCH", "RESULT_CODE_ERROR_OTHER", "RESULT_CODE_SUCCESS", "tracing-perfetto-common"})
    public static final class ResponseExitCodes {
        @NotNull
        public static final ResponseExitCodes INSTANCE = new ResponseExitCodes();
        public static final int RESULT_CODE_CANCELLED = 0;
        public static final int RESULT_CODE_SUCCESS = 1;
        public static final int RESULT_CODE_ALREADY_ENABLED = 2;
        public static final int RESULT_CODE_ERROR_BINARY_MISSING = 11;
        public static final int RESULT_CODE_ERROR_BINARY_VERSION_MISMATCH = 12;
        public static final int RESULT_CODE_ERROR_BINARY_VERIFICATION_ERROR = 13;
        public static final int RESULT_CODE_ERROR_OTHER = 99;

        private ResponseExitCodes() {
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/tracing/perfetto/PerfettoHandshake$EnableTracingResultCode;", "", "tracing-perfetto-common"})
    private static @interface EnableTracingResultCode {
    }
}

