/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto.handshake;

import androidx.tracing.perfetto.handshake.PerfettoSdkSideloader;
import androidx.tracing.perfetto.handshake.protocol.EnableTracingResponse;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001fBc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012-\u0010\u0004\u001a)\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t0\u0005\u0012%\u0010\n\u001a!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00030\u0005j\u0002`\f\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0012\u0010\u0015\u001a\u00020\u000f2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J-\u0010\u0018\u001a\u00020\u000f2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eR-\u0010\n\u001a!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00030\u0005j\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u0004\u001a)\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake;", "", "targetPackage", "", "parseJsonMap", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "jsonString", "", "executeShellCommand", "command", "Landroidx/tracing/perfetto/handshake/ShellCommandExecutor;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "enableTracingColdStart", "Landroidx/tracing/perfetto/handshake/protocol/EnableTracingResponse;", "killAppProcess", "Lkotlin/Function0;", "", "librarySource", "Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake$LibrarySource;", "enableTracingImmediate", "parseResponse", "rawResponse", "sendEnableTracingBroadcast", "libPath", "Ljava/io/File;", "coldStart", "", "persistent", "(Ljava/io/File;ZLjava/lang/Boolean;)Landroidx/tracing/perfetto/handshake/protocol/EnableTracingResponse;", "LibrarySource", "tracing-perfetto-handshake"})
@SourceDebugExtension(value={"SMAP\nPerfettoSdkHandshake.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoSdkHandshake.kt\nandroidx/tracing/perfetto/handshake/PerfettoSdkHandshake\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n288#2,2:194\n288#2,2:196\n*S KotlinDebug\n*F\n+ 1 PerfettoSdkHandshake.kt\nandroidx/tracing/perfetto/handshake/PerfettoSdkHandshake\n*L\n131#1:194,2\n151#1:196,2\n*E\n"})
public final class PerfettoSdkHandshake {
    @NotNull
    private final String targetPackage;
    @NotNull
    private final Function1<String, Map<String, String>> parseJsonMap;
    @NotNull
    private final Function1<String, String> executeShellCommand;

    public PerfettoSdkHandshake(@NotNull String targetPackage, @NotNull Function1<? super String, ? extends Map<String, String>> parseJsonMap, @NotNull Function1<? super String, String> executeShellCommand) {
        Intrinsics.checkNotNullParameter((Object)targetPackage, (String)"targetPackage");
        Intrinsics.checkNotNullParameter(parseJsonMap, (String)"parseJsonMap");
        Intrinsics.checkNotNullParameter(executeShellCommand, (String)"executeShellCommand");
        this.targetPackage = targetPackage;
        this.parseJsonMap = parseJsonMap;
        this.executeShellCommand = executeShellCommand;
    }

    @NotNull
    public final EnableTracingResponse enableTracingImmediate(@Nullable LibrarySource librarySource) {
        File file;
        LibrarySource librarySource2 = librarySource;
        if (librarySource2 != null) {
            LibrarySource $this$enableTracingImmediate_u24lambda_u240 = librarySource2;
            boolean bl = false;
            file = new PerfettoSdkSideloader(this.targetPackage).sideloadFromZipFile($this$enableTracingImmediate_u24lambda_u240.getLibraryZip$tracing_perfetto_handshake(), $this$enableTracingImmediate_u24lambda_u240.getTempDirectory$tracing_perfetto_handshake(), this.executeShellCommand, $this$enableTracingImmediate_u24lambda_u240.getMoveLibFileFromTmpDirToAppDir$tracing_perfetto_handshake());
        } else {
            file = null;
        }
        File libPath = file;
        return PerfettoSdkHandshake.sendEnableTracingBroadcast$default(this, libPath, false, null, 4, null);
    }

    public static /* synthetic */ EnableTracingResponse enableTracingImmediate$default(PerfettoSdkHandshake perfettoSdkHandshake, LibrarySource librarySource, int n, Object object) {
        if ((n & 1) != 0) {
            librarySource = null;
        }
        return perfettoSdkHandshake.enableTracingImmediate(librarySource);
    }

    @NotNull
    public final EnableTracingResponse enableTracingColdStart(@NotNull Function0<Unit> killAppProcess, @Nullable LibrarySource librarySource) {
        File file;
        Intrinsics.checkNotNullParameter(killAppProcess, (String)"killAppProcess");
        LibrarySource librarySource2 = librarySource;
        if (librarySource2 != null) {
            LibrarySource $this$enableTracingColdStart_u24lambda_u241 = librarySource2;
            boolean bl = false;
            file = new PerfettoSdkSideloader(this.targetPackage).sideloadFromZipFile($this$enableTracingColdStart_u24lambda_u241.getLibraryZip$tracing_perfetto_handshake(), $this$enableTracingColdStart_u24lambda_u241.getTempDirectory$tracing_perfetto_handshake(), this.executeShellCommand, $this$enableTracingColdStart_u24lambda_u241.getMoveLibFileFromTmpDirToAppDir$tracing_perfetto_handshake());
        } else {
            file = null;
        }
        File libPath = file;
        killAppProcess.invoke();
        EnableTracingResponse response = this.sendEnableTracingBroadcast(libPath, true, false);
        if (response.getExitCode() == 1) {
            killAppProcess.invoke();
        }
        return response;
    }

    private final EnableTracingResponse sendEnableTracingBroadcast(File libPath, boolean coldStart, Boolean persistent) {
        EnableTracingResponse enableTracingResponse;
        String action = coldStart ? "androidx.tracing.perfetto.action.ENABLE_TRACING_COLD_START" : "androidx.tracing.perfetto.action.ENABLE_TRACING";
        StringBuilder commandBuilder = new StringBuilder("am broadcast -a " + action);
        if (persistent != null) {
            commandBuilder.append(" --es persistent " + persistent);
        }
        if (libPath != null) {
            commandBuilder.append(" --es path " + libPath);
        }
        commandBuilder.append(' ' + this.targetPackage + "/androidx.tracing.perfetto.TracingReceiver");
        String string = commandBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandBuilder.toString()");
        String rawResponse = (String)this.executeShellCommand.invoke((Object)string);
        try {
            enableTracingResponse = this.parseResponse(rawResponse);
        }
        catch (IllegalArgumentException e) {
            String message = "Exception occurred while trying to parse a response. Error: " + e.getMessage() + ". Raw response: " + rawResponse + '.';
            enableTracingResponse = new EnableTracingResponse(99, null, message);
        }
        EnableTracingResponse response = enableTracingResponse;
        return response;
    }

    static /* synthetic */ EnableTracingResponse sendEnableTracingBroadcast$default(PerfettoSdkHandshake perfettoSdkHandshake, File file, boolean bl, Boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            file = null;
        }
        if ((n & 4) != 0) {
            bl2 = null;
        }
        return perfettoSdkHandshake.sendEnableTracingBroadcast(file, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final EnableTracingResponse parseResponse(String rawResponse) {
        String string;
        Object v4;
        Object object;
        String $this$firstOrNull$iv;
        Integer broadcastResponseCode;
        Object object2;
        block10: {
            Object v0;
            Object element$iv;
            block9: {
                void $this$firstOrNull$iv2;
                Object object3 = rawResponse;
                Regex regex = new Regex("\r?\n");
                int n = 0;
                object3 = regex.split((CharSequence)object3, n);
                boolean $i$f$firstOrNull = false;
                object2 = $this$firstOrNull$iv2.iterator();
                while (object2.hasNext()) {
                    element$iv = object2.next();
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"Broadcast completed: result=", (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            String string2 = v0;
            if (string2 == null) {
                throw new IllegalArgumentException("Cannot parse: " + rawResponse);
            }
            String line = string2;
            if (Intrinsics.areEqual((Object)line, (Object)"Broadcast completed: result=0")) {
                return new EnableTracingResponse(0, null, null);
            }
            MatchResult matchResult = new Regex("Broadcast completed: (result=.*?)(, data=\".*?\")?(, extras: .*)?").matchEntire((CharSequence)line);
            if (matchResult == null) {
                throw new IllegalArgumentException("Cannot parse: " + rawResponse);
            }
            MatchResult matchResult2 = matchResult;
            MatchGroup $i$f$firstOrNull = matchResult2.getGroups().get(1);
            broadcastResponseCode = $i$f$firstOrNull != null && (object2 = $i$f$firstOrNull.getValue()) != null && (element$iv = StringsKt.substringAfter$default((String)object2, (String)"result=", null, (int)2, null)) != null ? StringsKt.toIntOrNull(element$iv) : null;
            element$iv = (Iterable)matchResult2.getGroups();
            boolean $i$f$firstOrNull2 = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                Object element$iv2 = object.next();
                MatchGroup it = (MatchGroup)element$iv2;
                boolean bl = false;
                Object object4 = it;
                if (!(object4 != null && (object4 = object4.getValue()) != null ? StringsKt.startsWith$default((String)object4, (String)", data=", (boolean)false, (int)2, null) : false)) continue;
                v4 = element$iv2;
                break block10;
            }
            v4 = null;
        }
        object2 = v4;
        if (object2 == null || ($this$firstOrNull$iv = object2.getValue()) == null || (string = StringsKt.substringAfter$default((String)$this$firstOrNull$iv, (String)", data=\"", null, (int)2, null)) == null || (object = StringsKt.dropLast((String)string, (int)1)) == null) {
            throw new IllegalArgumentException("Cannot parse: " + rawResponse + ". Unable to detect 'data=' section.");
        }
        Object dataString = object;
        Map dataMap = (Map)this.parseJsonMap.invoke(dataString);
        String string3 = (String)dataMap.get("exitCode");
        if (string3 == null) {
            throw new IllegalArgumentException("Response missing exitCode value");
        }
        String string4 = (String)dataMap.get("requiredVersion");
        if (string4 == null) {
            throw new IllegalArgumentException("Response missing requiredVersion value");
        }
        EnableTracingResponse response = new EnableTracingResponse(Integer.parseInt(string3), string4, (String)dataMap.get("message"));
        Integer n = broadcastResponseCode;
        int n2 = response.getExitCode();
        if (n == null || n != n2) {
            throw new IllegalStateException("Cannot parse: " + rawResponse + ". Exit code not matching broadcast exit code.");
        }
        return response;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012:\u0010\u0005\u001a6\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006j\u0002`\f\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fRH\u0010\u0005\u001a6\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0006j\u0002`\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0013"}, d2={"Landroidx/tracing/perfetto/handshake/PerfettoSdkHandshake$LibrarySource;", "", "libraryZip", "Ljava/io/File;", "tempDirectory", "moveLibFileFromTmpDirToAppDir", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "srcFile", "dstFile", "", "Landroidx/tracing/perfetto/handshake/FileMover;", "(Ljava/io/File;Ljava/io/File;Lkotlin/jvm/functions/Function2;)V", "getLibraryZip$tracing_perfetto_handshake", "()Ljava/io/File;", "getMoveLibFileFromTmpDirToAppDir$tracing_perfetto_handshake", "()Lkotlin/jvm/functions/Function2;", "getTempDirectory$tracing_perfetto_handshake", "tracing-perfetto-handshake"})
    public static final class LibrarySource {
        @NotNull
        private final File libraryZip;
        @NotNull
        private final File tempDirectory;
        @NotNull
        private final Function2<File, File, Unit> moveLibFileFromTmpDirToAppDir;

        public LibrarySource(@NotNull File libraryZip, @NotNull File tempDirectory, @NotNull Function2<? super File, ? super File, Unit> moveLibFileFromTmpDirToAppDir) {
            Intrinsics.checkNotNullParameter((Object)libraryZip, (String)"libraryZip");
            Intrinsics.checkNotNullParameter((Object)tempDirectory, (String)"tempDirectory");
            Intrinsics.checkNotNullParameter(moveLibFileFromTmpDirToAppDir, (String)"moveLibFileFromTmpDirToAppDir");
            this.libraryZip = libraryZip;
            this.tempDirectory = tempDirectory;
            this.moveLibFileFromTmpDirToAppDir = moveLibFileFromTmpDirToAppDir;
        }

        @NotNull
        public final File getLibraryZip$tracing_perfetto_handshake() {
            return this.libraryZip;
        }

        @NotNull
        public final File getTempDirectory$tracing_perfetto_handshake() {
            return this.tempDirectory;
        }

        @NotNull
        public final Function2<File, File, Unit> getMoveLibFileFromTmpDirToAppDir$tracing_perfetto_handshake() {
            return this.moveLibFileFromTmpDirToAppDir;
        }
    }
}

