/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto.handshake;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0003H\u0002J/\u0010\n\u001a\u00020\u00032%\u0010\u000b\u001a!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00030\fj\u0002`\u0010H\u0002Jy\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062%\u0010\u0014\u001a!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00030\fj\u0002`\u00102:\u0010\u0015\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0016j\u0002`\u001aJL\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062:\u0010\u001d\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0016j\u0002`\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/tracing/perfetto/handshake/PerfettoSdkSideloader;", "", "packageName", "", "(Ljava/lang/String;)V", "extractPerfettoBinaryFromZip", "Ljava/io/File;", "sourceZip", "outputDir", "abi", "getDeviceAbi", "executeShellCommand", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "command", "Landroidx/tracing/perfetto/handshake/ShellCommandExecutor;", "sideloadFromZipFile", "sourceZipFile", "tempDirectory", "shellCommandExecutor", "moveLibFileFromTmpDirToAppDir", "Lkotlin/Function2;", "srcFile", "dstFile", "", "Landroidx/tracing/perfetto/handshake/FileMover;", "sideloadSoFile", "libFile", "moveLibFileToAppDir", "Companion", "tracing-perfetto-handshake"})
@SourceDebugExtension(value={"SMAP\nPerfettoSdkSideloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoSdkSideloader.kt\nandroidx/tracing/perfetto/handshake/PerfettoSdkSideloader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,113:1\n179#2,2:114\n*S KotlinDebug\n*F\n+ 1 PerfettoSdkSideloader.kt\nandroidx/tracing/perfetto/handshake/PerfettoSdkSideloader\n*L\n84#1:114,2\n*E\n"})
public final class PerfettoSdkSideloader {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String packageName;
    @NotNull
    private static final String libFileName = "libtracing_perfetto.so";

    public PerfettoSdkSideloader(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.packageName = packageName;
    }

    @NotNull
    public final File sideloadFromZipFile(@NotNull File sourceZipFile, @NotNull File tempDirectory, @NotNull Function1<? super String, String> shellCommandExecutor, @NotNull Function2<? super File, ? super File, Unit> moveLibFileFromTmpDirToAppDir) {
        Intrinsics.checkNotNullParameter((Object)sourceZipFile, (String)"sourceZipFile");
        Intrinsics.checkNotNullParameter((Object)tempDirectory, (String)"tempDirectory");
        Intrinsics.checkNotNullParameter(shellCommandExecutor, (String)"shellCommandExecutor");
        Intrinsics.checkNotNullParameter(moveLibFileFromTmpDirToAppDir, (String)"moveLibFileFromTmpDirToAppDir");
        String abi = this.getDeviceAbi(shellCommandExecutor);
        File tmpFile = this.extractPerfettoBinaryFromZip(sourceZipFile, tempDirectory, abi);
        return this.sideloadSoFile(tmpFile, moveLibFileFromTmpDirToAppDir);
    }

    private final File sideloadSoFile(File libFile, Function2<? super File, ? super File, Unit> moveLibFileToAppDir) {
        File dstFile = Companion.libFileForPackageName(this.packageName);
        moveLibFileToAppDir.invoke((Object)libFile, (Object)dstFile);
        return dstFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final File extractPerfettoBinaryFromZip(File sourceZip, File outputDir, String abi) {
        Object v2;
        Object object;
        ZipFile zipFile;
        File outputFile;
        block12: {
            void $this$firstOrNull$iv;
            outputFile = FilesKt.resolve((File)outputDir, (String)libFileName);
            Regex rxLibPathInsideZip = new Regex(".*(lib|jni)/[^/]*" + abi + "[^/]*/libtracing_perfetto.so");
            zipFile = new ZipFile(sourceZip);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zipFile\n            .entries()");
            object = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ZipEntry it = (ZipEntry)element$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (!rxLibPathInsideZip.matches((CharSequence)string)) continue;
                v2 = element$iv;
                break block12;
            }
            v2 = null;
        }
        ZipEntry zipEntry = v2;
        if (zipEntry == null) {
            throw new IllegalStateException("Unable to locate libtracing_perfetto.so required to enable Perfetto SDK. Tried inside " + sourceZip.getAbsolutePath() + '.');
        }
        ZipEntry entry = zipEntry;
        Closeable closeable = zipFile.getInputStream(entry);
        object = null;
        try {
            long l;
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(outputFile);
            Throwable throwable = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
            long l2 = l;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return outputFile;
    }

    private final String getDeviceAbi(Function1<? super String, String> executeShellCommand) {
        String[] stringArray = new String[]{","};
        return ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)((CharSequence)executeShellCommand.invoke((Object)"getprop ro.product.cpu.abilist")), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Object)executeShellCommand.invoke((Object)"getprop ro.product.cpu.abi")))))).toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/tracing/perfetto/handshake/PerfettoSdkSideloader$Companion;", "", "()V", "libFileName", "", "libFileForPackageName", "Ljava/io/File;", "packageName", "tracing-perfetto-handshake"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File libFileForPackageName(@NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            return new File("/sdcard/Android/media/" + packageName + "/libtracing_perfetto.so");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

