/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto.jni;

import androidx.tracing.perfetto.security.SafeLibLoader;
import java.io.File;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@kotlin.Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\t\u0010\u000b\u001a\u00020\u0006H\u0086 J\u0019\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0086 J\t\u0010\u0010\u001a\u00020\u0006H\u0086 J\t\u0010\u0011\u001a\u00020\u0004H\u0086 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/tracing/perfetto/jni/PerfettoNative;", "", "()V", "libraryName", "", "loadLib", "", "file", "Ljava/io/File;", "loader", "Landroidx/tracing/perfetto/security/SafeLibLoader;", "nativeRegisterWithPerfetto", "nativeTraceEventBegin", "key", "", "traceInfo", "nativeTraceEventEnd", "nativeVersion", "Metadata", "tracing-perfetto_release"})
public final class PerfettoNative {
    @NotNull
    public static final PerfettoNative INSTANCE = new PerfettoNative();
    @NotNull
    private static final String libraryName = "tracing_perfetto";

    private PerfettoNative() {
    }

    public final void loadLib() {
        System.loadLibrary(libraryName);
    }

    public final void loadLib(@NotNull File file, @NotNull SafeLibLoader loader) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        loader.loadLib(file, Metadata.INSTANCE.getChecksums());
    }

    public final native void nativeRegisterWithPerfetto();

    public final native void nativeTraceEventBegin(int var1, @NotNull String var2);

    public final native void nativeTraceEventEnd();

    @NotNull
    public final native String nativeVersion();

    @kotlin.Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/tracing/perfetto/jni/PerfettoNative$Metadata;", "", "()V", "checksums", "", "", "getChecksums", "()Ljava/util/Map;", "version", "tracing-perfetto_release"})
    public static final class Metadata {
        @NotNull
        public static final Metadata INSTANCE = new Metadata();
        @NotNull
        public static final String version = "1.0.0-alpha06";
        @NotNull
        private static final Map<String, String> checksums;

        private Metadata() {
        }

        @NotNull
        public final Map<String, String> getChecksums() {
            return checksums;
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"arm64-v8a", (Object)"c8a60a491ef1381c2c95e6281401251dbc9c128a402506bb93681d11cb01e2f7"), TuplesKt.to((Object)"armeabi-v7a", (Object)"1bdd59a655c574d561087389863d110b4193458f6baf7d539847d37516caf477"), TuplesKt.to((Object)"x86", (Object)"889c130b1a028cabf288af1a8f94bc430edf06bb740854ac43073b3db7e59927"), TuplesKt.to((Object)"x86_64", (Object)"2757be9d9b44b59b2c69c0afad68b0e6871e11a53f453bb777911585e0e84086")};
            checksums = MapsKt.mapOf((Pair[])pairArray);
        }
    }
}

