/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto.security;

import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.tracing.perfetto.security.IncorrectChecksumException;
import androidx.tracing.perfetto.security.MissingChecksumException;
import androidx.tracing.perfetto.security.SafeLibLoader;
import androidx.tracing.perfetto.security.UnapprovedLocationException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001c\u0010\u000b\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\rJ\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/tracing/perfetto/security/SafeLibLoader;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "approvedLocations", "", "Ljava/io/File;", "calcSha256Digest", "", "file", "findAbiAwareSha", "abiToShaMap", "", "getCodeCacheDir", "loadLib", "", "abiToSha256Map", "isChildOf", "", "ancestor", "Impl21", "tracing-perfetto_release"})
@SourceDebugExtension(value={"SMAP\nSafeLibLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SafeLibLoader.kt\nandroidx/tracing/perfetto/security/SafeLibLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,92:1\n2624#2,3:93\n1229#3,2:96\n*S KotlinDebug\n*F\n+ 1 SafeLibLoader.kt\nandroidx/tracing/perfetto/security/SafeLibLoader\n*L\n33#1:93,3\n78#1:96,2\n*E\n"})
public final class SafeLibLoader {
    @NotNull
    private final List<File> approvedLocations;

    public SafeLibLoader(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = new File[]{context.getCacheDir(), this.getCodeCacheDir(context)};
        this.approvedLocations = CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    public final void loadLib(@NotNull File file, @NotNull Map<String, String> abiToSha256Map) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(abiToSha256Map, (String)"abiToSha256Map");
            if (!file.exists()) {
                throw new FileNotFoundException("Cannot locate library file: " + file);
            }
            Iterable $this$none$iv = this.approvedLocations;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    File approvedLocation = (File)element$iv;
                    boolean bl2 = false;
                    if (!this.isChildOf(file, approvedLocation)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            throw new UnapprovedLocationException("File is located in a path that is not on the approved list of locations. Approved list: " + this.approvedLocations + '.');
        }
        String expected = this.findAbiAwareSha(abiToSha256Map);
        String actualSha = this.calcSha256Digest(file);
        if (!Intrinsics.areEqual((Object)actualSha, (Object)expected)) {
            throw new IncorrectChecksumException("Invalid checksum for file: " + file + ". Ensure you are using correct version of the library and clear local caches.");
        }
        System.load(file.getAbsolutePath());
    }

    private final String findAbiAwareSha(Map<String, String> abiToShaMap) {
        String string;
        if (Build.VERSION.SDK_INT >= 21) {
            Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
            string = (String)ArraysKt.first((Object[])Build.SUPPORTED_ABIS);
        } else {
            string = Build.CPU_ABI;
        }
        String abi = string;
        Map<String, String> map = abiToShaMap;
        Intrinsics.checkNotNullExpressionValue((Object)abi, (String)"abi");
        String string2 = map.get(abi);
        if (string2 == null) {
            boolean bl = false;
            throw new MissingChecksumException("Cannot locate checksum for ABI: " + abi + " in " + abiToShaMap);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String calcSha256Digest(File file) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] buffer = new byte[1024];
        Closeable closeable = new FileInputStream(file);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            int readCount;
            BufferedInputStream s = (BufferedInputStream)closeable;
            boolean bl = false;
            while ((readCount = s.read(buffer)) > 0) {
                digest.update(buffer, 0, readCount);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)calcSha256Digest.2.INSTANCE, (int)30, null);
    }

    private final boolean isChildOf(File $this$isChildOf, File ancestor) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)$this$isChildOf, (Function1)isChildOf.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)ancestor)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final File getCodeCacheDir(Context context) {
        return Build.VERSION.SDK_INT >= 21 ? Impl21.INSTANCE.getCodeCacheDir(context) : null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/tracing/perfetto/security/SafeLibLoader$Impl21;", "", "()V", "getCodeCacheDir", "Ljava/io/File;", "context", "Landroid/content/Context;", "tracing-perfetto_release"})
    @RequiresApi(value=21)
    private static final class Impl21 {
        @NotNull
        public static final Impl21 INSTANCE = new Impl21();

        private Impl21() {
        }

        @Nullable
        public final File getCodeCacheDir(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return context.getCodeCacheDir();
        }
    }
}

