/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.JsonWriter;
import androidx.annotation.RestrictTo;
import androidx.tracing.perfetto.PerfettoHandshake;
import androidx.tracing.perfetto.Tracing;
import androidx.tracing.perfetto.TracingReceiver;
import java.io.Closeable;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u000e*\u00020\u0010H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Landroidx/tracing/perfetto/TracingReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getExecutor", "()Ljava/util/concurrent/ThreadPoolExecutor;", "executor$delegate", "Lkotlin/Lazy;", "copyExternalLibraryFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "srcPath", "", "enableTracing", "Landroidx/tracing/perfetto/PerfettoHandshake$EnableTracingResponse;", "onReceive", "", "intent", "Landroid/content/Intent;", "toJsonString", "tracing-perfetto_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TracingReceiver
extends BroadcastReceiver {
    @NotNull
    private final Lazy executor$delegate = LazyKt.lazy((Function0)executor.2.INSTANCE);

    private final ThreadPoolExecutor getExecutor() {
        Lazy lazy = this.executor$delegate;
        return (ThreadPoolExecutor)lazy.getValue();
    }

    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        if (intent == null || !Intrinsics.areEqual((Object)intent.getAction(), (Object)"androidx.tracing.perfetto.action.ENABLE_TRACING")) {
            return;
        }
        Bundle bundle = intent.getExtras();
        String srcPath = bundle != null ? bundle.getString("path") : null;
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        this.getExecutor().execute(() -> TracingReceiver.onReceive$lambda$0(this, srcPath, context, pendingResult));
    }

    private final PerfettoHandshake.EnableTracingResponse enableTracing(String srcPath, Context context) {
        PerfettoHandshake.EnableTracingResponse enableTracingResponse;
        if (Build.VERSION.SDK_INT < 30) {
            enableTracingResponse = Tracing.INSTANCE.EnableTracingResponse$tracing_perfetto_release(99, "SDK version not supported. Current minimum SDK = 30");
        } else if (srcPath != null && context != null) {
            PerfettoHandshake.EnableTracingResponse enableTracingResponse2;
            try {
                File dstFile = this.copyExternalLibraryFile(context, srcPath);
                enableTracingResponse2 = Tracing.INSTANCE.enable$tracing_perfetto_release(dstFile, context);
            }
            catch (Exception e) {
                enableTracingResponse2 = Tracing.INSTANCE.EnableTracingResponse$tracing_perfetto_release(99, e);
            }
            enableTracingResponse = enableTracingResponse2;
        } else {
            enableTracingResponse = srcPath != null && context == null ? Tracing.INSTANCE.EnableTracingResponse$tracing_perfetto_release(99, "Cannot copy source file: " + srcPath + " without access to a Context instance.") : Tracing.INSTANCE.enable$tracing_perfetto_release();
        }
        return enableTracingResponse;
    }

    private final File copyExternalLibraryFile(Context context, String srcPath) {
        String string = new File(context.getApplicationInfo().nativeLibraryDir).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(context.application\u2026fo.nativeLibraryDir).name");
        String abi = string;
        File file = context.getCacheDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.cacheDir");
        File dstDir = FilesKt.resolve((File)file, (String)("lib/" + abi));
        dstDir.mkdirs();
        File srcFile = new File(srcPath);
        String string2 = srcFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"srcFile.name");
        File dstFile = FilesKt.resolve((File)dstDir, (String)string2);
        FilesKt.copyTo$default((File)srcFile, (File)dstFile, (boolean)true, (int)0, (int)4, null);
        return dstFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String toJsonString(PerfettoHandshake.EnableTracingResponse $this$toJsonString) {
        StringWriter output = new StringWriter();
        Closeable closeable = (Closeable)new JsonWriter((Writer)output);
        Throwable throwable = null;
        try {
            JsonWriter it = (JsonWriter)closeable;
            boolean bl = false;
            it.beginObject();
            it.name("exitCode");
            it.value((Number)$this$toJsonString.getExitCode());
            it.name("requiredVersion");
            it.value($this$toJsonString.getRequiredVersion());
            String string = $this$toJsonString.getMessage();
            if (string != null) {
                String msg = string;
                boolean bl2 = false;
                it.name("message");
                it.value(msg);
            }
            JsonWriter jsonWriter = it.endObject();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void onReceive$lambda$0(TracingReceiver this$0, String $srcPath, Context $context, BroadcastReceiver.PendingResult $pendingResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            PerfettoHandshake.EnableTracingResponse response = this$0.enableTracing($srcPath, $context);
            $pendingResult.setResult(response.getExitCode(), this$0.toJsonString(response), null);
        }
        finally {
            $pendingResult.finish();
        }
    }
}

