/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.JsonWriter;
import androidx.annotation.RestrictTo;
import androidx.tracing.perfetto.StartupTracingConfig;
import androidx.tracing.perfetto.StartupTracingConfigStore;
import androidx.tracing.perfetto.Tracing;
import androidx.tracing.perfetto.TracingReceiver;
import androidx.tracing.perfetto.internal.handshake.protocol.EnableTracingResponse;
import java.io.Closeable;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010\u0012\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\f\u0010\u0016\u001a\u00020\u000e*\u00020\nH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Landroidx/tracing/perfetto/TracingReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getExecutor", "()Ljava/util/concurrent/ThreadPoolExecutor;", "executor$delegate", "Lkotlin/Lazy;", "enableTracingColdStart", "Landroidx/tracing/perfetto/internal/handshake/protocol/EnableTracingResponse;", "context", "Landroid/content/Context;", "srcPath", "", "isPersistent", "", "enableTracingImmediate", "onReceive", "", "intent", "Landroid/content/Intent;", "toJsonString", "tracing-perfetto_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TracingReceiver
extends BroadcastReceiver {
    @NotNull
    private final Lazy executor$delegate = LazyKt.lazy((Function0)executor.2.INSTANCE);

    private final ThreadPoolExecutor getExecutor() {
        Lazy lazy = this.executor$delegate;
        return (ThreadPoolExecutor)lazy.getValue();
    }

    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        Object[] objectArray;
        if (intent == null || !CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])(objectArray = new String[]{"androidx.tracing.perfetto.action.ENABLE_TRACING", "androidx.tracing.perfetto.action.ENABLE_TRACING_COLD_START"})), (Object)intent.getAction())) {
            return;
        }
        Bundle bundle = intent.getExtras();
        String srcPath = bundle != null ? bundle.getString("path") : null;
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        this.getExecutor().execute(() -> TracingReceiver.onReceive$lambda$0(intent, this, srcPath, context, pendingResult));
    }

    private final EnableTracingResponse enableTracingImmediate(String srcPath, Context context) {
        EnableTracingResponse enableTracingResponse;
        if (Build.VERSION.SDK_INT < 30) {
            enableTracingResponse = Tracing.INSTANCE.EnableTracingResponse$tracing_perfetto_release(99, "SDK version not supported. Current minimum SDK = 30");
        } else if (srcPath != null && context != null) {
            EnableTracingResponse enableTracingResponse2;
            try {
                enableTracingResponse2 = Tracing.INSTANCE.enable$tracing_perfetto_release(new File(srcPath), context);
            }
            catch (Exception e) {
                enableTracingResponse2 = Tracing.INSTANCE.EnableTracingResponse$tracing_perfetto_release(99, e);
            }
            enableTracingResponse = enableTracingResponse2;
        } else {
            enableTracingResponse = srcPath != null && context == null ? Tracing.INSTANCE.EnableTracingResponse$tracing_perfetto_release(99, "Cannot copy source file: " + srcPath + " without access to a Context instance.") : Tracing.INSTANCE.enable$tracing_perfetto_release();
        }
        return enableTracingResponse;
    }

    private final EnableTracingResponse enableTracingColdStart(Context context, String srcPath, boolean isPersistent) {
        EnableTracingResponse enableTracingResponse;
        EnableTracingResponse it = enableTracingResponse = this.enableTracingImmediate(srcPath, context);
        boolean bl = false;
        if (it.getExitCode() == 1) {
            StartupTracingConfig config = new StartupTracingConfig(srcPath, isPersistent);
            if (context == null) {
                return Tracing.INSTANCE.EnableTracingResponse$tracing_perfetto_release(99, "Cannot set up cold start tracing without a Context instance.");
            }
            String string = context.getApplicationInfo().packageName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.applicationInfo.packageName");
            StartupTracingConfigStore.INSTANCE.store(config, string);
        }
        return enableTracingResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String toJsonString(EnableTracingResponse $this$toJsonString) {
        StringWriter output = new StringWriter();
        Closeable closeable = (Closeable)new JsonWriter((Writer)output);
        Throwable throwable = null;
        try {
            JsonWriter it = (JsonWriter)closeable;
            boolean bl = false;
            it.beginObject();
            it.name("exitCode");
            it.value((Number)$this$toJsonString.getExitCode());
            it.name("requiredVersion");
            it.value($this$toJsonString.getRequiredVersion());
            String string = $this$toJsonString.getMessage();
            if (string != null) {
                String msg = string;
                boolean bl2 = false;
                it.name("message");
                it.value(msg);
            }
            JsonWriter jsonWriter = it.endObject();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void onReceive$lambda$0(Intent $intent, TracingReceiver this$0, String $srcPath, Context $context, BroadcastReceiver.PendingResult $pendingResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            EnableTracingResponse enableTracingResponse;
            String string = $intent.getAction();
            if (string == null) throw new IllegalStateException();
            int n = -1;
            switch (string.hashCode()) {
                case -72159468: {
                    if (string.equals("androidx.tracing.perfetto.action.ENABLE_TRACING")) {
                        n = 1;
                    }
                    break;
                }
                case 274599218: {
                    if (string.equals("androidx.tracing.perfetto.action.ENABLE_TRACING_COLD_START")) {
                        n = 2;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    enableTracingResponse = this$0.enableTracingImmediate($srcPath, $context);
                    break;
                }
                case 2: {
                    Bundle bundle = $intent.getExtras();
                    enableTracingResponse = this$0.enableTracingColdStart($context, $srcPath, bundle != null ? bundle.getBoolean("persistent") : false);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            EnableTracingResponse response = enableTracingResponse;
            $pendingResult.setResult(response.getExitCode(), this$0.toJsonString(response), null);
            return;
        }
        finally {
            $pendingResult.finish();
        }
    }
}

