/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto;

import androidx.annotation.RestrictTo;
import androidx.tracing.perfetto.StartupTracingConfig;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0014\u0010\u000e\u001a\u00020\b*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u000e\u001a\u00020\b*\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/tracing/perfetto/StartupTracingConfigStore;", "", "()V", "KEY_IS_PERSISTENT", "", "KEY_LIB_FILE_PATH", "STARTUP_CONFIG_FILE_NAME", "clear", "", "packageName", "load", "Landroidx/tracing/perfetto/StartupTracingConfig;", "startupConfigFileForPackageName", "Ljava/io/File;", "store", "writer", "Ljava/io/Writer;", "tracing-perfetto_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nStartupTracingConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartupTracingConfig.kt\nandroidx/tracing/perfetto/StartupTracingConfigStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class StartupTracingConfigStore {
    @NotNull
    public static final StartupTracingConfigStore INSTANCE = new StartupTracingConfigStore();
    @NotNull
    private static final String KEY_IS_PERSISTENT = "isPersistent";
    @NotNull
    private static final String KEY_LIB_FILE_PATH = "libtracingPerfettoFilePath";
    @NotNull
    private static final String STARTUP_CONFIG_FILE_NAME = "libtracing_perfetto_startup.properties";

    private StartupTracingConfigStore() {
    }

    private final File startupConfigFileForPackageName(String packageName) {
        return new File("/sdcard/Android/media/" + packageName + "/libtracing_perfetto_startup.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final StartupTracingConfig load(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        File propertiesFile = this.startupConfigFileForPackageName(packageName);
        if (!propertiesFile.exists()) {
            return null;
        }
        Properties properties = new Properties();
        Object object = propertiesFile;
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            InputStreamReader it = (InputStreamReader)object;
            boolean bl = false;
            properties.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return new StartupTracingConfig(properties.getProperty(KEY_LIB_FILE_PATH), Boolean.parseBoolean(properties.getProperty(KEY_IS_PERSISTENT)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store(@NotNull StartupTracingConfig $this$store, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)$this$store, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Object object = this.startupConfigFileForPackageName(packageName);
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl = false;
            INSTANCE.store($this$store, it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private final void store(StartupTracingConfig $this$store, Writer writer) {
        Properties properties;
        Properties it = properties = new Properties();
        boolean bl = false;
        it.setProperty(KEY_LIB_FILE_PATH, $this$store.getLibFilePath());
        it.setProperty(KEY_IS_PERSISTENT, String.valueOf($this$store.isPersistent()));
        properties.store(writer, null);
    }

    public final void clear(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.startupConfigFileForPackageName(packageName).delete();
    }
}

