/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.startup.Initializer;
import androidx.tracing.perfetto.PerfettoSdkTrace;
import androidx.tracing.perfetto.StartupTracingConfig;
import androidx.tracing.perfetto.StartupTracingConfigStore;
import androidx.tracing.perfetto.internal.handshake.protocol.Response;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00010\t0\bH\u0016\u00a8\u0006\u000b"}, d2={"Landroidx/tracing/perfetto/StartupTracingInitializer;", "Landroidx/startup/Initializer;", "", "()V", "create", "context", "Landroid/content/Context;", "dependencies", "", "Ljava/lang/Class;", "Companion", "tracing-perfetto_release"})
public final class StartupTracingInitializer
implements Initializer<Unit> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private static final String TAG = StartupTracingInitializer.class.getName();

    public void create(@NotNull Context context) {
        String libFilePath;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 30) {
            return;
        }
        String packageName = context.getApplicationInfo().packageName;
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        StartupTracingConfig startupTracingConfig = StartupTracingConfigStore.INSTANCE.load(packageName);
        if (startupTracingConfig == null) {
            return;
        }
        StartupTracingConfig config = startupTracingConfig;
        if (!config.isPersistent()) {
            StartupTracingConfigStore.INSTANCE.clear(packageName);
        }
        Response enableTracingResponse = (libFilePath = config.getLibFilePath()) == null ? PerfettoSdkTrace.INSTANCE.enable$tracing_perfetto_release() : PerfettoSdkTrace.INSTANCE.enable$tracing_perfetto_release(new File(libFilePath), context);
        Log.d((String)TAG, (String)(Response.class.getName() + ": { resultCode: " + enableTracingResponse.getResultCode() + ", message: " + enableTracingResponse.getMessage() + ", requiredVersion: " + enableTracingResponse.getRequiredVersion() + " }"));
    }

    @NotNull
    public List<Class<? extends Initializer<?>>> dependencies() {
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/tracing/perfetto/StartupTracingInitializer$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "tracing-perfetto_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

