/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto;

import android.content.Context;
import androidx.annotation.RequiresApi;
import androidx.tracing.perfetto.internal.handshake.protocol.Response;
import androidx.tracing.perfetto.jni.PerfettoNative;
import androidx.tracing.perfetto.security.IncorrectChecksumException;
import androidx.tracing.perfetto.security.SafeLibLoader;
import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eJ\r\u0010\u0015\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u0016J\u001e\u0010\u0015\u001a\u00020\n2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001cH\u0003J\u001e\u0010\u001d\u001a\u00020\n2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001cH\u0003J\u0006\u0010\u001e\u001a\u00020\u0013J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006!"}, d2={"Landroidx/tracing/perfetto/PerfettoSdkTrace;", "", "()V", "enableTracingLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "<set-?>", "", "isEnabled", "()Z", "Response", "Landroidx/tracing/perfetto/internal/handshake/protocol/Response;", "resultCode", "", "message", "", "Response$tracing_perfetto_release", "exception", "", "beginSection", "", "sectionName", "enable", "enable$tracing_perfetto_release", "file", "Ljava/io/File;", "context", "Landroid/content/Context;", "descriptor", "Lkotlin/Pair;", "enableImpl", "endSection", "errorMessage", "t", "tracing-perfetto_release"})
@SourceDebugExtension(value={"SMAP\nPerfettoSdkTrace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfettoSdkTrace.kt\nandroidx/tracing/perfetto/PerfettoSdkTrace\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class PerfettoSdkTrace {
    @NotNull
    public static final PerfettoSdkTrace INSTANCE = new PerfettoSdkTrace();
    private static boolean isEnabled;
    @NotNull
    private static final ReentrantReadWriteLock enableTracingLock;

    private PerfettoSdkTrace() {
    }

    public final boolean isEnabled() {
        return isEnabled;
    }

    @RequiresApi(value=30)
    @NotNull
    public final Response enable$tracing_perfetto_release() {
        return this.enable(null);
    }

    @RequiresApi(value=30)
    @NotNull
    public final Response enable$tracing_perfetto_release(@NotNull File file, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.enable((Pair<? extends File, ? extends Context>)TuplesKt.to((Object)file, (Object)context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=30)
    private final Response enable(Pair<? extends File, ? extends Context> descriptor) {
        ReentrantReadWriteLock.ReadLock readLock = enableTracingLock.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"enableTracingLock.readLock()");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            if (isEnabled) {
                Response response = PerfettoSdkTrace.Response$tracing_perfetto_release$default(INSTANCE, 2, null, 2, null);
                return response;
            }
            Unit $i$a$-withLock-PerfettoSdkTrace$enable$3 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = enableTracingLock.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"enableTracingLock.writeLock()");
        lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            Response response = INSTANCE.enableImpl(descriptor);
            return response;
        }
        finally {
            lock.unlock();
        }
    }

    @RequiresApi(value=30)
    private final Response enableImpl(Pair<? extends File, ? extends Context> descriptor) {
        if (!enableTracingLock.isWriteLockedByCurrentThread()) {
            throw new RuntimeException();
        }
        if (isEnabled) {
            return PerfettoSdkTrace.Response$tracing_perfetto_release$default(this, 2, null, 2, null);
        }
        try {
            if (descriptor == null) {
                PerfettoNative.INSTANCE.loadLib();
            } else {
                Pair<? extends File, ? extends Context> pair = descriptor;
                boolean bl = false;
                File file = (File)pair.component1();
                Context context = (Context)pair.component2();
                PerfettoNative.INSTANCE.loadLib(file, new SafeLibLoader(context));
            }
        }
        catch (Throwable t) {
            Response response;
            Throwable throwable = t;
            if (throwable instanceof IncorrectChecksumException) {
                response = this.Response$tracing_perfetto_release(13, t);
            } else if (throwable instanceof UnsatisfiedLinkError) {
                response = this.Response$tracing_perfetto_release(11, t);
            } else if (throwable instanceof Exception) {
                response = this.Response$tracing_perfetto_release(99, t);
            } else {
                throw t;
            }
            return response;
        }
        String nativeVersion = PerfettoNative.nativeVersion();
        String javaVersion = "1.0.0-beta02";
        if (!Intrinsics.areEqual((Object)nativeVersion, (Object)javaVersion)) {
            return this.Response$tracing_perfetto_release(12, "Binary and Java version mismatch. Binary: " + nativeVersion + ". Java: " + javaVersion);
        }
        try {
            PerfettoNative.nativeRegisterWithPerfetto();
        }
        catch (Exception e) {
            return this.Response$tracing_perfetto_release(99, e);
        }
        isEnabled = true;
        return PerfettoSdkTrace.Response$tracing_perfetto_release$default(this, 1, null, 2, null);
    }

    public final void beginSection(@NotNull String sectionName) {
        Intrinsics.checkNotNullParameter((Object)sectionName, (String)"sectionName");
        if (isEnabled) {
            PerfettoNative.nativeTraceEventBegin(0, sectionName);
        }
    }

    public final void endSection() {
        if (isEnabled) {
            PerfettoNative.nativeTraceEventEnd();
        }
    }

    private final String errorMessage(Throwable t) {
        Throwable $this$errorMessage_u24lambda_u243 = t;
        boolean bl = false;
        return $this$errorMessage_u24lambda_u243.getClass().getName() + ($this$errorMessage_u24lambda_u243.getMessage() != null ? ": " + $this$errorMessage_u24lambda_u243.getMessage() : "");
    }

    @NotNull
    public final Response Response$tracing_perfetto_release(int resultCode, @Nullable String message) {
        return new Response(resultCode, "1.0.0-beta02", message);
    }

    public static /* synthetic */ Response Response$tracing_perfetto_release$default(PerfettoSdkTrace perfettoSdkTrace, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        return perfettoSdkTrace.Response$tracing_perfetto_release(n, string);
    }

    @NotNull
    public final Response Response$tracing_perfetto_release(int resultCode, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        return this.Response$tracing_perfetto_release(resultCode, this.errorMessage(exception));
    }

    static {
        enableTracingLock = new ReentrantReadWriteLock();
    }
}

