/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing.perfetto;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.JsonWriter;
import androidx.annotation.RestrictTo;
import androidx.tracing.perfetto.PerfettoSdkTrace;
import androidx.tracing.perfetto.StartupTracingConfig;
import androidx.tracing.perfetto.StartupTracingConfigStore;
import androidx.tracing.perfetto.TracingReceiver;
import androidx.tracing.perfetto.internal.handshake.protocol.Response;
import java.io.Closeable;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J$\u0010\r\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\f\u0010\u0017\u001a\u00020\u000f*\u00020\nH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Landroidx/tracing/perfetto/TracingReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getExecutor", "()Ljava/util/concurrent/ThreadPoolExecutor;", "executor$delegate", "Lkotlin/Lazy;", "disableTracingColdStart", "Landroidx/tracing/perfetto/internal/handshake/protocol/Response;", "context", "Landroid/content/Context;", "enableTracingColdStart", "srcPath", "", "isPersistent", "", "enableTracingImmediate", "onReceive", "", "intent", "Landroid/content/Intent;", "toJsonString", "tracing-perfetto_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TracingReceiver
extends BroadcastReceiver {
    @NotNull
    private final Lazy executor$delegate = LazyKt.lazy((Function0)executor.2.INSTANCE);

    private final ThreadPoolExecutor getExecutor() {
        Lazy lazy = this.executor$delegate;
        return (ThreadPoolExecutor)lazy.getValue();
    }

    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        Object[] objectArray;
        if (intent == null || !CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])(objectArray = new String[]{"androidx.tracing.perfetto.action.ENABLE_TRACING", "androidx.tracing.perfetto.action.ENABLE_TRACING_COLD_START", "androidx.tracing.perfetto.action.DISABLE_TRACING_COLD_START"})), (Object)intent.getAction())) {
            return;
        }
        Bundle bundle = intent.getExtras();
        String srcPath = bundle != null ? bundle.getString("path") : null;
        BroadcastReceiver.PendingResult pendingResult = this.goAsync();
        this.getExecutor().execute(() -> TracingReceiver.onReceive$lambda$0(intent, this, srcPath, context, pendingResult));
    }

    private final Response enableTracingImmediate(String srcPath, Context context) {
        Response response;
        if (Build.VERSION.SDK_INT < 30) {
            response = PerfettoSdkTrace.INSTANCE.Response$tracing_perfetto_release(99, "SDK version not supported. Current minimum SDK = 30");
        } else if (srcPath != null && context != null) {
            Response response2;
            try {
                response2 = PerfettoSdkTrace.INSTANCE.enable$tracing_perfetto_release(new File(srcPath), context);
            }
            catch (Exception e) {
                response2 = PerfettoSdkTrace.INSTANCE.Response$tracing_perfetto_release(99, e);
            }
            response = response2;
        } else {
            response = srcPath != null && context == null ? PerfettoSdkTrace.INSTANCE.Response$tracing_perfetto_release(99, "Cannot copy source file: " + srcPath + " without access to a Context instance.") : PerfettoSdkTrace.INSTANCE.enable$tracing_perfetto_release();
        }
        return response;
    }

    private final Response enableTracingColdStart(Context context, String srcPath, boolean isPersistent) {
        Response response;
        Response it = response = this.enableTracingImmediate(srcPath, context);
        boolean bl = false;
        if (it.getResultCode() == 1) {
            StartupTracingConfig config = new StartupTracingConfig(srcPath, isPersistent);
            if (context == null) {
                return PerfettoSdkTrace.INSTANCE.Response$tracing_perfetto_release(99, "Cannot set up cold start tracing without a Context instance.");
            }
            StartupTracingConfigStore.INSTANCE.store(config, context);
        }
        return response;
    }

    private final Response disableTracingColdStart(Context context) {
        Response response;
        if (context != null) {
            StartupTracingConfigStore.INSTANCE.clear(context);
            response = PerfettoSdkTrace.Response$tracing_perfetto_release$default(PerfettoSdkTrace.INSTANCE, 1, null, 2, null);
        } else {
            response = PerfettoSdkTrace.INSTANCE.Response$tracing_perfetto_release(99, "Cannot ensure we can disable cold start tracing without access to an app Context instance");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String toJsonString(Response $this$toJsonString) {
        StringWriter output = new StringWriter();
        Closeable closeable = (Closeable)new JsonWriter((Writer)output);
        Throwable throwable = null;
        try {
            JsonWriter it = (JsonWriter)closeable;
            boolean bl = false;
            it.beginObject();
            it.name("exitCode");
            it.value((Number)$this$toJsonString.getResultCode());
            it.name("requiredVersion");
            it.value($this$toJsonString.getRequiredVersion());
            String string = $this$toJsonString.getMessage();
            if (string != null) {
                String msg = string;
                boolean bl2 = false;
                it.name("message");
                it.value(msg);
            }
            JsonWriter jsonWriter = it.endObject();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void onReceive$lambda$0(Intent $intent, TracingReceiver this$0, String $srcPath, Context $context, BroadcastReceiver.PendingResult $pendingResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            Response response;
            String string = $intent.getAction();
            if (string == null) throw new IllegalStateException();
            int n = -1;
            switch (string.hashCode()) {
                case -190038551: {
                    if (string.equals("androidx.tracing.perfetto.action.DISABLE_TRACING_COLD_START")) {
                        n = 1;
                    }
                    break;
                }
                case -72159468: {
                    if (string.equals("androidx.tracing.perfetto.action.ENABLE_TRACING")) {
                        n = 2;
                    }
                    break;
                }
                case 274599218: {
                    if (string.equals("androidx.tracing.perfetto.action.ENABLE_TRACING_COLD_START")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    response = this$0.enableTracingImmediate($srcPath, $context);
                    break;
                }
                case 3: {
                    Bundle bundle = $intent.getExtras();
                    response = this$0.enableTracingColdStart($context, $srcPath, Boolean.parseBoolean(bundle != null ? bundle.getString("persistent") : null));
                    break;
                }
                case 1: {
                    response = this$0.disableTracingColdStart($context);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Response response2 = response;
            $pendingResult.setResult(response2.getResultCode(), this$0.toJsonString(response2), null);
            return;
        }
        finally {
            $pendingResult.finish();
        }
    }
}

