/*
 * Decompiled with CFR 0.152.
 */
package androidx.text;

import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.text.LayoutCompat;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u00c4\u0001\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0003\u0010\u0017\u001a\u00020\u000e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0003\u0010\u001a\u001a\u00020\u000e2\b\b\u0003\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u000e2\b\b\u0002\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u00062\b\b\u0002\u0010!\u001a\u00020\u000e2\b\b\u0002\u0010\"\u001a\u00020\u000e2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010$J\b\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Landroidx/text/StaticLayoutFactory;", "", "()V", "TAG", "", "isInitialized", "", "staticLayoutConstructor", "Ljava/lang/reflect/Constructor;", "Landroid/text/StaticLayout;", "create", "text", "", "start", "", "end", "paint", "Landroid/text/TextPaint;", "width", "textDir", "Landroid/text/TextDirectionHeuristic;", "alignment", "Landroid/text/Layout$Alignment;", "maxLines", "ellipsize", "Landroid/text/TextUtils$TruncateAt;", "ellipsizedWidth", "lineSpacingMultiplier", "", "lineSpacingExtra", "justificationMode", "includePadding", "fallbackLineSpacing", "breakStrategy", "hyphenationFrequency", "leftIndents", "", "rightIndents", "obtainStaticLayoutConstructor", "", "ui-android-text_release"})
public final class StaticLayoutFactory {
    private static final String TAG = "StaticLayoutFactory";
    private static boolean isInitialized;
    private static Constructor<StaticLayout> staticLayoutConstructor;
    public static final StaticLayoutFactory INSTANCE;

    private final void obtainStaticLayoutConstructor() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        try {
            staticLayoutConstructor = StaticLayout.class.getConstructor(CharSequence.class, Integer.TYPE, Integer.TYPE, TextPaint.class, Integer.TYPE, Layout.Alignment.class, TextDirectionHeuristic.class, Float.TYPE, Float.TYPE, Boolean.TYPE, TextUtils.TruncateAt.class, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            staticLayoutConstructor = null;
            Log.e((String)TAG, (String)"unable to collect necessary constructor.");
        }
    }

    @NotNull
    public final StaticLayout create(@NotNull CharSequence text, int start, int end, @NotNull TextPaint paint, int width, @NotNull TextDirectionHeuristic textDir, @NotNull Layout.Alignment alignment, @IntRange(from=0L) int maxLines, @Nullable TextUtils.TruncateAt ellipsize, @IntRange(from=0L) int ellipsizedWidth, @FloatRange(from=0.0) float lineSpacingMultiplier, float lineSpacingExtra, int justificationMode, boolean includePadding, boolean fallbackLineSpacing, int breakStrategy, int hyphenationFrequency, @Nullable int[] leftIndents, @Nullable int[] rightIndents) {
        StaticLayout staticLayout;
        block16: {
            block17: {
                StaticLayout staticLayout2;
                boolean bl;
                boolean bl2;
                block15: {
                    Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                    Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
                    Intrinsics.checkParameterIsNotNull((Object)textDir, (String)"textDir");
                    Intrinsics.checkParameterIsNotNull((Object)alignment, (String)"alignment");
                    int n = start;
                    n = 0 <= n && end >= n ? 1 : 0;
                    bl2 = false;
                    bl = false;
                    bl = false;
                    boolean bl3 = false;
                    if (n == 0) {
                        boolean bl4 = false;
                        String string = "Failed requirement.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    n = end;
                    n = 0 <= n && text.length() >= n ? 1 : 0;
                    bl2 = false;
                    bl = false;
                    bl = false;
                    bl3 = false;
                    if (n == 0) {
                        boolean bl5 = false;
                        String string = "Failed requirement.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    n = maxLines >= 0 ? 1 : 0;
                    bl2 = false;
                    bl = false;
                    bl = false;
                    bl3 = false;
                    if (n == 0) {
                        boolean bl6 = false;
                        String string = "Failed requirement.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    n = width >= 0 ? 1 : 0;
                    bl2 = false;
                    bl = false;
                    bl = false;
                    bl3 = false;
                    if (n == 0) {
                        boolean bl7 = false;
                        String string = "Failed requirement.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    n = ellipsizedWidth >= 0 ? 1 : 0;
                    bl2 = false;
                    bl = false;
                    bl = false;
                    bl3 = false;
                    if (n == 0) {
                        boolean bl8 = false;
                        String string = "Failed requirement.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    n = lineSpacingMultiplier >= 0.0f ? 1 : 0;
                    bl2 = false;
                    bl = false;
                    bl = false;
                    bl3 = false;
                    if (n == 0) {
                        boolean bl9 = false;
                        String string = "Failed requirement.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    if (Build.VERSION.SDK_INT < 23) break block15;
                    StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)text, (int)start, (int)end, (TextPaint)paint, (int)width);
                    bl2 = false;
                    bl = false;
                    StaticLayout.Builder $this$apply = builder;
                    boolean bl10 = false;
                    $this$apply.setTextDirection(textDir);
                    $this$apply.setAlignment(alignment);
                    $this$apply.setMaxLines(maxLines);
                    $this$apply.setEllipsize(ellipsize);
                    $this$apply.setEllipsizedWidth(ellipsizedWidth);
                    $this$apply.setLineSpacing(lineSpacingExtra, lineSpacingMultiplier);
                    if (Build.VERSION.SDK_INT >= 26) {
                        $this$apply.setJustificationMode(justificationMode);
                    }
                    $this$apply.setIncludePad(includePadding);
                    if (Build.VERSION.SDK_INT >= 28) {
                        $this$apply.setUseLineSpacingFromFallbacks(fallbackLineSpacing);
                    }
                    $this$apply.setBreakStrategy(breakStrategy);
                    $this$apply.setHyphenationFrequency(hyphenationFrequency);
                    $this$apply.setIndents(leftIndents, rightIndents);
                    StaticLayout staticLayout3 = builder.build();
                    staticLayout = staticLayout3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)staticLayout3, (String)"Builder.obtain(text, sta\u2026                }.build()");
                    break block16;
                }
                this.obtainStaticLayoutConstructor();
                staticLayout = staticLayoutConstructor;
                if (staticLayout == null) break block17;
                StaticLayout staticLayout4 = staticLayout;
                bl2 = false;
                bl = false;
                StaticLayout it = staticLayout4;
                boolean bl11 = false;
                try {
                    staticLayout2 = (StaticLayout)it.newInstance(text, start, end, paint, width, alignment, textDir, Float.valueOf(lineSpacingMultiplier), Float.valueOf(lineSpacingExtra), includePadding, ellipsize, ellipsizedWidth, maxLines);
                }
                catch (IllegalAccessException e) {
                    staticLayoutConstructor = null;
                    Log.e((String)TAG, (String)"unable to call constructor");
                    staticLayout2 = null;
                }
                catch (InstantiationException e) {
                    staticLayoutConstructor = null;
                    Log.e((String)TAG, (String)"unable to call constructor");
                    staticLayout2 = null;
                }
                catch (InvocationTargetException e) {
                    staticLayoutConstructor = null;
                    Log.e((String)TAG, (String)"unable to call constructor");
                    staticLayout2 = null;
                }
                StaticLayout staticLayout5 = staticLayout2;
                staticLayout = staticLayout5;
                if (staticLayout5 != null) break block16;
            }
            staticLayout = new StaticLayout(text, start, end, paint, width, alignment, lineSpacingMultiplier, lineSpacingExtra, includePadding, ellipsize, ellipsizedWidth);
        }
        return staticLayout;
    }

    public static /* synthetic */ StaticLayout create$default(StaticLayoutFactory staticLayoutFactory, CharSequence charSequence, int n, int n2, TextPaint textPaint, int n3, TextDirectionHeuristic textDirectionHeuristic, Layout.Alignment alignment, int n4, TextUtils.TruncateAt truncateAt, int n5, float f, float f2, int n6, boolean bl, boolean bl2, int n7, int n8, int[] nArray, int[] nArray2, int n9, Object object) {
        if ((n9 & 2) != 0) {
            n = 0;
        }
        if ((n9 & 4) != 0) {
            n2 = charSequence.length();
        }
        if ((n9 & 0x20) != 0) {
            textDirectionHeuristic = LayoutCompat.INSTANCE.getDEFAULT_TEXT_DIRECTION_HEURISTIC();
        }
        if ((n9 & 0x40) != 0) {
            alignment = LayoutCompat.INSTANCE.getDEFAULT_LAYOUT_ALIGNMENT();
        }
        if ((n9 & 0x80) != 0) {
            n4 = Integer.MAX_VALUE;
        }
        if ((n9 & 0x100) != 0) {
            truncateAt = null;
        }
        if ((n9 & 0x200) != 0) {
            n5 = n3;
        }
        if ((n9 & 0x400) != 0) {
            f = 1.0f;
        }
        if ((n9 & 0x800) != 0) {
            f2 = 0.0f;
        }
        if ((n9 & 0x1000) != 0) {
            n6 = 0;
        }
        if ((n9 & 0x2000) != 0) {
            bl = true;
        }
        if ((n9 & 0x4000) != 0) {
            bl2 = true;
        }
        if ((n9 & 0x8000) != 0) {
            n7 = 0;
        }
        if ((n9 & 0x10000) != 0) {
            n8 = 0;
        }
        if ((n9 & 0x20000) != 0) {
            nArray = null;
        }
        if ((n9 & 0x40000) != 0) {
            nArray2 = null;
        }
        return staticLayoutFactory.create(charSequence, n, n2, textPaint, n3, textDirectionHeuristic, alignment, n4, truncateAt, n5, f, f2, n6, bl, bl2, n7, n8, nArray, nArray2);
    }

    private StaticLayoutFactory() {
    }

    static {
        StaticLayoutFactory staticLayoutFactory;
        INSTANCE = staticLayoutFactory = new StaticLayoutFactory();
    }
}

