/*
 * Decompiled with CFR 0.152.
 */
package androidx.text.selection;

import androidx.annotation.RestrictTo;
import androidx.text.selection.WordIterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/text/selection/WordBoundary;", "", "locale", "Ljava/util/Locale;", "text", "", "(Ljava/util/Locale;Ljava/lang/CharSequence;)V", "wordIterator", "Landroidx/text/selection/WordIterator;", "getWordEnd", "", "offset", "getWordStart", "ui-android-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class WordBoundary {
    private final WordIterator wordIterator;

    public final int getWordStart(int offset) {
        int retOffset = this.wordIterator.prevBoundary(offset);
        retOffset = this.wordIterator.isOnPunctuation(retOffset) ? this.wordIterator.getPunctuationBeginning(offset) : this.wordIterator.getPrevWordBeginningOnTwoWordsBoundary(offset);
        return retOffset == -1 ? offset : retOffset;
    }

    public final int getWordEnd(int offset) {
        int retOffset = this.wordIterator.nextBoundary(offset);
        retOffset = this.wordIterator.isAfterPunctuation(retOffset) ? this.wordIterator.getPunctuationEnd(offset) : this.wordIterator.getNextWordEndOnTwoWordBoundary(offset);
        return retOffset == -1 ? offset : retOffset;
    }

    public WordBoundary(@NotNull Locale locale, @NotNull CharSequence text) {
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.wordIterator = new WordIterator(text, 0, text.length(), locale);
    }
}

