/*
 * Decompiled with CFR 0.152.
 */
package androidx.text.style;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.style.ReplacementSpan;
import androidx.annotation.RestrictTo;
import androidx.text.style.PlaceholderSpanKt;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJR\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%H\u0016J4\u0010&\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\b\u0010'\u001a\u0004\u0018\u00010\fH\u0016R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Landroidx/text/style/PlaceholderSpan;", "Landroid/text/style/ReplacementSpan;", "width", "", "widthUnit", "", "height", "heightUnit", "pxPerSp", "verticalAlign", "(FIFIFI)V", "<set-?>", "Landroid/graphics/Paint$FontMetricsInt;", "fontMetrics", "getFontMetrics", "()Landroid/graphics/Paint$FontMetricsInt;", "heightPx", "getHeightPx", "()I", "isLaidOut", "", "getVerticalAlign", "widthPx", "getWidthPx", "draw", "", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "end", "x", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getSize", "fm", "Companion", "ui-android-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PlaceholderSpan
extends ReplacementSpan {
    @NotNull
    private Paint.FontMetricsInt fontMetrics;
    private int widthPx;
    private int heightPx;
    private boolean isLaidOut;
    private final float width;
    private final int widthUnit;
    private final float height;
    private final int heightUnit;
    private final float pxPerSp;
    private final int verticalAlign;
    public static final int ALIGN_ABOVE_BASELINE = 0;
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_BOTTOM = 2;
    public static final int ALIGN_CENTER = 3;
    public static final int ALIGN_TEXT_TOP = 4;
    public static final int ALIGN_TEXT_BOTTOM = 5;
    public static final int ALIGN_TEXT_CENTER = 6;
    public static final int UNIT_SP = 0;
    public static final int UNIT_EM = 1;
    public static final int UNIT_INHERIT = 2;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Paint.FontMetricsInt getFontMetrics() {
        Paint.FontMetricsInt fontMetricsInt = this.fontMetrics;
        if (fontMetricsInt == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fontMetrics");
        }
        return fontMetricsInt;
    }

    public final int getWidthPx() {
        boolean bl = this.isLaidOut;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "PlaceholderSpan is not laid out yet.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.widthPx;
    }

    public final int getHeightPx() {
        boolean bl = this.isLaidOut;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "PlaceholderSpan is not laid out yet.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.heightPx;
    }

    public int getSize(@NotNull Paint paint, @Nullable CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
        block22: {
            int n;
            int n2;
            float f;
            Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
            this.isLaidOut = true;
            float fontSize = paint.getTextSize();
            Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
            Intrinsics.checkExpressionValueIsNotNull((Object)fontMetricsInt, (String)"paint.fontMetricsInt");
            Paint.FontMetricsInt fontMetricsInt2 = this.fontMetrics = fontMetricsInt;
            if (fontMetricsInt2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fontMetrics");
            }
            int n3 = fontMetricsInt2.descent;
            Paint.FontMetricsInt fontMetricsInt3 = this.fontMetrics;
            if (fontMetricsInt3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fontMetrics");
            }
            boolean bl = n3 > fontMetricsInt3.ascent;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Invalid fontMetrics: line height can not be negative.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            switch (this.widthUnit) {
                case 0: {
                    f = this.width * this.pxPerSp;
                    break;
                }
                case 1: {
                    f = this.width * fontSize;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unsupported unit.");
                }
            }
            this.widthPx = PlaceholderSpanKt.ceilToInt(f);
            switch (this.heightUnit) {
                case 0: {
                    n2 = PlaceholderSpanKt.ceilToInt(this.height * this.pxPerSp);
                    break;
                }
                case 1: {
                    n2 = PlaceholderSpanKt.ceilToInt(this.height * fontSize);
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unsupported unit.");
                }
            }
            this.heightPx = n2;
            Paint.FontMetricsInt fontMetricsInt4 = fm;
            if (fontMetricsInt4 == null) break block22;
            Paint.FontMetricsInt fontMetricsInt5 = fontMetricsInt4;
            bl2 = false;
            bl3 = false;
            Paint.FontMetricsInt $this$apply = fontMetricsInt5;
            boolean bl5 = false;
            Paint.FontMetricsInt fontMetricsInt6 = this.fontMetrics;
            if (fontMetricsInt6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fontMetrics");
            }
            $this$apply.ascent = fontMetricsInt6.ascent;
            Paint.FontMetricsInt fontMetricsInt7 = this.fontMetrics;
            if (fontMetricsInt7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fontMetrics");
            }
            $this$apply.descent = fontMetricsInt7.descent;
            Paint.FontMetricsInt fontMetricsInt8 = this.fontMetrics;
            if (fontMetricsInt8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fontMetrics");
            }
            $this$apply.leading = fontMetricsInt8.leading;
            switch (this.verticalAlign) {
                case 1: 
                case 4: {
                    if ($this$apply.ascent + this.getHeightPx() <= $this$apply.descent) break;
                    $this$apply.descent = $this$apply.ascent + this.getHeightPx();
                    break;
                }
                case 2: 
                case 5: {
                    if ($this$apply.ascent <= $this$apply.descent - this.getHeightPx()) break;
                    $this$apply.ascent = $this$apply.descent - this.getHeightPx();
                    break;
                }
                case 3: 
                case 6: {
                    if ($this$apply.descent - $this$apply.ascent >= this.getHeightPx()) break;
                    $this$apply.ascent -= (this.getHeightPx() - ($this$apply.descent - $this$apply.ascent)) / 2;
                    $this$apply.descent = $this$apply.ascent + this.getHeightPx();
                    break;
                }
                case 0: {
                    if ($this$apply.ascent <= -this.getHeightPx()) break;
                    $this$apply.ascent = -this.getHeightPx();
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unknown verticalAlign.");
                }
            }
            Paint.FontMetricsInt fontMetricsInt9 = this.fontMetrics;
            if (fontMetricsInt9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fontMetrics");
            }
            int n4 = fontMetricsInt9.top;
            int n5 = $this$apply.ascent;
            Paint.FontMetricsInt fontMetricsInt10 = $this$apply;
            boolean bl6 = false;
            fontMetricsInt10.top = n = Math.min(n4, n5);
            Paint.FontMetricsInt fontMetricsInt11 = this.fontMetrics;
            if (fontMetricsInt11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fontMetrics");
            }
            n4 = fontMetricsInt11.bottom;
            n5 = $this$apply.descent;
            fontMetricsInt10 = $this$apply;
            bl6 = false;
            fontMetricsInt10.bottom = n = Math.max(n4, n5);
        }
        return this.getWidthPx();
    }

    public void draw(@NotNull Canvas canvas, @Nullable CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
    }

    public final int getVerticalAlign() {
        return this.verticalAlign;
    }

    public PlaceholderSpan(float width, int widthUnit, float height, int heightUnit, float pxPerSp, int verticalAlign) {
        this.width = width;
        this.widthUnit = widthUnit;
        this.height = height;
        this.heightUnit = heightUnit;
        this.pxPerSp = pxPerSp;
        this.verticalAlign = verticalAlign;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/text/style/PlaceholderSpan$Companion;", "", "()V", "ALIGN_ABOVE_BASELINE", "", "ALIGN_BOTTOM", "ALIGN_CENTER", "ALIGN_TEXT_BOTTOM", "ALIGN_TEXT_CENTER", "ALIGN_TEXT_TOP", "ALIGN_TOP", "UNIT_EM", "UNIT_INHERIT", "UNIT_SP", "Unit", "VerticalAlign", "ui-android-text_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Retention(value=AnnotationRetention.SOURCE)
        @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/text/style/PlaceholderSpan$Companion$VerticalAlign;", "", "ui-android-text_release"})
        public static @interface VerticalAlign {
        }

        @Retention(value=AnnotationRetention.SOURCE)
        @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/text/style/PlaceholderSpan$Companion$Unit;", "", "ui-android-text_release"})
        public static @interface Unit {
        }
    }
}

