/*
 * Decompiled with CFR 0.152.
 */
package androidx.text;

import android.graphics.Canvas;
import android.graphics.Path;
import android.os.Build;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextPaint;
import android.text.TextUtils;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.text.BoringLayoutFactory;
import androidx.text.LayoutIntrinsics;
import androidx.text.StaticLayoutFactory;
import androidx.text.TextAlignmentAdapter;
import androidx.text.TextLayoutKt;
import androidx.text.style.BaselineShiftSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u00a7\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u000e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\t\u0012\b\b\u0002\u0010\u0012\u001a\u00020\t\u0012\b\b\u0002\u0010\u0013\u001a\u00020\t\u0012\b\b\u0002\u0010\u0014\u001a\u00020\t\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u000e\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\tJ\u000e\u00105\u001a\u00020\u00052\u0006\u00104\u001a\u00020\tJ\u000e\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\tJ\u000e\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\tJ\u000e\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\tJ\u000e\u0010<\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\tJ\u000e\u0010=\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\tJ\u000e\u0010>\u001a\u00020\u00052\u0006\u00104\u001a\u00020\tJ\u000e\u0010?\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\tJ\u0016\u0010@\u001a\u00020\t2\u0006\u00104\u001a\u00020\t2\u0006\u0010A\u001a\u00020\u0005J\u000e\u0010B\u001a\u00020\t2\u0006\u00104\u001a\u00020\tJ\u000e\u0010C\u001a\u00020\u00052\u0006\u00107\u001a\u00020\tJ\u000e\u0010D\u001a\u00020\u00052\u0006\u00107\u001a\u00020\tJ\u001e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\t2\u0006\u0010H\u001a\u00020\t2\u0006\u0010I\u001a\u00020JJ\u000e\u0010K\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\tJ\u000e\u0010L\u001a\u00020\u00102\u0006\u00107\u001a\u00020\tJ\u000e\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020OR\u0011\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010 R\u0011\u0010+\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u0011\u00100\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006P"}, d2={"Landroidx/text/TextLayout;", "", "charSequence", "", "width", "", "textPaint", "Landroid/text/TextPaint;", "alignment", "", "ellipsize", "Landroid/text/TextUtils$TruncateAt;", "textDirectionHeuristic", "lineSpacingMultiplier", "lineSpacingExtra", "includePadding", "", "maxLines", "breakStrategy", "hyphenationFrequency", "justificationMode", "leftIndents", "", "rightIndents", "layoutIntrinsics", "Landroidx/text/LayoutIntrinsics;", "(Ljava/lang/CharSequence;FLandroid/text/TextPaint;ILandroid/text/TextUtils$TruncateAt;IFFZIIII[I[ILandroidx/text/LayoutIntrinsics;)V", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "height", "getHeight", "()I", "layout", "Landroid/text/Layout;", "layout$annotations", "()V", "getLayout", "()Landroid/text/Layout;", "getLayoutIntrinsics", "()Landroidx/text/LayoutIntrinsics;", "lineCount", "getLineCount", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "()F", "minIntrinsicWidth", "getMinIntrinsicWidth", "text", "getText", "()Ljava/lang/CharSequence;", "getLineBaseline", "line", "getLineBottom", "getLineForOffset", "offset", "getLineForVertical", "vertical", "getLineHeight", "lineIndex", "getLineLeft", "getLineRight", "getLineTop", "getLineWidth", "getOffsetForHorizontal", "horizontal", "getParagraphDirection", "getPrimaryHorizontal", "getSecondaryHorizontal", "getSelectionPath", "", "start", "end", "dest", "Landroid/graphics/Path;", "isEllipsisApplied", "isRtlCharAt", "paint", "canvas", "Landroid/graphics/Canvas;", "ui-android-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TextLayout {
    private final boolean didExceedMaxLines;
    @NotNull
    private final Layout layout;
    private final int lineCount;
    @NotNull
    private final LayoutIntrinsics layoutIntrinsics;

    public final float getMaxIntrinsicWidth() {
        return this.layoutIntrinsics.getMaxIntrinsicWidth();
    }

    public final float getMinIntrinsicWidth() {
        return this.layoutIntrinsics.getMinIntrinsicWidth();
    }

    public final boolean getDidExceedMaxLines() {
        return this.didExceedMaxLines;
    }

    @VisibleForTesting
    public static /* synthetic */ void layout$annotations() {
    }

    @NotNull
    public final Layout getLayout() {
        return this.layout;
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    @NotNull
    public final CharSequence getText() {
        CharSequence charSequence = this.layout.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"layout.text");
        return charSequence;
    }

    public final int getHeight() {
        return this.didExceedMaxLines ? this.layout.getLineBottom(this.lineCount - 1) : this.layout.getHeight();
    }

    public final float getLineLeft(int lineIndex) {
        return this.layout.getLineLeft(lineIndex);
    }

    public final float getLineRight(int lineIndex) {
        return this.layout.getLineRight(lineIndex);
    }

    public final float getLineTop(int line) {
        return this.layout.getLineTop(line);
    }

    public final float getLineBottom(int line) {
        return this.layout.getLineBottom(line);
    }

    public final float getLineBaseline(int line) {
        return this.layout.getLineBaseline(line);
    }

    public final float getLineHeight(int lineIndex) {
        return this.layout.getLineBottom(lineIndex) - this.layout.getLineTop(lineIndex);
    }

    public final float getLineWidth(int lineIndex) {
        return this.layout.getLineWidth(lineIndex);
    }

    public final int getLineForVertical(int vertical) {
        return this.layout.getLineForVertical(vertical);
    }

    public final int getOffsetForHorizontal(int line, float horizontal) {
        return this.layout.getOffsetForHorizontal(line, horizontal);
    }

    public final float getPrimaryHorizontal(int offset) {
        return this.layout.getPrimaryHorizontal(offset);
    }

    public final float getSecondaryHorizontal(int offset) {
        return this.layout.getSecondaryHorizontal(offset);
    }

    public final int getLineForOffset(int offset) {
        return this.layout.getLineForOffset(offset);
    }

    public final boolean isRtlCharAt(int offset) {
        return this.layout.isRtlCharAt(offset);
    }

    public final int getParagraphDirection(int line) {
        return this.layout.getParagraphDirection(line);
    }

    public final void getSelectionPath(int start, int end, @NotNull Path dest) {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        this.layout.getSelectionPath(start, end, dest);
    }

    public final boolean isEllipsisApplied(int lineIndex) {
        return this.layout.getEllipsisCount(lineIndex) > 0;
    }

    public final void paint(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.layout.draw(canvas);
    }

    @NotNull
    public final LayoutIntrinsics getLayoutIntrinsics() {
        return this.layoutIntrinsics;
    }

    public TextLayout(@NotNull CharSequence charSequence, float width, @NotNull TextPaint textPaint, int alignment, @Nullable TextUtils.TruncateAt ellipsize, int textDirectionHeuristic, float lineSpacingMultiplier, @Px float lineSpacingExtra, boolean includePadding, int maxLines, int breakStrategy, int hyphenationFrequency, int justificationMode, @Nullable int[] leftIndents, @Nullable int[] rightIndents, @NotNull LayoutIntrinsics layoutIntrinsics) {
        int n;
        TextLayout textLayout;
        Layout layout;
        Intrinsics.checkParameterIsNotNull((Object)charSequence, (String)"charSequence");
        Intrinsics.checkParameterIsNotNull((Object)textPaint, (String)"textPaint");
        Intrinsics.checkParameterIsNotNull((Object)layoutIntrinsics, (String)"layoutIntrinsics");
        this.layoutIntrinsics = layoutIntrinsics;
        int end = charSequence.length();
        TextDirectionHeuristic frameworkTextDir = TextLayoutKt.getTextDirectionHeuristic(textDirectionHeuristic);
        Layout.Alignment frameworkAlignment = TextAlignmentAdapter.INSTANCE.get(alignment);
        boolean hasBaselineShiftSpans = charSequence instanceof Spanned ? ((Spanned)charSequence).nextSpanTransition(-1, end, BaselineShiftSpan.class) < end : false;
        BoringLayout.Metrics boringMetrics2 = this.layoutIntrinsics.getBoringMetrics();
        int n2 = 0;
        int widthInt = (int)Math.ceil(width);
        TextLayout textLayout2 = this;
        if (boringMetrics2 != null && this.layoutIntrinsics.getMaxIntrinsicWidth() <= width && !hasBaselineShiftSpans) {
            layout = (Layout)BoringLayoutFactory.INSTANCE.create(charSequence, textPaint, widthInt, boringMetrics2, frameworkAlignment, includePadding, ellipsize, widthInt);
        } else {
            TextPaint textPaint2 = textPaint;
            int n3 = charSequence.length();
            int n4 = 0;
            CharSequence charSequence2 = charSequence;
            StaticLayoutFactory staticLayoutFactory = StaticLayoutFactory.INSTANCE;
            textLayout = textLayout2;
            n2 = 0;
            float f = (float)Math.ceil(width);
            TextUtils.TruncateAt truncateAt = ellipsize;
            int n5 = maxLines;
            Layout.Alignment alignment2 = frameworkAlignment;
            TextDirectionHeuristic textDirectionHeuristic2 = frameworkTextDir;
            int n6 = (int)f;
            n2 = 0;
            float f2 = (float)Math.ceil(width);
            textLayout2 = textLayout;
            layout = textLayout2.layout = (Layout)StaticLayoutFactory.create$default(staticLayoutFactory, charSequence2, n4, n3, textPaint2, n6, textDirectionHeuristic2, alignment2, n5, truncateAt, (int)f2, lineSpacingMultiplier, lineSpacingExtra, justificationMode, includePadding, false, breakStrategy, hyphenationFrequency, leftIndents, rightIndents, 16384, null);
        }
        this.didExceedMaxLines = Build.VERSION.SDK_INT <= 25 ? (maxLines != this.layout.getLineCount() ? false : this.layout.getLineEnd(this.layout.getLineCount() - 1) != charSequence.length()) : this.layout.getLineCount() > maxLines;
        n2 = this.layout.getLineCount();
        textLayout = this;
        boolean bl = false;
        textLayout.lineCount = n = Math.min(n2, maxLines);
    }

    public /* synthetic */ TextLayout(CharSequence charSequence, float f, TextPaint textPaint, int n, TextUtils.TruncateAt truncateAt, int n2, float f2, float f3, boolean bl, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, LayoutIntrinsics layoutIntrinsics, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 2) != 0) {
            f = 0.0f;
        }
        if ((n7 & 8) != 0) {
            n = 0;
        }
        if ((n7 & 0x10) != 0) {
            truncateAt = null;
        }
        if ((n7 & 0x20) != 0) {
            n2 = 2;
        }
        if ((n7 & 0x40) != 0) {
            f2 = 1.0f;
        }
        if ((n7 & 0x80) != 0) {
            f3 = 0.0f;
        }
        if ((n7 & 0x100) != 0) {
            bl = true;
        }
        if ((n7 & 0x200) != 0) {
            n3 = Integer.MAX_VALUE;
        }
        if ((n7 & 0x400) != 0) {
            n4 = 0;
        }
        if ((n7 & 0x800) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x1000) != 0) {
            n6 = 0;
        }
        if ((n7 & 0x2000) != 0) {
            nArray = null;
        }
        if ((n7 & 0x4000) != 0) {
            nArray2 = null;
        }
        if ((n7 & 0x8000) != 0) {
            layoutIntrinsics = new LayoutIntrinsics(charSequence, textPaint, n2);
        }
        this(charSequence, f, textPaint, n, truncateAt, n2, f2, f3, bl, n3, n4, n5, n6, nArray, nArray2, layoutIntrinsics);
    }
}

