/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.DecayAnimation;
import androidx.annotation.FloatRange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J \u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J \u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/animation/ExponentialDecay;", "Landroidx/animation/DecayAnimation;", "frictionMultiplier", "", "absVelocityThreshold", "(FF)V", "getAbsVelocityThreshold", "()F", "friction", "getTarget", "start", "startVelocity", "getValue", "playTime", "", "getVelocity", "isFinished", "", "ui-animation-core_release"})
public final class ExponentialDecay
implements DecayAnimation {
    private final float absVelocityThreshold;
    private final float friction;

    @Override
    public float getAbsVelocityThreshold() {
        return this.absVelocityThreshold;
    }

    @Override
    public boolean isFinished(long playTime, float start, float startVelocity) {
        float f = this.getVelocity(playTime, start, startVelocity);
        boolean bl = false;
        return Math.abs(f) <= this.getAbsVelocityThreshold();
    }

    @Override
    public float getValue(long playTime, float start, float startVelocity) {
        float f = this.friction * (float)playTime / 1000.0f;
        float f2 = startVelocity / this.friction;
        float f3 = start - startVelocity / this.friction;
        boolean bl = false;
        float f4 = (float)Math.exp(f);
        return f3 + f2 * f4;
    }

    @Override
    public float getVelocity(long playTime, float start, float startVelocity) {
        float f = (float)playTime / 1000.0f * this.friction;
        float f2 = startVelocity;
        boolean bl = false;
        float f3 = (float)Math.exp(f);
        return f2 * f3;
    }

    @Override
    public float getTarget(float start, float startVelocity) {
        boolean bl = false;
        if (Math.abs(startVelocity) <= this.getAbsVelocityThreshold()) {
            return start;
        }
        float f = this.getAbsVelocityThreshold() / startVelocity;
        boolean bl2 = false;
        double d = Math.abs(f);
        boolean bl3 = false;
        double duration = Math.log(d) / (double)this.friction * (double)1000;
        d = (double)this.friction * duration / (double)1000.0f;
        float f2 = startVelocity / this.friction;
        float f3 = start - startVelocity / this.friction;
        bl3 = false;
        double d2 = Math.exp(d);
        return f3 + f2 * (float)d2;
    }

    public ExponentialDecay(@FloatRange(from=0.0, fromInclusive=false) float frictionMultiplier, @FloatRange(from=0.0, fromInclusive=false) float absVelocityThreshold) {
        float f;
        float f2 = 1.0E-7f;
        ExponentialDecay exponentialDecay = this;
        boolean bl = false;
        float f3 = f = Math.abs(absVelocityThreshold);
        boolean bl2 = false;
        exponentialDecay.absVelocityThreshold = f = Math.max(f2, f3);
        f2 = 1.0E-4f;
        f = -4.2f;
        exponentialDecay = this;
        boolean bl3 = false;
        float f4 = Math.max(f2, frictionMultiplier);
        exponentialDecay.friction = f * f4;
    }

    public /* synthetic */ ExponentialDecay(float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.1f;
        }
        this(f, f2);
    }

    public ExponentialDecay() {
        this(0.0f, 0.0f, 3, null);
    }
}

