/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.AnimationVector;
import androidx.animation.AnimationVectorsKt;
import androidx.animation.DurationBasedAnimation;
import androidx.animation.EasingKt;
import androidx.animation.PropKeyKt;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BT\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012=\u0010\u0007\u001a9\u0012\u0004\u0012\u00020\u0005\u0012/\u0012-\u0012\u0004\u0012\u00028\u0000\u0012#\u0012!\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\u000f0\t0\b\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ-\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010!R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012RE\u0010\u0007\u001a9\u0012\u0004\u0012\u00020\u0005\u0012/\u0012-\u0012\u0004\u0012\u00028\u0000\u0012#\u0012!\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\u000f0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0010\u0010\u0016\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006\""}, d2={"Landroidx/animation/Keyframes;", "V", "Landroidx/animation/AnimationVector;", "Landroidx/animation/DurationBasedAnimation;", "duration", "", "delay", "keyframes", "", "Lkotlin/Pair;", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fraction", "Landroidx/animation/Easing;", "(JJLjava/util/Map;)V", "getDelay", "()J", "getDuration", "valueVector", "Landroidx/animation/AnimationVector;", "velocityVector", "getValue", "playTime", "start", "end", "startVelocity", "(JLandroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;)Landroidx/animation/AnimationVector;", "getVelocity", "init", "", "value", "(Landroidx/animation/AnimationVector;)V", "ui-animation-core_release"})
public final class Keyframes<V extends AnimationVector>
implements DurationBasedAnimation<V> {
    private V valueVector;
    private V velocityVector;
    private final long duration;
    private final long delay;
    private final Map<Long, Pair<V, Function1<Float, Float>>> keyframes;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getValue(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(end, (String)"end");
        Intrinsics.checkParameterIsNotNull(startVelocity, (String)"startVelocity");
        long clampedPlayTime = this.clampPlayTime(playTime);
        if (this.keyframes.containsKey(clampedPlayTime)) {
            return (V)((AnimationVector)((Pair)MapsKt.getValue(this.keyframes, (Object)clampedPlayTime)).getFirst());
        }
        if (clampedPlayTime >= this.getDuration()) {
            return end;
        }
        if (clampedPlayTime <= 0L) {
            return start;
        }
        long startTime = 0L;
        Object startVal = start;
        Object endVal = end;
        long endTime = this.getDuration();
        Function1 easing = EasingKt.getLinearEasing();
        Map<Long, Pair<V, Function1<Float, Float>>> map = this.keyframes;
        boolean bl = false;
        Iterator<Map.Entry<Long, Pair<V, Function1<Float, Float>>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void timestamp;
            Map.Entry<Long, Pair<Pair<Pair<Pair<V, Function1<Float, Float>>, Function1<Float, Float>>, Function1<Float, Float>>, Function1<Float, Float>>> entry;
            Map.Entry<Long, Pair<Pair<Pair<Pair<V, Function1<Float, Float>>, Function1<Float, Float>>, Function1<Float, Float>>, Function1<Float, Float>>> entry2 = entry = iterator.next();
            boolean bl2 = false;
            long l = ((Number)entry2.getKey()).longValue();
            entry2 = entry;
            bl2 = false;
            Pair<Pair<V, Function1<Float, Float>>, Function1<Float, Float>> value = entry2.getValue();
            if (clampedPlayTime > timestamp && timestamp >= startTime) {
                startTime = timestamp;
                startVal = (AnimationVector)value.getFirst();
                easing = (Function1)value.getSecond();
                continue;
            }
            if (clampedPlayTime >= timestamp || timestamp > endTime) continue;
            endTime = timestamp;
            endVal = (AnimationVector)value.getFirst();
        }
        float fraction = ((Number)easing.invoke((Object)Float.valueOf((float)(clampedPlayTime - startTime) / (float)(endTime - startTime)))).floatValue();
        this.init(start);
        int n = 0;
        int n2 = ((AnimationVector)startVal).getSize$ui_animation_core_release();
        while (n < n2) {
            void i;
            V v = this.valueVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            }
            ((AnimationVector)v).set$ui_animation_core_release((int)i, PropKeyKt.lerp(((AnimationVector)startVal).get$ui_animation_core_release((int)i), ((AnimationVector)endVal).get$ui_animation_core_release((int)i), fraction));
            ++i;
        }
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
        }
        return v;
    }

    private final void init(V value) {
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(value);
            this.velocityVector = AnimationVectorsKt.newInstance(value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getVelocity(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(end, (String)"end");
        Intrinsics.checkParameterIsNotNull(startVelocity, (String)"startVelocity");
        long clampedPlayTime = this.clampPlayTime(playTime);
        if (clampedPlayTime <= 0L) {
            return startVelocity;
        }
        V startNum = this.getValue(clampedPlayTime - 1L, start, end, startVelocity);
        V endNum = this.getValue(clampedPlayTime, start, end, startVelocity);
        this.init(start);
        int n = 0;
        int n2 = ((AnimationVector)startNum).getSize$ui_animation_core_release();
        while (n < n2) {
            void i;
            V v = this.velocityVector;
            if (v == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            }
            ((AnimationVector)v).set$ui_animation_core_release((int)i, (((AnimationVector)startNum).get$ui_animation_core_release((int)i) - ((AnimationVector)endNum).get$ui_animation_core_release((int)i)) * 1000.0f);
            ++i;
        }
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
        }
        return v;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    public Keyframes(long duration, long delay, @NotNull Map<Long, ? extends Pair<? extends V, ? extends Function1<? super Float, Float>>> keyframes) {
        Intrinsics.checkParameterIsNotNull(keyframes, (String)"keyframes");
        this.duration = duration;
        this.delay = delay;
        this.keyframes = keyframes;
    }

    @Override
    public boolean isFinished(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(end, (String)"end");
        Intrinsics.checkParameterIsNotNull(startVelocity, (String)"startVelocity");
        return DurationBasedAnimation.DefaultImpls.isFinished(this, playTime, start, end, startVelocity);
    }

    @Override
    public long clampPlayTime(long playTime) {
        return DurationBasedAnimation.DefaultImpls.clampPlayTime(this, playTime);
    }

    public static final /* synthetic */ AnimationVector access$getValueVector$p(Keyframes $this) {
        Object v = $this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
        }
        return v;
    }

    public static final /* synthetic */ void access$setValueVector$p(Keyframes $this, AnimationVector animationVector) {
        $this.valueVector = animationVector;
    }
}

