/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.Animation;
import androidx.animation.AnimationVector;
import androidx.animation.DurationBasedAnimation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ-\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J-\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/animation/Repeatable;", "V", "Landroidx/animation/AnimationVector;", "Landroidx/animation/Animation;", "iterationCount", "", "animation", "Landroidx/animation/DurationBasedAnimation;", "(JLandroidx/animation/DurationBasedAnimation;)V", "duration", "getValue", "playTime", "start", "end", "startVelocity", "(JLandroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;)Landroidx/animation/AnimationVector;", "getVelocity", "isFinished", "", "(JLandroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;)Z", "repetitionPlayTime", "repetitionStartVelocity", "ui-animation-core_release"})
public final class Repeatable<V extends AnimationVector>
implements Animation<V> {
    private final long duration;
    private final long iterationCount;
    private final DurationBasedAnimation<V> animation;

    private final long repetitionPlayTime(long playTime) {
        long l = playTime / this.duration;
        long l2 = this.iterationCount - 1L;
        boolean bl = false;
        long repeatsCount = Math.min(l, l2);
        return playTime - repeatsCount * this.duration;
    }

    private final V repetitionStartVelocity(long playTime, V start, V startVelocity, V end) {
        return playTime > this.duration ? this.getVelocity(this.duration, start, startVelocity, end) : startVelocity;
    }

    @Override
    public boolean isFinished(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(end, (String)"end");
        Intrinsics.checkParameterIsNotNull(startVelocity, (String)"startVelocity");
        return this.duration <= 0L || playTime / this.duration >= this.iterationCount;
    }

    @Override
    @NotNull
    public V getValue(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(end, (String)"end");
        Intrinsics.checkParameterIsNotNull(startVelocity, (String)"startVelocity");
        return this.animation.getValue(this.repetitionPlayTime(playTime), start, end, this.repetitionStartVelocity(playTime, start, startVelocity, end));
    }

    @Override
    @NotNull
    public V getVelocity(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkParameterIsNotNull(start, (String)"start");
        Intrinsics.checkParameterIsNotNull(end, (String)"end");
        Intrinsics.checkParameterIsNotNull(startVelocity, (String)"startVelocity");
        return this.animation.getVelocity(this.repetitionPlayTime(playTime), start, end, this.repetitionStartVelocity(playTime, start, startVelocity, end));
    }

    public Repeatable(long iterationCount, @NotNull DurationBasedAnimation<V> animation) {
        Intrinsics.checkParameterIsNotNull(animation, (String)"animation");
        this.iterationCount = iterationCount;
        this.animation = animation;
        if (this.iterationCount < 1L) {
            throw (Throwable)new IllegalArgumentException("Iterations count can't be less than 1");
        }
        this.duration = this.animation.getDelay() + this.animation.getDuration();
    }
}

