/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.ComplexDouble;
import androidx.animation.ComplexDoubleKt;
import androidx.animation.SpringEstimationKt;
import androidx.annotation.VisibleForTesting;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DoubleCompanionObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0007\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0007\u001a4\u0010\u000b\u001a\u00020\u00032\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a<\u0010\u0011\u001a\u00020\u00012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a4\u0010\u0012\u001a\u00020\u00032\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a4\u0010\u0013\u001a\u00020\u00032\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a9\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0017H\u0082\b\u00a8\u0006\u0019"}, d2={"estimateAnimationDurationMillis", "", "stiffness", "", "dampingRatio", "initialVelocity", "initialPosition", "delta", "springConstant", "dampingCoefficient", "mass", "estimateCriticallyDamped", "roots", "Lkotlin/Pair;", "Landroidx/animation/ComplexDouble;", "p0", "v0", "estimateDurationInternal", "estimateOverDamped", "estimateUnderDamped", "iterateNewtonsMethod", "x", "fn", "Lkotlin/Function1;", "fnPrime", "ui-animation-core_release"})
public final class SpringEstimationKt {
    @VisibleForTesting(otherwise=3)
    public static final long estimateAnimationDurationMillis(double stiffness, double dampingRatio, double initialVelocity, double initialPosition, double delta) {
        double d = 2.0 * dampingRatio;
        boolean bl = false;
        double d2 = Math.sqrt(stiffness);
        double dampingCoefficient = d * d2;
        Pair<ComplexDouble, ComplexDouble> roots = ComplexDoubleKt.complexQuadraticFormula(1.0, dampingCoefficient, stiffness);
        return SpringEstimationKt.estimateDurationInternal(roots, dampingRatio, initialVelocity, initialPosition, delta);
    }

    @VisibleForTesting(otherwise=3)
    public static final long estimateAnimationDurationMillis(double springConstant, double dampingCoefficient, double mass, double initialVelocity, double initialPosition, double delta) {
        double d = springConstant * mass;
        double d2 = 2.0;
        boolean bl = false;
        double d3 = Math.sqrt(d);
        double criticalDamping = d2 * d3;
        double dampingRatio = dampingCoefficient / criticalDamping;
        Pair<ComplexDouble, ComplexDouble> roots = ComplexDoubleKt.complexQuadraticFormula(mass, dampingCoefficient, springConstant);
        return SpringEstimationKt.estimateDurationInternal(roots, dampingRatio, initialVelocity, initialPosition, delta);
    }

    private static final double estimateUnderDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        double r = ((ComplexDouble)roots.getFirst()).getReal();
        double c1 = p0;
        double c2 = (v0 - r * c1) / ((ComplexDouble)roots.getFirst()).getImaginary();
        double d = c1 * c1 + c2 * c2;
        boolean bl = false;
        double c = Math.sqrt(d);
        d = delta / c;
        bl = false;
        return Math.log(d) / r;
    }

    private static final double estimateCriticallyDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        double d;
        double d2;
        double d3;
        double r = ((ComplexDouble)roots.getFirst()).getReal();
        double c1 = p0;
        double c2 = v0 - r * c1;
        estimateCriticallyDamped.1 $fun$t2Iterate$1 = estimateCriticallyDamped.1.INSTANCE;
        double d4 = delta / c1;
        boolean bl = false;
        d4 = Math.abs(d4);
        bl = false;
        double t1 = Math.log(d4) / r;
        double d5 = delta / c2;
        estimateCriticallyDamped.1 var35_12 = $fun$t2Iterate$1;
        boolean bl2 = false;
        d5 = d3 = Math.abs(d5);
        bl2 = false;
        d3 = Math.log(d5);
        double t2 = var35_12.invoke(d3, r) / r;
        double d6 = t1;
        boolean bl3 = false;
        if (Double.isNaN(d6)) {
            d2 = t2;
        } else {
            d6 = t2;
            bl3 = false;
            if (Double.isNaN(d6)) {
                d2 = t1;
            } else {
                boolean bl4 = false;
                d2 = Math.max(t1, t2);
            }
        }
        double tCurr = d2;
        double tInflection = -(r * c1 + c2) / (r * c2);
        Function0<Double> $fun$xInflection$2 = new Function0<Double>(c1, r, tInflection, c2){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $r;
            final /* synthetic */ double $tInflection;
            final /* synthetic */ double $c2;

            public final double invoke() {
                double d = this.$r * this.$tInflection;
                double d2 = this.$c1;
                boolean bl = false;
                double d3 = Math.exp(d);
                double d4 = d2 * d3;
                d = this.$r * this.$tInflection;
                d3 = this.$c2 * this.$tInflection;
                d2 = d4;
                bl = false;
                double d5 = Math.exp(d);
                return d2 + d3 * d5;
            }
            {
                this.$c1 = d;
                this.$r = d2;
                this.$tInflection = d3;
                this.$c2 = d4;
                super(0);
            }
        };
        double d7 = tInflection;
        boolean bl5 = false;
        if (Double.isNaN(d7) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -$fun$xInflection$2.invoke() < delta) {
            if (c2 < 0.0 && c1 > 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            double tConcavChange;
            tCurr = tConcavChange = -(2.0 / r) - c1 / c2;
            d = delta;
        }
        double signedDelta = d;
        Function1 fn2 = (Function1)new Function1<Double, Double>(c1, c2, r, signedDelta){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r;
            final /* synthetic */ double $signedDelta;

            public final double invoke(double t) {
                double d = this.$r * t;
                double d2 = this.$c1 + this.$c2 * t;
                boolean bl = false;
                double d3 = Math.exp(d);
                return d2 * d3 + this.$signedDelta;
            }
            {
                this.$c1 = d;
                this.$c2 = d2;
                this.$r = d3;
                this.$signedDelta = d4;
                super(1);
            }
        };
        Function1 fnPrime2 = (Function1)new Function1<Double, Double>(c2, r, c1){
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r;
            final /* synthetic */ double $c1;

            public final double invoke(double t) {
                double d = this.$r * t;
                double d2 = this.$c2 * (this.$r * t + 1.0) + this.$c1 * this.$r;
                boolean bl = false;
                double d3 = Math.exp(d);
                return d2 * d3;
            }
            {
                this.$c2 = d;
                this.$r = d2;
                this.$c1 = d3;
                super(1);
            }
        };
        double tDelta = DoubleCompanionObject.INSTANCE.getMAX_VALUE();
        int iterations = 0;
        while (tDelta > 0.001 && iterations < 100) {
            ++iterations;
            double tLast = tCurr;
            boolean $i$f$iterateNewtonsMethod = false;
            tCurr -= ((Number)fn2.invoke((Object)tCurr)).doubleValue() / ((Number)fnPrime2.invoke((Object)tCurr)).doubleValue();
            double d8 = tLast - tCurr;
            boolean bl6 = false;
            tDelta = Math.abs(d8);
        }
        return tCurr;
    }

    private static final double estimateOverDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        boolean bl;
        double d;
        double d2;
        double r1 = ((ComplexDouble)roots.getFirst()).getReal();
        double r2 = ((ComplexDouble)roots.getSecond()).getReal();
        double c2 = (r1 * p0 - v0) / (r1 - r2);
        double c1 = p0 - c2;
        double d3 = delta / c1;
        boolean bl2 = false;
        d3 = Math.abs(d3);
        bl2 = false;
        double t1 = Math.log(d3) / r1;
        double d4 = delta / c2;
        boolean bl3 = false;
        d4 = Math.abs(d4);
        bl3 = false;
        double t2 = Math.log(d4) / r2;
        double d5 = t1;
        boolean bl4 = false;
        if (Double.isNaN(d5)) {
            d2 = t2;
        } else {
            d5 = t2;
            bl4 = false;
            if (Double.isNaN(d5)) {
                d2 = t1;
            } else {
                boolean bl5 = false;
                d2 = Math.max(t1, t2);
            }
        }
        double tCurr = d2;
        double d6 = c1 * r1 / (-c2 * r2);
        boolean bl6 = false;
        double tInflection = Math.log(d6) / (r2 - r1);
        Function0<Double> $fun$xInflection$1 = new Function0<Double>(c1, r1, tInflection, c2, r2){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $r1;
            final /* synthetic */ double $tInflection;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r2;

            public final double invoke() {
                double d = this.$r1 * this.$tInflection;
                double d2 = this.$c1;
                boolean bl = false;
                double d3 = Math.exp(d);
                double d4 = d2 * d3;
                d = this.$r2 * this.$tInflection;
                d3 = this.$c2;
                d2 = d4;
                bl = false;
                double d5 = Math.exp(d);
                return d2 + d3 * d5;
            }
            {
                this.$c1 = d;
                this.$r1 = d2;
                this.$tInflection = d3;
                this.$c2 = d4;
                this.$r2 = d5;
                super(0);
            }
        };
        double d7 = tInflection;
        boolean bl7 = false;
        if (Double.isNaN(d7) || tInflection <= 0.0) {
            d = -delta;
        } else if (tInflection > 0.0 && -$fun$xInflection$1.invoke() < delta) {
            if (c2 > 0.0 && c1 < 0.0) {
                tCurr = 0.0;
            }
            d = -delta;
        } else {
            double tConcavChange;
            double d8 = -(c2 * r2 * r2) / (c1 * r1 * r1);
            bl = false;
            tCurr = tConcavChange = Math.log(d8) / (r1 - r2);
            d = delta;
        }
        double signedDelta = d;
        Function1 fn2 = (Function1)new Function1<Double, Double>(c1, r1, c2, r2, signedDelta){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $r1;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r2;
            final /* synthetic */ double $signedDelta;

            public final double invoke(double t) {
                double d = this.$r1 * t;
                double d2 = this.$c1;
                boolean bl = false;
                double d3 = Math.exp(d);
                double d4 = d2 * d3;
                d = this.$r2 * t;
                d3 = this.$c2;
                d2 = d4;
                bl = false;
                double d5 = Math.exp(d);
                return d2 + d3 * d5 + this.$signedDelta;
            }
            {
                this.$c1 = d;
                this.$r1 = d2;
                this.$c2 = d3;
                this.$r2 = d4;
                this.$signedDelta = d5;
                super(1);
            }
        };
        Function1 fnPrime2 = (Function1)new Function1<Double, Double>(c1, r1, c2, r2){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $r1;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r2;

            public final double invoke(double t) {
                double d = this.$r1 * t;
                double d2 = this.$c1 * this.$r1;
                boolean bl = false;
                double d3 = Math.exp(d);
                double d4 = d2 * d3;
                d = this.$r2 * t;
                d3 = this.$c2 * this.$r2;
                d2 = d4;
                bl = false;
                double d5 = Math.exp(d);
                return d2 + d3 * d5;
            }
            {
                this.$c1 = d;
                this.$r1 = d2;
                this.$c2 = d3;
                this.$r2 = d4;
                super(1);
            }
        };
        double d9 = ((Number)fn2.invoke((Object)tCurr)).doubleValue();
        bl = false;
        if (Math.abs(d9) < 1.0E-4) {
            return tCurr;
        }
        double tDelta = DoubleCompanionObject.INSTANCE.getMAX_VALUE();
        int iterations = 0;
        while (tDelta > 0.001 && iterations < 100) {
            ++iterations;
            double tLast = tCurr;
            boolean $i$f$iterateNewtonsMethod = false;
            tCurr -= ((Number)fn2.invoke((Object)tCurr)).doubleValue() / ((Number)fnPrime2.invoke((Object)tCurr)).doubleValue();
            double d10 = tLast - tCurr;
            boolean bl8 = false;
            tDelta = Math.abs(d10);
        }
        return tCurr;
    }

    private static final long estimateDurationInternal(Pair<ComplexDouble, ComplexDouble> roots, double dampingRatio, double initialVelocity, double initialPosition, double delta) {
        double d;
        if (initialPosition == 0.0 && initialVelocity == 0.0) {
            return 0L;
        }
        double v0 = initialPosition < 0.0 ? -initialVelocity : initialVelocity;
        boolean bl = false;
        double p0 = Math.abs(initialPosition);
        if (dampingRatio > 1.0) {
            double d2 = delta;
            double d3 = p0;
            double d4 = v0;
            d = SpringEstimationKt.estimateOverDamped(roots, d3, d4, d2);
        } else if (dampingRatio < 1.0) {
            double d5 = delta;
            double d6 = p0;
            double d7 = v0;
            d = SpringEstimationKt.estimateUnderDamped(roots, d6, d7, d5);
        } else {
            double d8 = delta;
            double d9 = p0;
            double d10 = v0;
            d = SpringEstimationKt.estimateCriticallyDamped(roots, d9, d10, d8);
        }
        return (long)(d * 1000.0);
    }

    private static final double iterateNewtonsMethod(double x, Function1<? super Double, Double> fn2, Function1<? super Double, Double> fnPrime2) {
        int $i$f$iterateNewtonsMethod = 0;
        return x - ((Number)fn2.invoke((Object)x)).doubleValue() / ((Number)fnPrime2.invoke((Object)x)).doubleValue();
    }
}

