/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.Motion;
import androidx.animation.SpringSimulationKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J \u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020 J\u0015\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b#J%\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b&R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u0004R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\u0004R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Landroidx/animation/SpringSimulation;", "", "finalPosition", "", "(F)V", "dampedFreq", "", "value", "dampingRatio", "getDampingRatio", "()F", "setDampingRatio", "getFinalPosition", "setFinalPosition", "gammaMinus", "gammaPlus", "initialized", "", "naturalFreq", "stiffness", "getStiffness", "setStiffness", "valueThreshold", "velocityThreshold", "getAcceleration", "lastDisplacement", "lastVelocity", "init", "", "isAtEquilibrium", "velocity", "timeElapsed", "", "setValueThreshold", "threshold", "setValueThreshold$ui_animation_core_release", "updateValues", "Landroidx/animation/Motion;", "updateValues$ui_animation_core_release", "ui-animation-core_release"})
public final class SpringSimulation {
    private double naturalFreq;
    private boolean initialized;
    private double valueThreshold;
    private double velocityThreshold;
    private double gammaPlus;
    private double gammaMinus;
    private double dampedFreq;
    private float dampingRatio;
    private float finalPosition;

    public final float getStiffness() {
        return (float)(this.naturalFreq * this.naturalFreq);
    }

    public final void setStiffness(float value) {
        if (this.getStiffness() <= 0.0f) {
            throw (Throwable)new IllegalArgumentException("Spring stiffness constant must be positive.");
        }
        this.naturalFreq = Math.sqrt(value);
        this.initialized = false;
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    public final void setDampingRatio(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Damping ratio must be non-negative");
        }
        this.dampingRatio = value;
        this.initialized = false;
    }

    public final float getAcceleration(float lastDisplacement, float lastVelocity) {
        float adjustedDisplacement = lastDisplacement - this.finalPosition;
        double k = this.naturalFreq * this.naturalFreq;
        double c = 2.0 * this.naturalFreq * (double)this.dampingRatio;
        return (float)(-k * (double)adjustedDisplacement - c * (double)lastVelocity);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAtEquilibrium(float value, float velocity, long timeElapsed) {
        if (timeElapsed > 0L) {
            void endValue;
            Motion motion = this.updateValues$ui_animation_core_release(value, velocity, timeElapsed);
            float f = motion.component1();
            float endVelocity = motion.component2();
            return this.isAtEquilibrium((float)endValue, endVelocity);
        }
        return this.isAtEquilibrium(value, velocity);
    }

    public static /* synthetic */ boolean isAtEquilibrium$default(SpringSimulation springSimulation, float f, float f2, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = 0L;
        }
        return springSimulation.isAtEquilibrium(f, f2, l);
    }

    private final boolean isAtEquilibrium(float value, float velocity) {
        return (double)Math.abs(velocity) < this.velocityThreshold && (double)Math.abs(value - this.finalPosition) < this.valueThreshold;
    }

    private final void init() {
        if (this.initialized) {
            return;
        }
        if (this.finalPosition == SpringSimulationKt.getUNSET()) {
            throw (Throwable)new IllegalStateException("Error: Final position of the spring must be set before the animation starts");
        }
        double dampingRatioSquared = (double)this.dampingRatio * (double)this.dampingRatio;
        if (this.dampingRatio > 1.0f) {
            this.gammaPlus = (double)(-this.dampingRatio) * this.naturalFreq + this.naturalFreq * Math.sqrt(dampingRatioSquared - 1.0);
            this.gammaMinus = (double)(-this.dampingRatio) * this.naturalFreq - this.naturalFreq * Math.sqrt(dampingRatioSquared - 1.0);
        } else if (this.dampingRatio >= 0.0f && this.dampingRatio < 1.0f) {
            this.dampedFreq = this.naturalFreq * Math.sqrt(1.0 - dampingRatioSquared);
        }
        this.initialized = true;
    }

    @NotNull
    public final Motion updateValues$ui_animation_core_release(float lastDisplacement, float lastVelocity, long timeElapsed) {
        this.init();
        float adjustedDisplacement = lastDisplacement - this.finalPosition;
        double deltaT = (double)timeElapsed / 1000.0;
        double displacement = 0.0;
        double currentVelocity = 0.0;
        if (this.dampingRatio > 1.0f) {
            double coeffA = (double)adjustedDisplacement - (this.gammaMinus * (double)adjustedDisplacement - (double)lastVelocity) / (this.gammaMinus - this.gammaPlus);
            double coeffB = (this.gammaMinus * (double)adjustedDisplacement - (double)lastVelocity) / (this.gammaMinus - this.gammaPlus);
            displacement = coeffA * Math.pow(Math.E, this.gammaMinus * deltaT) + coeffB * Math.pow(Math.E, this.gammaPlus * deltaT);
            currentVelocity = coeffA * this.gammaMinus * Math.pow(Math.E, this.gammaMinus * deltaT) + coeffB * this.gammaPlus * Math.pow(Math.E, this.gammaPlus * deltaT);
        } else if (this.dampingRatio == 1.0f) {
            float coeffA = adjustedDisplacement;
            double coeffB = (double)lastVelocity + this.naturalFreq * (double)adjustedDisplacement;
            displacement = ((double)coeffA + coeffB * deltaT) * Math.pow(Math.E, -this.naturalFreq * deltaT);
            currentVelocity = ((double)coeffA + coeffB * deltaT) * Math.pow(Math.E, -this.naturalFreq * deltaT) * -this.naturalFreq + coeffB * Math.pow(Math.E, -this.naturalFreq * deltaT);
        } else {
            float cosCoeff = adjustedDisplacement;
            double sinCoeff = 1.0 / this.dampedFreq * ((double)this.dampingRatio * this.naturalFreq * (double)adjustedDisplacement + (double)lastVelocity);
            displacement = Math.pow(Math.E, (double)(-this.dampingRatio) * this.naturalFreq * deltaT) * ((double)cosCoeff * Math.cos(this.dampedFreq * deltaT) + sinCoeff * Math.sin(this.dampedFreq * deltaT));
            currentVelocity = displacement * -this.naturalFreq * (double)this.dampingRatio + Math.pow(Math.E, (double)(-this.dampingRatio) * this.naturalFreq * deltaT) * (-this.dampedFreq * (double)cosCoeff * Math.sin(this.dampedFreq * deltaT) + this.dampedFreq * sinCoeff * Math.cos(this.dampedFreq * deltaT));
        }
        float newValue = (float)(displacement + (double)this.finalPosition);
        float newVelocity = (float)currentVelocity;
        if (this.isAtEquilibrium(newValue, newVelocity)) {
            newValue = this.finalPosition;
            newVelocity = 0.0f;
        }
        return new Motion(newValue, newVelocity);
    }

    public final void setValueThreshold$ui_animation_core_release(double threshold) {
        this.valueThreshold = Math.abs(threshold);
        this.velocityThreshold = this.valueThreshold * 62.5;
    }

    public final float getFinalPosition() {
        return this.finalPosition;
    }

    public final void setFinalPosition(float f) {
        this.finalPosition = f;
    }

    public SpringSimulation(float finalPosition) {
        this.finalPosition = finalPosition;
        this.naturalFreq = Math.sqrt(50.0f);
        this.valueThreshold = 0.005;
        this.velocityThreshold = 0.3125;
        this.dampingRatio = 1.0f;
    }
}

