/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.Animation;
import androidx.animation.AnimationVector;
import androidx.animation.AnimationWrapper;
import androidx.animation.TwoWayConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B?\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u0006\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/animation/TargetBasedAnimationWrapper;", "T", "V", "Landroidx/animation/AnimationVector;", "Landroidx/animation/AnimationWrapper;", "startValue", "startVelocity", "endValue", "animation", "Landroidx/animation/Animation;", "typeConverter", "Landroidx/animation/TwoWayConverter;", "(Ljava/lang/Object;Landroidx/animation/AnimationVector;Ljava/lang/Object;Landroidx/animation/Animation;Landroidx/animation/TwoWayConverter;)V", "endValueVector", "Landroidx/animation/AnimationVector;", "startValueVector", "getValue", "playTime", "", "(J)Ljava/lang/Object;", "getVelocity", "(J)Landroidx/animation/AnimationVector;", "isFinished", "", "ui-animation-core_release"})
public final class TargetBasedAnimationWrapper<T, V extends AnimationVector>
implements AnimationWrapper<T, V> {
    private final V startValueVector;
    private final V endValueVector;
    private final V startVelocity;
    private final Animation<V> animation;
    private final TwoWayConverter<T, V> typeConverter;

    @Override
    public boolean isFinished(long playTime) {
        return this.animation.isFinished(playTime, this.startValueVector, this.endValueVector, this.startVelocity);
    }

    @Override
    public T getValue(long playTime) {
        return (T)this.typeConverter.getConvertFromVector().invoke(this.animation.getValue(playTime, this.startValueVector, this.endValueVector, this.startVelocity));
    }

    @Override
    @NotNull
    public V getVelocity(long playTime) {
        return this.animation.getVelocity(playTime, this.startValueVector, this.endValueVector, this.startVelocity);
    }

    public TargetBasedAnimationWrapper(T startValue, @NotNull V startVelocity, T endValue, @NotNull Animation<V> animation, @NotNull TwoWayConverter<T, V> typeConverter) {
        Intrinsics.checkParameterIsNotNull(startVelocity, (String)"startVelocity");
        Intrinsics.checkParameterIsNotNull(animation, (String)"animation");
        Intrinsics.checkParameterIsNotNull(typeConverter, (String)"typeConverter");
        this.startVelocity = startVelocity;
        this.animation = animation;
        this.typeConverter = typeConverter;
        this.startValueVector = (AnimationVector)this.typeConverter.getConvertToVector().invoke(startValue);
        this.endValueVector = (AnimationVector)this.typeConverter.getConvertToVector().invoke(endValue);
    }
}

