/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.Animation;
import androidx.animation.AnimationClockObservable;
import androidx.animation.AnimationClockObserver;
import androidx.animation.AnimationState;
import androidx.animation.AnimationVector;
import androidx.animation.AnimationVectorsKt;
import androidx.animation.AnimationWrapper;
import androidx.animation.InterruptionHandling;
import androidx.animation.PropKey;
import androidx.animation.StateImpl;
import androidx.animation.TargetBasedAnimationWrapper;
import androidx.animation.TransitionAnimation;
import androidx.animation.TransitionDefinition;
import androidx.animation.TransitionSpec;
import androidx.animation.TransitionState;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000m\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\bJ\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\nH\u0002J\b\u00100\u001a\u00020\u001fH\u0002J2\u00101\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u0001\"\b\b\u0002\u00102*\u00020\u00122\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H20\u0010H\u0096\u0002\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020\nH\u0002J\u0016\u00106\u001a\u00020\u001f2\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0002J\b\u00108\u001a\u00020\u001fH\u0002J\u0013\u0010-\u001a\u00020\u001f2\u0006\u00109\u001a\u00028\u0000\u00a2\u0006\u0002\u0010:Ja\u0010;\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H20\u0013\"\u0004\b\u0001\u0010\u0001\"\b\b\u0002\u00102*\u00020\u0012*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H20\u00102\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H20=2\u0006\u0010>\u001a\u0002H\u00012\b\u0010?\u001a\u0004\u0018\u0001H22\u0006\u0010@\u001a\u0002H\u0001H\u0002\u00a2\u0006\u0002\u0010AR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00130\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0016\u0010*\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010,\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Landroidx/animation/TransitionAnimation;", "T", "Landroidx/animation/TransitionState;", "def", "Landroidx/animation/TransitionDefinition;", "clock", "Landroidx/animation/AnimationClockObservable;", "initState", "(Landroidx/animation/TransitionDefinition;Landroidx/animation/AnimationClockObservable;Ljava/lang/Object;)V", "UNSET", "", "animationClockObserver", "androidx/animation/TransitionAnimation$animationClockObserver$1", "Landroidx/animation/TransitionAnimation$animationClockObserver$1;", "currentAnimWrappers", "", "Landroidx/animation/PropKey;", "", "Landroidx/animation/AnimationVector;", "Landroidx/animation/AnimationWrapper;", "currentState", "Landroidx/animation/AnimationState;", "fromState", "Landroidx/animation/StateImpl;", "<set-?>", "", "isRunning", "()Z", "lastFrameTime", "onStateChangeFinished", "Lkotlin/Function1;", "", "getOnStateChangeFinished", "()Lkotlin/jvm/functions/Function1;", "setOnStateChangeFinished", "(Lkotlin/jvm/functions/Function1;)V", "onUpdate", "Lkotlin/Function0;", "getOnUpdate", "()Lkotlin/jvm/functions/Function0;", "setOnUpdate", "(Lkotlin/jvm/functions/Function0;)V", "pendingState", "startTime", "startVelocityMap", "toState", "doAnimationFrame", "frameTimeMillis", "endAnimation", "get", "V", "propKey", "(Landroidx/animation/PropKey;)Ljava/lang/Object;", "getPlayTime", "setState", "newState", "startAnimation", "name", "(Ljava/lang/Object;)V", "createAnimationWrapper", "anim", "Landroidx/animation/Animation;", "start", "startVelocity", "end", "(Landroidx/animation/PropKey;Landroidx/animation/Animation;Ljava/lang/Object;Landroidx/animation/AnimationVector;Ljava/lang/Object;)Landroidx/animation/AnimationWrapper;", "ui-animation-core_release"})
public final class TransitionAnimation<T>
implements TransitionState {
    @Nullable
    private Function0<Unit> onUpdate;
    @Nullable
    private Function1<? super T, Unit> onStateChangeFinished;
    private boolean isRunning;
    private final long UNSET = -1L;
    private StateImpl<T> fromState;
    private StateImpl<T> toState;
    private final AnimationState<T> currentState;
    private long startTime;
    private long lastFrameTime;
    private StateImpl<T> pendingState;
    private Map<PropKey<Object, AnimationVector>, AnimationWrapper<Object, AnimationVector>> currentAnimWrappers;
    private Map<PropKey<Object, AnimationVector>, Object> startVelocityMap;
    private final animationClockObserver.1 animationClockObserver;
    private final TransitionDefinition<T> def;
    private final AnimationClockObservable clock;

    @Nullable
    public final Function0<Unit> getOnUpdate() {
        return this.onUpdate;
    }

    public final void setOnUpdate(@Nullable Function0<Unit> function0) {
        this.onUpdate = function0;
    }

    @Nullable
    public final Function1<T, Unit> getOnStateChangeFinished() {
        return this.onStateChangeFinished;
    }

    public final void setOnStateChangeFinished(@Nullable Function1<? super T, Unit> function1) {
        this.onStateChangeFinished = function1;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    private final void setState(StateImpl<T> newState) {
        TransitionSpec<T> currentSpec;
        if (this.isRunning && (currentSpec = this.def.getSpec$ui_animation_core_release(this.fromState.getName(), this.toState.getName())).getInterruptionHandling() == InterruptionHandling.UNINTERRUPTIBLE) {
            this.pendingState = newState;
            return;
        }
        TransitionSpec<Object> transitionSpec = this.def.getSpec$ui_animation_core_release(this.toState.getName(), newState.getName());
        long playTime = this.getPlayTime();
        Map<PropKey<Object, AnimationVector>, Object> map = newState.getProps$ui_animation_core_release();
        boolean bl = false;
        Iterator<Map.Entry<PropKey<Object, AnimationVector>, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PropKey<Object, AnimationVector>, Object> entry;
            Map.Entry<PropKey<Object, AnimationVector>, Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            PropKey<Object, AnimationVector> prop = entry2.getKey();
            AnimationWrapper<Object, AnimationVector> animationWrapper = this.currentAnimWrappers.get(prop);
            AnimationVector currentVelocity = animationWrapper != null ? animationWrapper.getVelocity(playTime) : null;
            this.currentAnimWrappers.put(prop, this.createAnimationWrapper(prop, transitionSpec.getAnimationForProp$ui_animation_core_release(prop), this.currentState.get(prop), currentVelocity, newState.get(prop)));
        }
        this.fromState = new AnimationState<T>(this.currentState, this.toState.getName());
        this.toState = newState;
        this.startAnimation();
    }

    private final <T, V extends AnimationVector> AnimationWrapper<T, V> createAnimationWrapper(@NotNull PropKey<T, V> $this$createAnimationWrapper, Animation<V> anim, T start, V startVelocity, T end) {
        Object object = startVelocity;
        if (object == null) {
            object = AnimationVectorsKt.newInstance((AnimationVector)$this$createAnimationWrapper.getTypeConverter().getConvertToVector().invoke(start));
        }
        V velocity = object;
        return new TargetBasedAnimationWrapper<T, V>(start, velocity, end, anim, $this$createAnimationWrapper.getTypeConverter());
    }

    private final long getPlayTime() {
        if (this.startTime == this.UNSET) {
            return 0L;
        }
        return this.lastFrameTime - this.startTime;
    }

    public final void toState(T name) {
        StateImpl<T> nextState = this.def.getStates$ui_animation_core_release().get(name);
        if (nextState != null) {
            if (this.pendingState != null && Intrinsics.areEqual(this.toState.getName(), name)) {
                this.pendingState = null;
            } else {
                StateImpl<T> stateImpl = this.pendingState;
                if (stateImpl == null) {
                    stateImpl = this.toState;
                }
                if (!Intrinsics.areEqual(stateImpl.getName(), name)) {
                    this.setState(nextState);
                }
            }
        }
    }

    @Override
    public <T, V extends AnimationVector> T get(@NotNull PropKey<T, V> propKey) {
        Intrinsics.checkParameterIsNotNull(propKey, (String)"propKey");
        return this.currentState.get(propKey);
    }

    private final void startAnimation() {
        if (!this.isRunning) {
            this.isRunning = true;
            this.clock.subscribe(this.animationClockObserver);
        } else {
            this.startTime = this.lastFrameTime;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doAnimationFrame(long frameTimeMillis) {
        block11: {
            boolean bl;
            Map.Entry<PropKey<Object, AnimationVector>, AnimationWrapper<Object, AnimationVector>> entry;
            this.lastFrameTime = frameTimeMillis;
            if (this.startTime == this.UNSET) {
                this.startTime = frameTimeMillis;
            }
            long playTime = this.getPlayTime();
            Object object = this.currentAnimWrappers;
            boolean bl2 = false;
            Iterator<Object> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void prop;
                Map.Entry<PropKey<Object, AnimationVector>, AnimationWrapper<Object, AnimationVector>> entry2;
                entry = entry2 = iterator.next();
                bl = false;
                object = entry.getKey();
                entry = entry2;
                bl = false;
                AnimationWrapper<Object, AnimationVector> animation = entry.getValue();
                this.currentState.set(prop, animation.getValue(playTime));
            }
            CollectionsKt.removeAll((Iterable)this.currentAnimWrappers.entrySet(), (Function1)((Function1)new Function1<Map.Entry<PropKey<Object, AnimationVector>, AnimationWrapper<Object, AnimationVector>>, Boolean>(playTime){
                final /* synthetic */ long $playTime;

                public final boolean invoke(@NotNull Map.Entry<PropKey<Object, AnimationVector>, AnimationWrapper<Object, AnimationVector>> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return it.getValue().isFinished(this.$playTime);
                }
                {
                    this.$playTime = l;
                    super(1);
                }
            }));
            Function0<Unit> function0 = this.onUpdate;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
            if (!this.currentAnimWrappers.isEmpty()) break block11;
            for (PropKey propKey : this.toState.getProps$ui_animation_core_release().keySet()) {
                this.currentState.set(propKey, this.toState.get(propKey));
            }
            this.startVelocityMap.clear();
            this.endAnimation();
            T t = this.toState.getName();
            TransitionSpec<T> spec = this.def.getSpec$ui_animation_core_release(this.fromState.getName(), this.toState.getName());
            Map<T, StateImpl<T>> map = this.def.getStates$ui_animation_core_release();
            entry = spec.getNextState();
            bl = false;
            StateImpl<T> nextState = map.get(entry);
            this.fromState = this.toState;
            if (nextState != null && spec.getInterruptionHandling() == InterruptionHandling.UNINTERRUPTIBLE) {
                this.setState(nextState);
            } else if (this.pendingState != null) {
                StateImpl<T> stateImpl = this.pendingState;
                if (stateImpl == null) {
                    Intrinsics.throwNpe();
                }
                this.setState(stateImpl);
                this.pendingState = null;
            } else if (nextState != null) {
                this.setState(nextState);
            }
            Function1<? super T, Unit> function1 = this.onStateChangeFinished;
            if (function1 != null) {
                Unit cfr_ignored_1 = (Unit)function1.invoke(t);
            }
        }
    }

    private final void endAnimation() {
        this.clock.unsubscribe(this.animationClockObserver);
        this.startTime = this.UNSET;
        this.lastFrameTime = this.UNSET;
        this.isRunning = false;
    }

    public TransitionAnimation(@NotNull TransitionDefinition<T> def, @NotNull AnimationClockObservable clock, @Nullable T initState) {
        Map map;
        Intrinsics.checkParameterIsNotNull(def, (String)"def");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        this.def = def;
        this.clock = clock;
        this.startTime = this.UNSET = -1L;
        this.lastFrameTime = this.UNSET;
        TransitionAnimation transitionAnimation = this;
        boolean bl = false;
        transitionAnimation.currentAnimWrappers = map = (Map)new LinkedHashMap();
        transitionAnimation = this;
        bl = false;
        transitionAnimation.startVelocityMap = map = (Map)new LinkedHashMap();
        this.animationClockObserver = new AnimationClockObserver(this){
            final /* synthetic */ TransitionAnimation this$0;

            public void onAnimationFrame(long frameTimeMillis) {
                TransitionAnimation.access$doAnimationFrame(this.this$0, frameTimeMillis);
            }
            {
                this.this$0 = $outer;
            }
        };
        StateImpl<T> defaultState = null;
        if (initState == null) {
            defaultState = this.def.getDefaultState$ui_animation_core_release();
        } else {
            StateImpl<T> stateImpl = this.def.getStates$ui_animation_core_release().get(initState);
            if (stateImpl == null) {
                Intrinsics.throwNpe();
            }
            defaultState = stateImpl;
        }
        this.currentState = new AnimationState<T>(defaultState, defaultState.getName());
        this.fromState = defaultState;
        this.toState = defaultState;
    }

    public /* synthetic */ TransitionAnimation(TransitionDefinition transitionDefinition, AnimationClockObservable animationClockObservable, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            object = null;
        }
        this(transitionDefinition, animationClockObservable, object);
    }

    public static final /* synthetic */ void access$doAnimationFrame(TransitionAnimation $this, long frameTimeMillis) {
        $this.doAnimationFrame(frameTimeMillis);
    }
}

