/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.AnimationClockObservable;
import androidx.animation.AnimationEndReason;
import androidx.animation.AnimationVector1D;
import androidx.animation.AnimationVectorsKt;
import androidx.animation.BaseAnimatedValue;
import androidx.animation.PropKeyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001a\u0010\u0014\u001a\u00020\u00112\b\b\u0002\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u001e\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Landroidx/animation/AnimatedFloat;", "Landroidx/animation/BaseAnimatedValue;", "", "Landroidx/animation/AnimationVector1D;", "clock", "Landroidx/animation/AnimationClockObservable;", "visibilityThreshold", "(Landroidx/animation/AnimationClockObservable;F)V", "<set-?>", "max", "getMax", "()F", "min", "getMin", "velocity", "getVelocity", "checkFinished", "", "playtime", "", "setBounds", "snapTo", "targetValue", "ui-animation-core_release"})
public abstract class AnimatedFloat
extends BaseAnimatedValue<Float, AnimationVector1D> {
    private float min;
    private float max;

    public final float getMin() {
        return this.min;
    }

    public final float getMax() {
        return this.max;
    }

    public final float getVelocity() {
        return ((AnimationVector1D)this.getVelocityVector$ui_animation_core_release()).getValue();
    }

    public final void setBounds(float min, float max) {
        if (max < min) {
            // empty if block
        }
        this.min = min;
        this.max = max;
        float clamped = RangesKt.coerceIn((float)((Number)this.getValue()).floatValue(), (float)min, (float)max);
        if (clamped != ((Number)this.getValue()).floatValue()) {
            this.setValue(Float.valueOf(clamped));
            if (this.isRunning() && clamped == RangesKt.coerceIn((float)((Number)this.getTargetValue()).floatValue(), (float)min, (float)max) && clamped != ((Number)this.getTargetValue()).floatValue()) {
                this.endAnimation$ui_animation_core_release(AnimationEndReason.BoundReached);
            }
        }
    }

    public static /* synthetic */ void setBounds$default(AnimatedFloat animatedFloat, float f, float f2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setBounds");
        }
        if ((n & 1) != 0) {
            f = FloatCompanionObject.INSTANCE.getNEGATIVE_INFINITY();
        }
        if ((n & 2) != 0) {
            f2 = FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        }
        animatedFloat.setBounds(f, f2);
    }

    @Override
    public void snapTo(float targetValue) {
        super.snapTo(Float.valueOf(RangesKt.coerceIn((float)targetValue, (float)this.min, (float)this.max)));
    }

    @Override
    protected void checkFinished(long playtime) {
        if (((Number)this.getValue()).floatValue() < this.min && ((Number)this.getTargetValue()).floatValue() <= this.min) {
            this.setValue(Float.valueOf(this.min));
            this.endAnimation$ui_animation_core_release(AnimationEndReason.BoundReached);
        } else if (((Number)this.getValue()).floatValue() > this.max && ((Number)this.getTargetValue()).floatValue() >= this.max) {
            this.setValue(Float.valueOf(this.max));
            this.endAnimation$ui_animation_core_release(AnimationEndReason.BoundReached);
        } else {
            this.setValue(Float.valueOf(RangesKt.coerceIn((float)((Number)this.getValue()).floatValue(), (float)this.min, (float)this.max)));
            super.checkFinished(playtime);
        }
    }

    public AnimatedFloat(@NotNull AnimationClockObservable clock, float visibilityThreshold) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(PropKeyKt.getFloatToVectorConverter(), clock, AnimationVectorsKt.AnimationVector(visibilityThreshold), null);
        this.min = FloatCompanionObject.INSTANCE.getNEGATIVE_INFINITY();
        this.max = FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
    }

    public /* synthetic */ AnimatedFloat(AnimationClockObservable animationClockObservable, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.01f;
        }
        this(animationClockObservable, f);
    }
}

