/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.AnimationBuilder;
import androidx.animation.AnimationClockObservable;
import androidx.animation.AnimationClockObserver;
import androidx.animation.AnimationEndReason;
import androidx.animation.AnimationVector;
import androidx.animation.AnimationVectorsKt;
import androidx.animation.AnimationWrapper;
import androidx.animation.BaseAnimatedValue;
import androidx.animation.PhysicsBuilder;
import androidx.animation.TargetBasedAnimationWrapper;
import androidx.animation.TwoWayConverter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0016\b6\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004B-\b\u0002\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\nJA\u00108\u001a\u00020#2\u0006\u0010*\u001a\u00028\u00002\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u0000092\u001c\b\u0002\u0010 \u001a\u0016\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020#\u0018\u00010!\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020\u001fH\u0014J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000>H\u0002J\u0010\u0010?\u001a\u00020#2\u0006\u0010@\u001a\u00020\u001fH\u0002J\u0017\u0010A\u001a\u00020#2\b\b\u0002\u0010B\u001a\u00020\"H\u0000\u00a2\u0006\u0002\bCJ\u001f\u0010D\u001a\u00020#2\u0006\u0010B\u001a\u00020\"2\u0006\u0010E\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\bF\u0010GJ\u0015\u0010H\u001a\u00020#2\u0006\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010-J!\u0010I\u001a\u00020#2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014H\u0000\u00a2\u0006\u0002\bJJ\u0006\u0010K\u001a\u00020#R\u001a\u0010\u000b\u001a\u0004\u0018\u00018\u00008BX\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u0004\u0018\u00018\u00018BX\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010 \u001a\u0016\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020#\u0018\u00010!X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010*\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u00008F@@X\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\r\"\u0004\b,\u0010-R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\"\u00100\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000@dX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010\r\"\u0004\b2\u0010-R$\u00103\u001a\u00028\u00012\u0006\u00100\u001a\u00028\u00018@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010\u0011\"\u0004\b5\u00106R\u0018\u0010\t\u001a\u0004\u0018\u00018\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b7\u0010\u0011\u0082\u0001\u0002LM\u00a8\u0006N"}, d2={"Landroidx/animation/BaseAnimatedValue;", "T", "V", "Landroidx/animation/AnimationVector;", "", "typeConverter", "Landroidx/animation/TwoWayConverter;", "clock", "Landroidx/animation/AnimationClockObservable;", "visibilityThreshold", "(Landroidx/animation/TwoWayConverter;Landroidx/animation/AnimationClockObservable;Landroidx/animation/AnimationVector;)V", "_targetBackingField", "get_targetBackingField", "()Ljava/lang/Object;", "Ljava/lang/Object;", "_velocityBackField", "get_velocityBackField", "()Landroidx/animation/AnimationVector;", "Landroidx/animation/AnimationVector;", "anim", "Landroidx/animation/AnimationWrapper;", "animationClockObserver", "androidx/animation/BaseAnimatedValue$animationClockObserver$1", "Landroidx/animation/BaseAnimatedValue$animationClockObserver$1;", "<set-?>", "", "isRunning", "()Z", "setRunning$ui_animation_core_release", "(Z)V", "lastFrameTime", "", "onEnd", "Lkotlin/Function2;", "Landroidx/animation/AnimationEndReason;", "", "getOnEnd$ui_animation_core_release", "()Lkotlin/jvm/functions/Function2;", "setOnEnd$ui_animation_core_release", "(Lkotlin/jvm/functions/Function2;)V", "startTime", "newTarget", "targetValue", "getTargetValue", "setTargetValue$ui_animation_core_release", "(Ljava/lang/Object;)V", "getTypeConverter$ui_animation_core_release", "()Landroidx/animation/TwoWayConverter;", "value", "getValue", "setValue", "velocityVector", "getVelocityVector$ui_animation_core_release", "setVelocityVector$ui_animation_core_release", "(Landroidx/animation/AnimationVector;)V", "getVisibilityThreshold$ui_animation_core_release", "animateTo", "Landroidx/animation/AnimationBuilder;", "(Ljava/lang/Object;Landroidx/animation/AnimationBuilder;Lkotlin/jvm/functions/Function2;)V", "checkFinished", "playtime", "defaultPhysicsBuilder", "Landroidx/animation/PhysicsBuilder;", "doAnimationFrame", "timeMillis", "endAnimation", "endReason", "endAnimation$ui_animation_core_release", "notifyEnded", "endValue", "notifyEnded$ui_animation_core_release", "(Landroidx/animation/AnimationEndReason;Ljava/lang/Object;)V", "snapTo", "startAnimation", "startAnimation$ui_animation_core_release", "stop", "Landroidx/animation/AnimatedValue;", "Landroidx/animation/AnimatedFloat;", "ui-animation-core_release"})
public abstract class BaseAnimatedValue<T, V extends AnimationVector> {
    private boolean isRunning;
    private T _targetBackingField;
    private V _velocityBackField;
    @Nullable
    private Function2<? super AnimationEndReason, ? super T, Unit> onEnd;
    private AnimationWrapper<T, V> anim;
    private long startTime;
    private long lastFrameTime;
    private animationClockObserver.1 animationClockObserver;
    @NotNull
    private final TwoWayConverter<T, V> typeConverter;
    private final AnimationClockObservable clock;
    @Nullable
    private final V visibilityThreshold;

    public abstract T getValue();

    protected abstract void setValue(T var1);

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final void setRunning$ui_animation_core_release(boolean bl) {
        this.isRunning = bl;
    }

    public final T getTargetValue() {
        if (this.get_targetBackingField() != null) {
            T t = this.get_targetBackingField();
            Intrinsics.checkNotNull(t);
            return t;
        }
        return this.getValue();
    }

    public final void setTargetValue$ui_animation_core_release(T newTarget) {
        this._targetBackingField = newTarget;
    }

    private final T get_targetBackingField() {
        if (this._targetBackingField == null) {
            this._targetBackingField = this.getValue();
        }
        return this._targetBackingField;
    }

    @NotNull
    public final V getVelocityVector$ui_animation_core_release() {
        V v = this.get_velocityBackField();
        Intrinsics.checkNotNull(v);
        return v;
    }

    public final void setVelocityVector$ui_animation_core_release(@NotNull V value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this._velocityBackField = value;
    }

    private final V get_velocityBackField() {
        if (this._velocityBackField == null) {
            this._velocityBackField = AnimationVectorsKt.newInstance((AnimationVector)this.typeConverter.getConvertToVector().invoke(this.getValue()));
        }
        return this._velocityBackField;
    }

    @Nullable
    public final Function2<AnimationEndReason, T, Unit> getOnEnd$ui_animation_core_release() {
        return this.onEnd;
    }

    public final void setOnEnd$ui_animation_core_release(@Nullable Function2<? super AnimationEndReason, ? super T, Unit> function2) {
        this.onEnd = function2;
    }

    private final PhysicsBuilder<T> defaultPhysicsBuilder() {
        PhysicsBuilder physicsBuilder;
        V v = this.visibilityThreshold;
        if (v != null) {
            V v2 = v;
            boolean bl = false;
            boolean bl2 = false;
            V it = v2;
            boolean bl3 = false;
            physicsBuilder = new PhysicsBuilder(0.0f, 0.0f, this.typeConverter.getConvertFromVector().invoke(it), 3, null);
        } else {
            physicsBuilder = new PhysicsBuilder(0.0f, 0.0f, 0.0f, 7, null);
        }
        return physicsBuilder;
    }

    public final void animateTo(T targetValue, @NotNull AnimationBuilder<T> anim, @Nullable Function2<? super AnimationEndReason, ? super T, Unit> onEnd) {
        Intrinsics.checkNotNullParameter(anim, (String)"anim");
        if (this.isRunning) {
            this.notifyEnded$ui_animation_core_release(AnimationEndReason.Interrupted, this.getValue());
        }
        this.setTargetValue$ui_animation_core_release(targetValue);
        TargetBasedAnimationWrapper<T, V> animationWrapper = new TargetBasedAnimationWrapper<T, V>(this.getValue(), this.getVelocityVector$ui_animation_core_release(), targetValue, anim.build$ui_animation_core_release(this.typeConverter), this.typeConverter);
        this.onEnd = onEnd;
        this.startAnimation$ui_animation_core_release(animationWrapper);
    }

    public static /* synthetic */ void animateTo$default(BaseAnimatedValue baseAnimatedValue, Object object, AnimationBuilder animationBuilder, Function2 function2, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: animateTo");
        }
        if ((n & 2) != 0) {
            animationBuilder = baseAnimatedValue.defaultPhysicsBuilder();
        }
        if ((n & 4) != 0) {
            function2 = null;
        }
        baseAnimatedValue.animateTo(object, animationBuilder, function2);
    }

    public void snapTo(T targetValue) {
        this.stop();
        this.setValue(targetValue);
        this.setTargetValue$ui_animation_core_release(targetValue);
    }

    public final void stop() {
        if (this.isRunning) {
            this.endAnimation$ui_animation_core_release(AnimationEndReason.Interrupted);
        }
    }

    public final void notifyEnded$ui_animation_core_release(@NotNull AnimationEndReason endReason, T endValue) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)endReason), (String)"endReason");
            Function2<? super AnimationEndReason, ? super T, Unit> onEnd = this.onEnd;
            this.onEnd = null;
            Function2<? super AnimationEndReason, ? super T, Unit> function2 = onEnd;
            if (function2 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function2.invoke((Object)endReason, endValue);
        }
    }

    private final void doAnimationFrame(long timeMillis) {
        long playtime = 0L;
        if (this.startTime == -1L) {
            this.startTime = timeMillis;
            playtime = 0L;
        } else {
            playtime = timeMillis - this.startTime;
        }
        this.lastFrameTime = timeMillis;
        AnimationWrapper<T, V> animationWrapper = this.anim;
        if (animationWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anim");
        }
        this.setValue(animationWrapper.getValue(playtime));
        AnimationWrapper<T, V> animationWrapper2 = this.anim;
        if (animationWrapper2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anim");
        }
        this.setVelocityVector$ui_animation_core_release(animationWrapper2.getVelocity(playtime));
        this.checkFinished(playtime);
    }

    protected void checkFinished(long playtime) {
        AnimationWrapper<T, V> animationWrapper = this.anim;
        if (animationWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anim");
        }
        boolean animationFinished = animationWrapper.isFinished(playtime);
        if (animationFinished) {
            BaseAnimatedValue.endAnimation$ui_animation_core_release$default(this, null, 1, null);
        }
    }

    public final void startAnimation$ui_animation_core_release(@NotNull AnimationWrapper<T, V> anim) {
        Intrinsics.checkNotNullParameter(anim, (String)"anim");
        this.anim = anim;
        if (anim.isFinished(0L)) {
            BaseAnimatedValue.endAnimation$ui_animation_core_release$default(this, null, 1, null);
            return;
        }
        if (this.isRunning) {
            this.startTime = this.lastFrameTime;
        } else {
            this.startTime = -1L;
            this.isRunning = true;
            this.clock.subscribe(this.animationClockObserver);
        }
    }

    public final void endAnimation$ui_animation_core_release(@NotNull AnimationEndReason endReason) {
        Intrinsics.checkNotNullParameter((Object)((Object)endReason), (String)"endReason");
        this.clock.unsubscribe(this.animationClockObserver);
        this.isRunning = false;
        this.startTime = -1L;
        this.lastFrameTime = -1L;
        this.notifyEnded$ui_animation_core_release(endReason, this.getValue());
        ((AnimationVector)this.getVelocityVector$ui_animation_core_release()).reset$ui_animation_core_release();
    }

    public static /* synthetic */ void endAnimation$ui_animation_core_release$default(BaseAnimatedValue baseAnimatedValue, AnimationEndReason animationEndReason, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: endAnimation");
        }
        if ((n & 1) != 0) {
            animationEndReason = AnimationEndReason.TargetReached;
        }
        baseAnimatedValue.endAnimation$ui_animation_core_release(animationEndReason);
    }

    @NotNull
    public final TwoWayConverter<T, V> getTypeConverter$ui_animation_core_release() {
        return this.typeConverter;
    }

    @Nullable
    public final V getVisibilityThreshold$ui_animation_core_release() {
        return this.visibilityThreshold;
    }

    private BaseAnimatedValue(TwoWayConverter<T, V> typeConverter, AnimationClockObservable clock, V visibilityThreshold) {
        this.typeConverter = typeConverter;
        this.clock = clock;
        this.visibilityThreshold = visibilityThreshold;
        this.startTime = -1L;
        this.lastFrameTime = -1L;
        this.animationClockObserver = new AnimationClockObserver(this){
            final /* synthetic */ BaseAnimatedValue this$0;

            public void onAnimationFrame(long frameTimeMillis) {
                BaseAnimatedValue.access$doAnimationFrame(this.this$0, frameTimeMillis);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public /* synthetic */ BaseAnimatedValue(TwoWayConverter typeConverter, AnimationClockObservable clock, AnimationVector visibilityThreshold, DefaultConstructorMarker $constructor_marker) {
        this(typeConverter, clock, visibilityThreshold);
    }

    public static final /* synthetic */ void access$doAnimationFrame(BaseAnimatedValue $this, long timeMillis) {
        $this.doAnimationFrame(timeMillis);
    }
}

