/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.AnimationVector1D;
import androidx.animation.AnimationWrapper;
import androidx.animation.DecayAnimation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/animation/DecayAnimationWrapper;", "Landroidx/animation/AnimationWrapper;", "", "Landroidx/animation/AnimationVector1D;", "startValue", "startVelocity", "anim", "Landroidx/animation/DecayAnimation;", "(FFLandroidx/animation/DecayAnimation;)V", "durationMillis", "", "getDurationMillis", "()J", "target", "velocityVector", "getValue", "playTime", "(J)Ljava/lang/Float;", "getVelocity", "ui-animation-core_release"})
public final class DecayAnimationWrapper
implements AnimationWrapper<Float, AnimationVector1D> {
    private final float target;
    private final AnimationVector1D velocityVector;
    private final long durationMillis;
    private final float startValue;
    private final float startVelocity;
    private final DecayAnimation anim;

    @Override
    @NotNull
    public Float getValue(long playTime) {
        if (!this.isFinished(playTime)) {
            return Float.valueOf(this.anim.getValue(playTime, this.startValue, this.startVelocity));
        }
        return Float.valueOf(this.target);
    }

    @Override
    @NotNull
    public AnimationVector1D getVelocity(long playTime) {
        if (!this.isFinished(playTime)) {
            this.velocityVector.setValue$ui_animation_core_release(this.anim.getVelocity(playTime, this.startValue, this.startVelocity));
        } else {
            float f = this.startVelocity;
            float f2 = this.anim.getAbsVelocityThreshold();
            AnimationVector1D animationVector1D = this.velocityVector;
            boolean bl = false;
            float f3 = Math.signum(f);
            animationVector1D.setValue$ui_animation_core_release(f2 * f3);
        }
        return this.velocityVector;
    }

    @Override
    public long getDurationMillis() {
        return this.durationMillis;
    }

    public DecayAnimationWrapper(float startValue, float startVelocity, @NotNull DecayAnimation anim) {
        Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
        this.startValue = startValue;
        this.startVelocity = startVelocity;
        this.anim = anim;
        this.target = this.anim.getTarget(this.startValue, this.startVelocity);
        this.velocityVector = new AnimationVector1D(0.0f);
        this.durationMillis = this.anim.getDurationMillis(this.startValue, this.startVelocity);
    }

    public /* synthetic */ DecayAnimationWrapper(float f, float f2, DecayAnimation decayAnimation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        this(f, f2, decayAnimation);
    }

    @Override
    public boolean isFinished(long playTime) {
        return AnimationWrapper.DefaultImpls.isFinished(this, playTime);
    }
}

