/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.Animation;
import androidx.animation.AnimationBuilder;
import androidx.animation.AnimationVector;
import androidx.animation.DurationBasedAnimationBuilder;
import androidx.animation.Repeatable;
import androidx.animation.TwoWayConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J1\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\b\b\u0001\u0010\u0014*\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00140\u0017H\u0010\u00a2\u0006\u0002\b\u0018R\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR*\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Landroidx/animation/RepeatableBuilder;", "T", "Landroidx/animation/AnimationBuilder;", "()V", "animation", "Landroidx/animation/DurationBasedAnimationBuilder;", "getAnimation", "()Landroidx/animation/DurationBasedAnimationBuilder;", "setAnimation", "(Landroidx/animation/DurationBasedAnimationBuilder;)V", "value", "", "iterations", "getIterations", "()Ljava/lang/Integer;", "setIterations", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "build", "Landroidx/animation/Animation;", "V", "Landroidx/animation/AnimationVector;", "converter", "Landroidx/animation/TwoWayConverter;", "build$ui_animation_core_release", "ui-animation-core_release"})
public final class RepeatableBuilder<T>
extends AnimationBuilder<T> {
    @Nullable
    private Integer iterations;
    @Nullable
    private DurationBasedAnimationBuilder<T> animation;

    @Nullable
    public final Integer getIterations() {
        return this.iterations;
    }

    public final void setIterations(@Nullable Integer value) {
        if (value != null && value < 1) {
            throw (Throwable)new IllegalStateException("Iterations count can't be less than 1");
        }
        this.iterations = value;
    }

    @Nullable
    public final DurationBasedAnimationBuilder<T> getAnimation() {
        return this.animation;
    }

    public final void setAnimation(@Nullable DurationBasedAnimationBuilder<T> durationBasedAnimationBuilder) {
        this.animation = durationBasedAnimationBuilder;
    }

    @Override
    @NotNull
    public <V extends AnimationVector> Animation<V> build$ui_animation_core_release(@NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        Integer n = this.iterations;
        if (n == null) {
            throw (Throwable)new IllegalStateException("The iterations count should be provided");
        }
        long iterationsCount = n.intValue();
        DurationBasedAnimationBuilder<T> durationBasedAnimationBuilder = this.animation;
        if (durationBasedAnimationBuilder == null) {
            throw (Throwable)new IllegalStateException("The animation should be provided");
        }
        DurationBasedAnimationBuilder<T> animation = durationBasedAnimationBuilder;
        return new Repeatable<V>(iterationsCount, animation.build$ui_animation_core_release(converter));
    }
}

