/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.FloatAnimation;
import androidx.animation.Motion;
import androidx.animation.SpringEstimationKt;
import androidx.animation.SpringSimulation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J(\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\nH\u0016J(\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016J(\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/animation/SpringAnimation;", "Landroidx/animation/FloatAnimation;", "dampingRatio", "", "stiffness", "displacementThreshold", "(FFF)V", "spring", "Landroidx/animation/SpringSimulation;", "getDurationMillis", "", "start", "end", "startVelocity", "getEndVelocity", "animationDuration", "getValue", "playTime", "getVelocity", "ui-animation-core_release"})
public final class SpringAnimation
implements FloatAnimation {
    private final SpringSimulation spring;
    private final float displacementThreshold;

    @Override
    public float getValue(long playTime, float start, float end, float startVelocity) {
        this.spring.setFinalPosition(end);
        float value = Motion.getValue-impl(this.spring.updateValues$ui_animation_core_release(start, startVelocity, playTime));
        return value;
    }

    @Override
    public float getVelocity(long playTime, float start, float end, float startVelocity) {
        this.spring.setFinalPosition(end);
        float velocity = Motion.getVelocity-impl(this.spring.updateValues$ui_animation_core_release(start, startVelocity, playTime));
        return velocity;
    }

    @Override
    public float getEndVelocity(float start, float end, float startVelocity, long animationDuration) {
        return 0.0f;
    }

    @Override
    public long getDurationMillis(float start, float end, float startVelocity) {
        float f = 1.0f;
        float f2 = startVelocity / this.displacementThreshold;
        float f3 = (start - end) / this.displacementThreshold;
        return SpringEstimationKt.estimateAnimationDurationMillis(this.spring.getStiffness(), this.spring.getDampingRatio(), f2, f3, f);
    }

    public SpringAnimation(float dampingRatio, float stiffness, float displacementThreshold) {
        SpringSimulation springSimulation;
        this.displacementThreshold = displacementThreshold;
        SpringSimulation springSimulation2 = new SpringSimulation(1.0f);
        SpringAnimation springAnimation = this;
        boolean bl = false;
        boolean bl2 = false;
        SpringSimulation it = springSimulation2;
        boolean bl3 = false;
        it.setDampingRatio(dampingRatio);
        it.setStiffness(stiffness);
        springAnimation.spring = springSimulation = springSimulation2;
    }

    public /* synthetic */ SpringAnimation(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1500.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.01f;
        }
        this(f, f2, f3);
    }

    public SpringAnimation() {
        this(0.0f, 0.0f, 0.0f, 7, null);
    }
}

