/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.Animation;
import androidx.animation.AnimationVector;
import androidx.animation.AnimationVectorsKt;
import androidx.animation.SpringAnimation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\t\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ-\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0012\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0013\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001e"}, d2={"Landroidx/animation/SpringAnimationVector;", "V", "Landroidx/animation/AnimationVector;", "Landroidx/animation/Animation;", "dampingRatio", "", "stiffness", "threshold", "(FFLandroidx/animation/AnimationVector;)V", "anims", "", "Landroidx/animation/SpringAnimation;", "getDampingRatio", "()F", "getStiffness", "getThreshold", "()Landroidx/animation/AnimationVector;", "Landroidx/animation/AnimationVector;", "valueVector", "velocityVector", "getDurationMillis", "", "start", "end", "startVelocity", "(Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;)J", "getValue", "playTime", "(JLandroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;)Landroidx/animation/AnimationVector;", "getVelocity", "ui-animation-core_release"})
final class SpringAnimationVector<V extends AnimationVector>
implements Animation<V> {
    private final List<SpringAnimation> anims;
    private V valueVector;
    private V velocityVector;
    private final float dampingRatio;
    private final float stiffness;
    @NotNull
    private final V threshold;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getValue(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(start);
        }
        int n = 0;
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
        }
        int n2 = ((AnimationVector)v).getSize$ui_animation_core_release();
        while (n < n2) {
            void i;
            V v2 = this.valueVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            }
            ((AnimationVector)v2).set$ui_animation_core_release((int)i, this.anims.get((int)i).getValue(playTime, ((AnimationVector)start).get$ui_animation_core_release((int)i), ((AnimationVector)end).get$ui_animation_core_release((int)i), ((AnimationVector)startVelocity).get$ui_animation_core_release((int)i)));
            ++i;
        }
        V v3 = this.valueVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getVelocity(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(startVelocity);
        }
        int n = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
        }
        int n2 = ((AnimationVector)v).getSize$ui_animation_core_release();
        while (n < n2) {
            void i;
            V v2 = this.velocityVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            }
            ((AnimationVector)v2).set$ui_animation_core_release((int)i, this.anims.get((int)i).getVelocity(playTime, ((AnimationVector)start).get$ui_animation_core_release((int)i), ((AnimationVector)end).get$ui_animation_core_release((int)i), ((AnimationVector)startVelocity).get$ui_animation_core_release((int)i)));
            ++i;
        }
        V v3 = this.velocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
        }
        return v3;
    }

    @Override
    public long getDurationMillis(@NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        long maxDuration = 0L;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)((AnimationVector)start).getSize$ui_animation_core_release());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            long l;
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            long l2 = maxDuration;
            long l3 = this.anims.get(it).getDurationMillis(((AnimationVector)start).get$ui_animation_core_release(it), ((AnimationVector)end).get$ui_animation_core_release(it), ((AnimationVector)startVelocity).get$ui_animation_core_release(it));
            boolean bl2 = false;
            maxDuration = l = Math.max(l2, l3);
        }
        return maxDuration;
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    public final float getStiffness() {
        return this.stiffness;
    }

    @NotNull
    public final V getThreshold() {
        return this.threshold;
    }

    /*
     * WARNING - void declaration
     */
    public SpringAnimationVector(float dampingRatio, float stiffness, @NotNull V threshold) {
        Collection<SpringAnimation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(threshold, (String)"threshold");
        this.dampingRatio = dampingRatio;
        this.stiffness = stiffness;
        this.threshold = threshold;
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)((AnimationVector)this.threshold).getSize$ui_animation_core_release());
        SpringAnimationVector springAnimationVector = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void index;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            SpringAnimation springAnimation = new SpringAnimation(this.dampingRatio, this.stiffness, ((AnimationVector)this.threshold).get$ui_animation_core_release((int)index));
            collection.add(springAnimation);
        }
        collection = (List)destination$iv$iv;
        springAnimationVector.anims = collection;
    }

    @Override
    @NotNull
    public V getEndVelocity(@NotNull V start, @NotNull V end, @NotNull V startVelocity, long animationDuration) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return Animation.DefaultImpls.getEndVelocity(this, start, end, startVelocity, animationDuration);
    }

    public static final /* synthetic */ AnimationVector access$getValueVector$p(SpringAnimationVector $this) {
        Object v = $this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
        }
        return v;
    }

    public static final /* synthetic */ void access$setValueVector$p(SpringAnimationVector $this, AnimationVector animationVector) {
        $this.valueVector = animationVector;
    }

    public static final /* synthetic */ AnimationVector access$getVelocityVector$p(SpringAnimationVector $this) {
        Object v = $this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
        }
        return v;
    }

    public static final /* synthetic */ void access$setVelocityVector$p(SpringAnimationVector $this, AnimationVector animationVector) {
        $this.velocityVector = animationVector;
    }
}

