/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.ComplexDouble;
import androidx.animation.ComplexDoubleKt;
import androidx.animation.SpringEstimationKt;
import androidx.annotation.VisibleForTesting;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DoubleCompanionObject;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0007\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0007\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0007\u001a4\u0010\f\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a<\u0010\u0012\u001a\u00020\u00012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a4\u0010\u0014\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a4\u0010\u0015\u001a\u00020\u00032\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a9\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0019H\u0082\b\u001a\r\u0010\u001b\u001a\u00020\u001c*\u00020\u0003H\u0082\b\u00a8\u0006\u001d"}, d2={"estimateAnimationDurationMillis", "", "stiffness", "", "dampingRatio", "initialVelocity", "initialDisplacement", "delta", "springConstant", "dampingCoefficient", "mass", "", "estimateCriticallyDamped", "roots", "Lkotlin/Pair;", "Landroidx/animation/ComplexDouble;", "p0", "v0", "estimateDurationInternal", "initialPosition", "estimateOverDamped", "estimateUnderDamped", "iterateNewtonsMethod", "x", "fn", "Lkotlin/Function1;", "fnPrime", "isNotFinite", "", "ui-animation-core_release"})
public final class SpringEstimationKt {
    @VisibleForTesting(otherwise=3)
    public static final long estimateAnimationDurationMillis(float stiffness, float dampingRatio, float initialVelocity, float initialDisplacement, float delta) {
        return SpringEstimationKt.estimateAnimationDurationMillis((double)stiffness, (double)dampingRatio, (double)initialVelocity, (double)initialDisplacement, (double)delta);
    }

    @VisibleForTesting(otherwise=3)
    public static final long estimateAnimationDurationMillis(double stiffness, double dampingRatio, double initialVelocity, double initialDisplacement, double delta) {
        double d = 2.0 * dampingRatio;
        boolean bl = false;
        double d2 = Math.sqrt(stiffness);
        double dampingCoefficient = d * d2;
        Pair<ComplexDouble, ComplexDouble> roots = ComplexDoubleKt.complexQuadraticFormula(1.0, dampingCoefficient, stiffness);
        return SpringEstimationKt.estimateDurationInternal(roots, dampingRatio, initialVelocity, initialDisplacement, delta);
    }

    @VisibleForTesting(otherwise=3)
    public static final long estimateAnimationDurationMillis(double springConstant, double dampingCoefficient, double mass, double initialVelocity, double initialDisplacement, double delta) {
        double d = springConstant * mass;
        double d2 = 2.0;
        boolean bl = false;
        double d3 = Math.sqrt(d);
        double criticalDamping = d2 * d3;
        double dampingRatio = dampingCoefficient / criticalDamping;
        Pair<ComplexDouble, ComplexDouble> roots = ComplexDoubleKt.complexQuadraticFormula(mass, dampingCoefficient, springConstant);
        return SpringEstimationKt.estimateDurationInternal(roots, dampingRatio, initialVelocity, initialDisplacement, delta);
    }

    private static final double estimateUnderDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        double r = ((ComplexDouble)roots.getFirst()).getReal();
        double c1 = p0;
        double c2 = (v0 - r * c1) / ((ComplexDouble)roots.getFirst()).getImaginary();
        double d = c1 * c1 + c2 * c2;
        boolean bl = false;
        double c = Math.sqrt(d);
        d = delta / c;
        bl = false;
        return Math.log(d) / r;
    }

    /*
     * Unable to fully structure code
     */
    private static final double estimateCriticallyDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        block13: {
            block12: {
                r = ((ComplexDouble)roots.getFirst()).getReal();
                c1 = p0;
                c2 = v0 - r * c1;
                $fun$t2Iterate$1 = estimateCriticallyDamped.1.INSTANCE;
                var16_8 = delta / c1;
                var18_9 = false;
                var16_8 = Math.abs(var16_8);
                var18_9 = false;
                t1 = Math.log(var16_8) / r;
                var18_10 = delta / c2;
                var35_12 = $fun$t2Iterate$1;
                var20_13 = false;
                var18_10 = var36_17 = Math.abs(var18_10);
                var20_13 = false;
                var36_17 = Math.log(var18_10);
                t2 = var35_12.invoke(var36_17, r) / r;
                $this$isNotFinite$iv = t1;
                $i$f$isNotFinite = false;
                var23_20 = $this$isNotFinite$iv;
                var25_21 = false;
                var26_24 = var23_20;
                var28_26 = false;
                if (Double.isInfinite(var26_24)) ** GOTO lbl-1000
                var26_24 = var23_20;
                var28_26 = false;
                if (!Double.isNaN(var26_24)) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!(v0 == false)) break block12;
                v1 = t2;
                break block13;
            }
            $this$isNotFinite$iv = t2;
            $i$f$isNotFinite = false;
            var23_20 = $this$isNotFinite$iv;
            var25_21 = false;
            var26_24 = var23_20;
            var28_26 = false;
            if (Double.isInfinite(var26_24)) ** GOTO lbl-1000
            var26_24 = var23_20;
            var28_26 = false;
            if (!Double.isNaN(var26_24)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (v2 == false) {
                v1 = t1;
            } else {
                $this$isNotFinite$iv = false;
                v1 = Math.max(t1, t2);
            }
        }
        tCurr = v1;
        tInflection = -(r * c1 + c2) / (r * c2);
        $fun$xInflection$2 = new Function0<Double>(c1, r, tInflection, c2){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $r;
            final /* synthetic */ double $tInflection;
            final /* synthetic */ double $c2;

            public final double invoke() {
                double d = this.$r * this.$tInflection;
                double d2 = this.$c1;
                boolean bl = false;
                double d3 = Math.exp(d);
                double d4 = d2 * d3;
                d = this.$r * this.$tInflection;
                d3 = this.$c2 * this.$tInflection;
                d2 = d4;
                bl = false;
                double d5 = Math.exp(d);
                return d2 + d3 * d5;
            }
            {
                this.$c1 = d;
                this.$r = d2;
                this.$tInflection = d3;
                this.$c2 = d4;
                super(0);
            }
        };
        var25_22 = tInflection;
        var27_27 = false;
        if (Double.isNaN(var25_22) || tInflection <= 0.0) {
            v3 = -delta;
        } else if (tInflection > 0.0 && -$fun$xInflection$2.invoke() < delta) {
            if (c2 < (double)false && c1 > (double)false) {
                tCurr = 0.0;
            }
            v3 = -delta;
        } else {
            tCurr = tConcavChange = -(2.0 / r) - c1 / c2;
            v3 = delta;
        }
        signedDelta = v3;
        fn = (Function1)new Function1<Double, Double>(c1, c2, r, signedDelta){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r;
            final /* synthetic */ double $signedDelta;

            public final double invoke(double t) {
                double d = this.$r * t;
                double d2 = this.$c1 + this.$c2 * t;
                boolean bl = false;
                double d3 = Math.exp(d);
                return d2 * d3 + this.$signedDelta;
            }
            {
                this.$c1 = d;
                this.$c2 = d2;
                this.$r = d3;
                this.$signedDelta = d4;
                super(1);
            }
        };
        fnPrime = (Function1)new Function1<Double, Double>(c2, r, c1){
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r;
            final /* synthetic */ double $c1;

            public final double invoke(double t) {
                double d = this.$r * t;
                double d2 = this.$c2 * (this.$r * t + 1.0) + this.$c1 * this.$r;
                boolean bl = false;
                double d3 = Math.exp(d);
                return d2 * d3;
            }
            {
                this.$c2 = d;
                this.$r = d2;
                this.$c1 = d3;
                super(1);
            }
        };
        tDelta = DoubleCompanionObject.INSTANCE.getMAX_VALUE();
        iterations = 0;
        while (tDelta > 0.001 && iterations < 100) {
            ++iterations;
            tLast = tCurr;
            $i$f$iterateNewtonsMethod = false;
            tCurr -= ((Number)fn.invoke((Object)tCurr)).doubleValue() / ((Number)fnPrime.invoke((Object)tCurr)).doubleValue();
            var32_30 = tLast - tCurr;
            var34_32 = false;
            tDelta = Math.abs(var32_30);
        }
        return tCurr;
    }

    /*
     * Unable to fully structure code
     */
    private static final double estimateOverDamped(Pair<ComplexDouble, ComplexDouble> roots, double p0, double v0, double delta) {
        block14: {
            block13: {
                r1 = ((ComplexDouble)roots.getFirst()).getReal();
                r2 = ((ComplexDouble)roots.getSecond()).getReal();
                c2 = (r1 * p0 - v0) / (r1 - r2);
                c1 = p0 - c2;
                var17_8 = delta / c1;
                var19_9 = false;
                var17_8 = Math.abs(var17_8);
                var19_9 = false;
                t1 = Math.log(var17_8) / r1;
                var19_10 = delta / c2;
                var21_12 = false;
                var19_10 = Math.abs(var19_10);
                var21_12 = false;
                t2 = Math.log(var19_10) / r2;
                $this$isNotFinite$iv = t1;
                $i$f$isNotFinite = false;
                var24_19 = $this$isNotFinite$iv;
                var26_20 = false;
                var27_23 = var24_19;
                var29_25 = false;
                if (Double.isInfinite(var27_23)) ** GOTO lbl-1000
                var27_23 = var24_19;
                var29_25 = false;
                if (!Double.isNaN(var27_23)) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!(v0 == false)) break block13;
                v1 = t2;
                break block14;
            }
            $this$isNotFinite$iv = t2;
            $i$f$isNotFinite = false;
            var24_19 = $this$isNotFinite$iv;
            var26_20 = false;
            var27_23 = var24_19;
            var29_25 = false;
            if (Double.isInfinite(var27_23)) ** GOTO lbl-1000
            var27_23 = var24_19;
            var29_25 = false;
            if (!Double.isNaN(var27_23)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (v2 == false) {
                v1 = t1;
            } else {
                $this$isNotFinite$iv = false;
                v1 = Math.max(t1, t2);
            }
        }
        tCurr = v1;
        $i$f$isNotFinite = c1 * r1 / (-c2 * r2);
        var25_26 = false;
        tInflection = Math.log($i$f$isNotFinite) / (r2 - r1);
        $fun$xInflection$1 = new Function0<Double>(c1, r1, tInflection, c2, r2){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $r1;
            final /* synthetic */ double $tInflection;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r2;

            public final double invoke() {
                double d = this.$r1 * this.$tInflection;
                double d2 = this.$c1;
                boolean bl = false;
                double d3 = Math.exp(d);
                double d4 = d2 * d3;
                d = this.$r2 * this.$tInflection;
                d3 = this.$c2;
                d2 = d4;
                bl = false;
                double d5 = Math.exp(d);
                return d2 + d3 * d5;
            }
            {
                this.$c1 = d;
                this.$r1 = d2;
                this.$tInflection = d3;
                this.$c2 = d4;
                this.$r2 = d5;
                super(0);
            }
        };
        var26_21 = tInflection;
        var28_27 = false;
        if (Double.isNaN(var26_21) || tInflection <= 0.0) {
            v3 = -delta;
        } else if (tInflection > 0.0 && -$fun$xInflection$1.invoke() < delta) {
            if (c2 > 0.0 && c1 < 0.0) {
                tCurr = 0.0;
            }
            v3 = -delta;
        } else {
            var28_28 = -(c2 * r2 * r2) / (c1 * r1 * r1);
            var30_30 = false;
            tCurr = tConcavChange = Math.log(var28_28) / (r1 - r2);
            v3 = delta;
        }
        signedDelta = v3;
        fn = (Function1)new Function1<Double, Double>(c1, r1, c2, r2, signedDelta){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $r1;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r2;
            final /* synthetic */ double $signedDelta;

            public final double invoke(double t) {
                double d = this.$r1 * t;
                double d2 = this.$c1;
                boolean bl = false;
                double d3 = Math.exp(d);
                double d4 = d2 * d3;
                d = this.$r2 * t;
                d3 = this.$c2;
                d2 = d4;
                bl = false;
                double d5 = Math.exp(d);
                return d2 + d3 * d5 + this.$signedDelta;
            }
            {
                this.$c1 = d;
                this.$r1 = d2;
                this.$c2 = d3;
                this.$r2 = d4;
                this.$signedDelta = d5;
                super(1);
            }
        };
        fnPrime = (Function1)new Function1<Double, Double>(c1, r1, c2, r2){
            final /* synthetic */ double $c1;
            final /* synthetic */ double $r1;
            final /* synthetic */ double $c2;
            final /* synthetic */ double $r2;

            public final double invoke(double t) {
                double d = this.$r1 * t;
                double d2 = this.$c1 * this.$r1;
                boolean bl = false;
                double d3 = Math.exp(d);
                double d4 = d2 * d3;
                d = this.$r2 * t;
                d3 = this.$c2 * this.$r2;
                d2 = d4;
                bl = false;
                double d5 = Math.exp(d);
                return d2 + d3 * d5;
            }
            {
                this.$c1 = d;
                this.$r1 = d2;
                this.$c2 = d3;
                this.$r2 = d4;
                super(1);
            }
        };
        var28_29 = ((Number)fn.invoke((Object)tCurr)).doubleValue();
        var30_30 = false;
        if (Math.abs(var28_29) < 1.0E-4) {
            return tCurr;
        }
        tDelta = DoubleCompanionObject.INSTANCE.getMAX_VALUE();
        iterations = 0;
        while (tDelta > 0.001 && iterations < 100) {
            ++iterations;
            tLast = tCurr;
            $i$f$iterateNewtonsMethod = false;
            tCurr -= ((Number)fn.invoke((Object)tCurr)).doubleValue() / ((Number)fnPrime.invoke((Object)tCurr)).doubleValue();
            var33_31 = tLast - tCurr;
            var35_33 = false;
            tDelta = Math.abs(var33_31);
        }
        return tCurr;
    }

    private static final long estimateDurationInternal(Pair<ComplexDouble, ComplexDouble> roots, double dampingRatio, double initialVelocity, double initialPosition, double delta) {
        double d;
        if (initialPosition == 0.0 && initialVelocity == 0.0) {
            return 0L;
        }
        double v0 = initialPosition < 0.0 ? -initialVelocity : initialVelocity;
        boolean bl = false;
        double p0 = Math.abs(initialPosition);
        if (dampingRatio > 1.0) {
            double d2 = delta;
            double d3 = p0;
            double d4 = v0;
            d = SpringEstimationKt.estimateOverDamped(roots, d3, d4, d2);
        } else if (dampingRatio < 1.0) {
            double d5 = delta;
            double d6 = p0;
            double d7 = v0;
            d = SpringEstimationKt.estimateUnderDamped(roots, d6, d7, d5);
        } else {
            double d8 = delta;
            double d9 = p0;
            double d10 = v0;
            d = SpringEstimationKt.estimateCriticallyDamped(roots, d9, d10, d8);
        }
        return (long)(d * 1000.0);
    }

    private static final double iterateNewtonsMethod(double x, Function1<? super Double, Double> fn2, Function1<? super Double, Double> fnPrime2) {
        int $i$f$iterateNewtonsMethod = 0;
        return x - ((Number)fn2.invoke((Object)x)).doubleValue() / ((Number)fnPrime2.invoke((Object)x)).doubleValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNotFinite(double $this$isNotFinite) {
        int $i$f$isNotFinite = 0;
        double d = $this$isNotFinite;
        boolean bl = false;
        double d2 = d;
        boolean bl2 = false;
        if (Double.isInfinite(d2)) return true;
        d2 = d;
        bl2 = false;
        if (Double.isNaN(d2)) return true;
        return false;
    }
}

