/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.AnimationClockObservable;
import androidx.animation.AnimationClockObserver;
import androidx.animation.AnimationState;
import androidx.animation.AnimationVector;
import androidx.animation.AnimationWrapper;
import androidx.animation.InterruptionHandling;
import androidx.animation.PropKey;
import androidx.animation.StateImpl;
import androidx.animation.TransitionAnimationKt;
import androidx.animation.TransitionDefinition;
import androidx.animation.TransitionSpec;
import androidx.animation.TransitionState;
import androidx.annotation.RestrictTo;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001<B'\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\bJ\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\nH\u0002J\b\u00101\u001a\u00020 H\u0002J2\u00102\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u0001\"\b\b\u0002\u00103*\u00020\u00112\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H30\u000fH\u0096\u0002\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u00020\nH\u0002J\u0016\u00107\u001a\u00020 2\f\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0002J\b\u00109\u001a\u00020 H\u0002J\u0013\u0010.\u001a\u00020 2\u0006\u0010:\u001a\u00028\u0000\u00a2\u0006\u0002\u0010;R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u00120\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020 \u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010%\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0016\u0010+\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010-\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Landroidx/animation/TransitionAnimation;", "T", "Landroidx/animation/TransitionState;", "def", "Landroidx/animation/TransitionDefinition;", "clock", "Landroidx/animation/AnimationClockObservable;", "initState", "(Landroidx/animation/TransitionDefinition;Landroidx/animation/AnimationClockObservable;Ljava/lang/Object;)V", "UNSET", "", "animationClockObserver", "Landroidx/animation/AnimationClockObserver;", "currentAnimWrappers", "", "Landroidx/animation/PropKey;", "", "Landroidx/animation/AnimationVector;", "Landroidx/animation/AnimationWrapper;", "currentState", "Landroidx/animation/AnimationState;", "getDef$ui_animation_core_release", "()Landroidx/animation/TransitionDefinition;", "fromState", "Landroidx/animation/StateImpl;", "<set-?>", "", "isRunning", "()Z", "lastFrameTime", "onStateChangeFinished", "Lkotlin/Function1;", "", "getOnStateChangeFinished", "()Lkotlin/jvm/functions/Function1;", "setOnStateChangeFinished", "(Lkotlin/jvm/functions/Function1;)V", "onUpdate", "Lkotlin/Function0;", "getOnUpdate", "()Lkotlin/jvm/functions/Function0;", "setOnUpdate", "(Lkotlin/jvm/functions/Function0;)V", "pendingState", "startTime", "startVelocityMap", "toState", "doAnimationFrame", "frameTimeMillis", "endAnimation", "get", "V", "propKey", "(Landroidx/animation/PropKey;)Ljava/lang/Object;", "getPlayTime", "setState", "newState", "startAnimation", "name", "(Ljava/lang/Object;)V", "TransitionAnimationClockObserver", "ui-animation-core_release"})
public final class TransitionAnimation<T>
implements TransitionState {
    @Nullable
    private Function0<Unit> onUpdate;
    @Nullable
    private Function1<? super T, Unit> onStateChangeFinished;
    private boolean isRunning;
    private final long UNSET;
    private StateImpl<T> fromState;
    private StateImpl<T> toState;
    private final AnimationState<T> currentState;
    private long startTime;
    private long lastFrameTime;
    private StateImpl<T> pendingState;
    private Map<PropKey<Object, AnimationVector>, AnimationWrapper<Object, AnimationVector>> currentAnimWrappers;
    private Map<PropKey<Object, AnimationVector>, Object> startVelocityMap;
    private final AnimationClockObserver animationClockObserver;
    @NotNull
    private final TransitionDefinition<T> def;
    private final AnimationClockObservable clock;

    @Nullable
    public final Function0<Unit> getOnUpdate() {
        return this.onUpdate;
    }

    public final void setOnUpdate(@Nullable Function0<Unit> function0) {
        this.onUpdate = function0;
    }

    @Nullable
    public final Function1<T, Unit> getOnStateChangeFinished() {
        return this.onStateChangeFinished;
    }

    public final void setOnStateChangeFinished(@Nullable Function1<? super T, Unit> function1) {
        this.onStateChangeFinished = function1;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    private final void setState(StateImpl<T> newState) {
        TransitionSpec<T> currentSpec;
        if (this.isRunning && (currentSpec = this.def.getSpec$ui_animation_core_release(this.fromState.getName(), this.toState.getName())).getInterruptionHandling() == InterruptionHandling.UNINTERRUPTIBLE) {
            this.pendingState = newState;
            return;
        }
        TransitionSpec<Object> transitionSpec = this.def.getSpec$ui_animation_core_release(this.toState.getName(), newState.getName());
        long playTime = this.getPlayTime();
        Map<PropKey<Object, AnimationVector>, Object> map = newState.getProps$ui_animation_core_release();
        boolean bl = false;
        Iterator<Map.Entry<PropKey<Object, AnimationVector>, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PropKey<Object, AnimationVector>, Object> entry;
            Map.Entry<PropKey<Object, AnimationVector>, Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            PropKey<Object, AnimationVector> prop = entry2.getKey();
            AnimationWrapper<Object, AnimationVector> animationWrapper = this.currentAnimWrappers.get(prop);
            AnimationVector currentVelocity = animationWrapper != null ? animationWrapper.getVelocity(playTime) : null;
            this.currentAnimWrappers.put(prop, TransitionAnimationKt.createAnimationWrapper(prop, transitionSpec.getAnimationForProp$ui_animation_core_release(prop), this.currentState.get(prop), currentVelocity, newState.get(prop)));
        }
        this.fromState = new AnimationState<T>(this.currentState, this.toState.getName());
        this.toState = newState;
        this.startAnimation();
    }

    private final long getPlayTime() {
        if (this.startTime == this.UNSET) {
            return 0L;
        }
        return this.lastFrameTime - this.startTime;
    }

    public final void toState(T name) {
        StateImpl<T> nextState = this.def.getStates$ui_animation_core_release().get(name);
        if (nextState != null) {
            if (this.pendingState != null && Intrinsics.areEqual(this.toState.getName(), name)) {
                this.pendingState = null;
            } else {
                StateImpl<T> stateImpl = this.pendingState;
                if (stateImpl == null) {
                    stateImpl = this.toState;
                }
                if (!Intrinsics.areEqual(stateImpl.getName(), name)) {
                    this.setState(nextState);
                }
            }
        }
    }

    @Override
    public <T, V extends AnimationVector> T get(@NotNull PropKey<T, V> propKey) {
        Intrinsics.checkNotNullParameter(propKey, (String)"propKey");
        return this.currentState.get(propKey);
    }

    private final void startAnimation() {
        if (!this.isRunning) {
            this.isRunning = true;
            this.clock.subscribe(this.animationClockObserver);
        } else {
            this.startTime = this.lastFrameTime;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doAnimationFrame(long frameTimeMillis) {
        block10: {
            boolean bl;
            Map.Entry<PropKey<Object, AnimationVector>, AnimationWrapper<Object, AnimationVector>> entry;
            this.lastFrameTime = frameTimeMillis;
            if (this.startTime == this.UNSET) {
                this.startTime = frameTimeMillis;
            }
            long playTime = this.getPlayTime();
            Object object = this.currentAnimWrappers;
            boolean bl2 = false;
            Iterator<Object> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void prop;
                Map.Entry<PropKey<Object, AnimationVector>, AnimationWrapper<Object, AnimationVector>> entry2;
                entry = entry2 = iterator.next();
                bl = false;
                object = entry.getKey();
                entry = entry2;
                bl = false;
                AnimationWrapper<Object, AnimationVector> animation = entry.getValue();
                this.currentState.set(prop, animation.getValue(playTime));
            }
            CollectionsKt.removeAll((Iterable)this.currentAnimWrappers.entrySet(), (Function1)((Function1)new Function1<Map.Entry<PropKey<Object, AnimationVector>, AnimationWrapper<Object, AnimationVector>>, Boolean>(playTime){
                final /* synthetic */ long $playTime;

                public final boolean invoke(@NotNull Map.Entry<PropKey<Object, AnimationVector>, AnimationWrapper<Object, AnimationVector>> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return it.getValue().isFinished(this.$playTime);
                }
                {
                    this.$playTime = l;
                    super(1);
                }
            }));
            Function0<Unit> function0 = this.onUpdate;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
            if (!this.currentAnimWrappers.isEmpty()) break block10;
            for (PropKey propKey : this.toState.getProps$ui_animation_core_release().keySet()) {
                this.currentState.set(propKey, this.toState.get(propKey));
            }
            this.startVelocityMap.clear();
            this.endAnimation();
            T t = this.toState.getName();
            TransitionSpec<T> spec = this.def.getSpec$ui_animation_core_release(this.fromState.getName(), this.toState.getName());
            Map<T, StateImpl<T>> map = this.def.getStates$ui_animation_core_release();
            entry = spec.getNextState();
            bl = false;
            StateImpl<T> nextState = map.get(entry);
            this.fromState = this.toState;
            if (nextState != null && spec.getInterruptionHandling() == InterruptionHandling.UNINTERRUPTIBLE) {
                this.setState(nextState);
            } else if (this.pendingState != null) {
                StateImpl<T> stateImpl = this.pendingState;
                Intrinsics.checkNotNull(stateImpl);
                this.setState(stateImpl);
                this.pendingState = null;
            } else if (nextState != null) {
                this.setState(nextState);
            }
            Function1<? super T, Unit> function1 = this.onStateChangeFinished;
            if (function1 != null) {
                Unit cfr_ignored_1 = (Unit)function1.invoke(t);
            }
        }
    }

    private final void endAnimation() {
        this.clock.unsubscribe(this.animationClockObserver);
        this.startTime = this.UNSET;
        this.lastFrameTime = this.UNSET;
        this.isRunning = false;
    }

    @NotNull
    public final TransitionDefinition<T> getDef$ui_animation_core_release() {
        return this.def;
    }

    public TransitionAnimation(@NotNull TransitionDefinition<T> def, @NotNull AnimationClockObservable clock, @Nullable T initState) {
        Map map;
        Intrinsics.checkNotNullParameter(def, (String)"def");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.def = def;
        this.clock = clock;
        this.startTime = this.UNSET = -1L;
        this.lastFrameTime = this.UNSET;
        TransitionAnimation transitionAnimation = this;
        boolean bl = false;
        transitionAnimation.currentAnimWrappers = map = (Map)new LinkedHashMap();
        transitionAnimation = this;
        bl = false;
        transitionAnimation.startVelocityMap = map = (Map)new LinkedHashMap();
        this.animationClockObserver = new TransitionAnimationClockObserver();
        StateImpl<T> defaultState = null;
        if (initState == null) {
            defaultState = this.def.getDefaultState$ui_animation_core_release();
        } else {
            StateImpl<T> stateImpl = this.def.getStates$ui_animation_core_release().get(initState);
            Intrinsics.checkNotNull(stateImpl);
            defaultState = stateImpl;
        }
        this.currentState = new AnimationState<T>(defaultState, defaultState.getName());
        this.fromState = defaultState;
        this.toState = defaultState;
    }

    public /* synthetic */ TransitionAnimation(TransitionDefinition transitionDefinition, AnimationClockObservable animationClockObservable, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            object = null;
        }
        this(transitionDefinition, animationClockObservable, object);
    }

    @Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Landroidx/animation/TransitionAnimation$TransitionAnimationClockObserver;", "Landroidx/animation/AnimationClockObserver;", "(Landroidx/animation/TransitionAnimation;)V", "animation", "Landroidx/animation/TransitionAnimation;", "getAnimation", "()Landroidx/animation/TransitionAnimation;", "onAnimationFrame", "", "frameTimeMillis", "", "ui-animation-core_release"})
    private final class TransitionAnimationClockObserver
    implements AnimationClockObserver {
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        private final TransitionAnimation<T> animation;

        @NotNull
        public final TransitionAnimation<T> getAnimation() {
            return this.animation;
        }

        @Override
        public void onAnimationFrame(long frameTimeMillis) {
            TransitionAnimation.this.doAnimationFrame(frameTimeMillis);
        }

        public TransitionAnimationClockObserver() {
            this.animation = TransitionAnimation.this;
        }
    }
}

