/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.FloatAnimation;
import androidx.animation.PropKeyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B<\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012%\u0010\u0005\u001a!\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J(\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J(\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR-\u0010\u0005\u001a!\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/animation/Tween;", "Landroidx/animation/FloatAnimation;", "duration", "", "delay", "easing", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fraction", "Landroidx/animation/Easing;", "(JJLkotlin/jvm/functions/Function1;)V", "getDelay", "()J", "getDuration", "clampPlayTime", "playTime", "getDurationMillis", "start", "end", "startVelocity", "getValue", "getVelocity", "ui-animation-core_release"})
public final class Tween
implements FloatAnimation {
    private final long duration;
    private final long delay;
    private final Function1<Float, Float> easing;

    @Override
    public float getValue(long playTime, float start, float end, float startVelocity) {
        long clampedPlayTime = this.clampPlayTime(playTime);
        float rawFraction = this.duration == 0L ? 1.0f : (float)clampedPlayTime / (float)this.duration;
        float fraction = ((Number)this.easing.invoke((Object)Float.valueOf(RangesKt.coerceIn((float)rawFraction, (float)0.0f, (float)1.0f)))).floatValue();
        return PropKeyKt.lerp(start, end, fraction);
    }

    private final long clampPlayTime(long playTime) {
        return RangesKt.coerceIn((long)(playTime - this.delay), (long)0L, (long)this.duration);
    }

    @Override
    public long getDurationMillis(float start, float end, float startVelocity) {
        return this.delay + this.duration;
    }

    @Override
    public float getVelocity(long playTime, float start, float end, float startVelocity) {
        long clampedPlayTime = this.clampPlayTime(playTime);
        if (clampedPlayTime < 0L) {
            return 0.0f;
        }
        if (clampedPlayTime == 0L) {
            return startVelocity;
        }
        float startNum = this.getValue(clampedPlayTime - 1L, start, end, startVelocity);
        float endNum = this.getValue(clampedPlayTime, start, end, startVelocity);
        return (endNum - startNum) * 1000.0f;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final long getDelay() {
        return this.delay;
    }

    public Tween(long duration2, long delay, @NotNull Function1<? super Float, Float> easing) {
        Intrinsics.checkNotNullParameter(easing, (String)"easing");
        this.duration = duration2;
        this.delay = delay;
        this.easing = easing;
    }

    @Override
    public float getEndVelocity(float start, float end, float startVelocity, long animationDuration) {
        return FloatAnimation.DefaultImpls.getEndVelocity(this, start, end, startVelocity, animationDuration);
    }
}

