/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.AnimationBuilderKt;
import androidx.animation.AnimationVector;
import androidx.animation.DurationBasedAnimation;
import androidx.animation.DurationBasedAnimationBuilder;
import androidx.animation.EasingKt;
import androidx.animation.SimpleDurationBasedAnimation;
import androidx.animation.Tween;
import androidx.animation.TwoWayConverter;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J1\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\b\b\u0001\u0010\u0011*\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00110\u0014H\u0010\u00a2\u0006\u0002\b\u0015R9\u0010\u0004\u001a!\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Landroidx/animation/TweenBuilder;", "T", "Landroidx/animation/DurationBasedAnimationBuilder;", "()V", "easing", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fraction", "Landroidx/animation/Easing;", "getEasing", "()Lkotlin/jvm/functions/Function1;", "setEasing", "(Lkotlin/jvm/functions/Function1;)V", "build", "Landroidx/animation/DurationBasedAnimation;", "V", "Landroidx/animation/AnimationVector;", "converter", "Landroidx/animation/TwoWayConverter;", "build$ui_animation_core_release", "ui-animation-core_release"})
public final class TweenBuilder<T>
extends DurationBasedAnimationBuilder<T> {
    @NotNull
    private Function1<? super Float, Float> easing = EasingKt.getFastOutSlowInEasing();

    @NotNull
    public final Function1<Float, Float> getEasing() {
        return this.easing;
    }

    public final void setEasing(@NotNull Function1<? super Float, Float> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.easing = function1;
    }

    @Override
    @NotNull
    public <V extends AnimationVector> DurationBasedAnimation<V> build$ui_animation_core_release(@NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        long delay = this.getDelay();
        long duration2 = this.getDuration();
        return new SimpleDurationBasedAnimation(duration2, delay, AnimationBuilderKt.buildMultiDimensAnim(new Tween(duration2, delay, this.easing)));
    }
}

