/*
 * Decompiled with CFR 0.152.
 */
package androidx.animation;

import androidx.animation.Animation;
import androidx.animation.AnimationVector;
import androidx.animation.AnimationVectorsKt;
import androidx.animation.FloatAnimation;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\f\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0015J-\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\f\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u001a"}, d2={"Landroidx/animation/VectorizedAnimation;", "V", "Landroidx/animation/AnimationVector;", "Landroidx/animation/Animation;", "anim", "Landroidx/animation/FloatAnimation;", "(Landroidx/animation/FloatAnimation;)V", "getAnim", "()Landroidx/animation/FloatAnimation;", "endVelocityVector", "Landroidx/animation/AnimationVector;", "valueVector", "velocityVector", "getDurationMillis", "", "start", "end", "startVelocity", "(Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;)J", "getEndVelocity", "animationDuration", "(Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;J)Landroidx/animation/AnimationVector;", "getValue", "playTime", "(JLandroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;Landroidx/animation/AnimationVector;)Landroidx/animation/AnimationVector;", "getVelocity", "ui-animation-core_release"})
final class VectorizedAnimation<V extends AnimationVector>
implements Animation<V> {
    private V valueVector;
    private V velocityVector;
    private V endVelocityVector;
    @NotNull
    private final FloatAnimation anim;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getValue(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(start);
        }
        int n = 0;
        V v = this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
        }
        int n2 = ((AnimationVector)v).getSize$ui_animation_core_release();
        while (n < n2) {
            void i;
            V v2 = this.valueVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
            }
            ((AnimationVector)v2).set$ui_animation_core_release((int)i, this.anim.getValue(playTime, ((AnimationVector)start).get$ui_animation_core_release((int)i), ((AnimationVector)end).get$ui_animation_core_release((int)i), ((AnimationVector)startVelocity).get$ui_animation_core_release((int)i)));
            ++i;
        }
        V v3 = this.valueVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getVelocity(long playTime, @NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        if (this.velocityVector == null) {
            this.velocityVector = AnimationVectorsKt.newInstance(startVelocity);
        }
        int n = 0;
        V v = this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
        }
        int n2 = ((AnimationVector)v).getSize$ui_animation_core_release();
        while (n < n2) {
            void i;
            V v2 = this.velocityVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
            }
            ((AnimationVector)v2).set$ui_animation_core_release((int)i, this.anim.getVelocity(playTime, ((AnimationVector)start).get$ui_animation_core_release((int)i), ((AnimationVector)end).get$ui_animation_core_release((int)i), ((AnimationVector)startVelocity).get$ui_animation_core_release((int)i)));
            ++i;
        }
        V v3 = this.velocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getEndVelocity(@NotNull V start, @NotNull V end, @NotNull V startVelocity, long animationDuration) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        if (this.endVelocityVector == null) {
            this.endVelocityVector = AnimationVectorsKt.newInstance(startVelocity);
        }
        int n = 0;
        V v = this.endVelocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
        }
        int n2 = ((AnimationVector)v).getSize$ui_animation_core_release();
        while (n < n2) {
            void i;
            V v2 = this.endVelocityVector;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
            }
            ((AnimationVector)v2).set$ui_animation_core_release((int)i, this.anim.getEndVelocity(((AnimationVector)start).get$ui_animation_core_release((int)i), ((AnimationVector)end).get$ui_animation_core_release((int)i), ((AnimationVector)startVelocity).get$ui_animation_core_release((int)i), animationDuration));
            ++i;
        }
        V v3 = this.endVelocityVector;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
        }
        return v3;
    }

    @Override
    public long getDurationMillis(@NotNull V start, @NotNull V end, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        long maxDuration = 0L;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)((AnimationVector)start).getSize$ui_animation_core_release());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            long l;
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            long l2 = maxDuration;
            long l3 = this.anim.getDurationMillis(((AnimationVector)start).get$ui_animation_core_release(it), ((AnimationVector)end).get$ui_animation_core_release(it), ((AnimationVector)startVelocity).get$ui_animation_core_release(it));
            boolean bl2 = false;
            maxDuration = l = Math.max(l2, l3);
        }
        return maxDuration;
    }

    @NotNull
    public final FloatAnimation getAnim() {
        return this.anim;
    }

    public VectorizedAnimation(@NotNull FloatAnimation anim) {
        Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
        this.anim = anim;
    }

    public static final /* synthetic */ AnimationVector access$getValueVector$p(VectorizedAnimation $this) {
        Object v = $this.valueVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"valueVector");
        }
        return v;
    }

    public static final /* synthetic */ void access$setValueVector$p(VectorizedAnimation $this, AnimationVector animationVector) {
        $this.valueVector = animationVector;
    }

    public static final /* synthetic */ AnimationVector access$getVelocityVector$p(VectorizedAnimation $this) {
        Object v = $this.velocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"velocityVector");
        }
        return v;
    }

    public static final /* synthetic */ void access$setVelocityVector$p(VectorizedAnimation $this, AnimationVector animationVector) {
        $this.velocityVector = animationVector;
    }

    public static final /* synthetic */ AnimationVector access$getEndVelocityVector$p(VectorizedAnimation $this) {
        Object v = $this.endVelocityVector;
        if (v == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endVelocityVector");
        }
        return v;
    }

    public static final /* synthetic */ void access$setEndVelocityVector$p(VectorizedAnimation $this, AnimationVector animationVector) {
        $this.endVelocityVector = animationVector;
    }
}

