/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.animation;

import androidx.animation.AnimationClockObservable;
import androidx.animation.AnimationClockObserver;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0001J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u000f"}, d2={"Landroidx/ui/animation/DisposableAnimationClock;", "Landroidx/animation/AnimationClockObservable;", "clock", "allSubscriptions", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/collections/immutable/PersistentSet;", "Landroidx/animation/AnimationClockObserver;", "isDisposed", "", "()Z", "dispose", "", "subscribe", "observer", "unsubscribe", "ui-animation_release"})
public final class DisposableAnimationClock
implements AnimationClockObservable {
    private final AnimationClockObservable clock;
    private final AtomicReference<PersistentSet<AnimationClockObserver>> allSubscriptions;

    public DisposableAnimationClock(@NotNull AnimationClockObservable clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.allSubscriptions = new AtomicReference<PersistentSet>(ExtensionsKt.persistentSetOf());
    }

    public void subscribe(@NotNull AnimationClockObserver observer) {
        PersistentSet persistentSet;
        PersistentSet persistentSet2;
        PersistentSet<AnimationClockObserver> old;
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        do {
            PersistentSet<AnimationClockObserver> persistentSet3;
            PersistentSet persistentSet4 = persistentSet = (persistentSet3 = (old = this.allSubscriptions.get())) == null ? (PersistentSet)null : persistentSet3.add((Object)observer);
            if (persistentSet != null) continue;
            return;
        } while (!this.allSubscriptions.compareAndSet(old, (PersistentSet<AnimationClockObserver>)(persistentSet2 = persistentSet)));
        this.clock.subscribe(observer);
    }

    public void unsubscribe(@NotNull AnimationClockObserver observer) {
        PersistentSet persistentSet;
        PersistentSet<AnimationClockObserver> old;
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        do {
            PersistentSet<AnimationClockObserver> persistentSet2;
            if ((persistentSet2 = this.allSubscriptions.get()) == null) {
                return;
            }
            old = persistentSet2;
            persistentSet = old.remove((Object)observer);
            if (!Intrinsics.areEqual(old, (Object)persistentSet)) continue;
            return;
        } while (!this.allSubscriptions.compareAndSet(old, (PersistentSet<AnimationClockObserver>)persistentSet));
        this.clock.unsubscribe(observer);
    }

    public final void dispose() {
        PersistentSet persistentSet = this.allSubscriptions.getAndSet(null);
        if (persistentSet != null) {
            Iterable $this$forEach$iv = (Iterable)persistentSet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnimationClockObserver it = (AnimationClockObserver)element$iv;
                boolean bl = false;
                this.clock.unsubscribe(it);
            }
        }
    }

    public final boolean isDisposed() {
        return this.allSubscriptions.get() == null;
    }
}

