/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.gestures;

import androidx.ui.foundation.gestures.DragValueController;
import androidx.ui.foundation.gestures.FloatValueHolder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J$\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/ui/foundation/gestures/FloatDragValueController;", "Landroidx/ui/foundation/gestures/DragValueController;", "initialValue", "", "(F)V", "currentValue", "getCurrentValue", "()F", "maxBound", "minBound", "value", "Landroidx/ui/foundation/gestures/FloatValueHolder;", "onDrag", "", "target", "onDragEnd", "velocity", "onValueSettled", "Lkotlin/Function1;", "setBounds", "min", "max", "ui-foundation_release"})
public final class FloatDragValueController
implements DragValueController {
    private final FloatValueHolder value;
    private float minBound;
    private float maxBound;

    public FloatDragValueController(float initialValue) {
        this.value = new FloatValueHolder(initialValue);
        this.minBound = FloatCompanionObject.INSTANCE.getMIN_VALUE();
        this.maxBound = FloatCompanionObject.INSTANCE.getMAX_VALUE();
    }

    @Override
    public float getCurrentValue() {
        return this.value.getInner();
    }

    @Override
    public void onDrag(float target) {
        this.value.setInner(RangesKt.coerceIn((float)target, (float)this.minBound, (float)this.maxBound));
    }

    @Override
    public void onDragEnd(float velocity, @NotNull Function1<? super Float, Unit> onValueSettled) {
        Intrinsics.checkParameterIsNotNull(onValueSettled, (String)"onValueSettled");
        onValueSettled.invoke((Object)Float.valueOf(this.getCurrentValue()));
    }

    @Override
    public void setBounds(float min, float max) {
        block0: {
            boolean changed = !(this.minBound == min) || !(this.maxBound == max);
            this.minBound = min;
            this.maxBound = max;
            if (!changed) break block0;
            this.value.setInner(RangesKt.coerceIn((float)this.value.getInner(), (float)this.minBound, (float)this.maxBound));
        }
    }
}

