/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.shape.corner;

import androidx.ui.core.Px;
import androidx.ui.core.PxKt;
import androidx.ui.core.PxSize;
import androidx.ui.engine.geometry.Outline;
import androidx.ui.engine.geometry.RRectKt;
import androidx.ui.engine.geometry.Radius;
import androidx.ui.engine.geometry.Rect;
import androidx.ui.foundation.shape.corner.CornerBasedShape;
import androidx.ui.foundation.shape.corner.CornerSize;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0016H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\f\u0010\u001f\u001a\u00020 *\u00020\u0016H\u0002R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006!"}, d2={"Landroidx/ui/foundation/shape/corner/RoundedCornerShape;", "Landroidx/ui/foundation/shape/corner/CornerBasedShape;", "topLeft", "Landroidx/ui/foundation/shape/corner/CornerSize;", "topRight", "bottomRight", "bottomLeft", "(Landroidx/ui/foundation/shape/corner/CornerSize;Landroidx/ui/foundation/shape/corner/CornerSize;Landroidx/ui/foundation/shape/corner/CornerSize;Landroidx/ui/foundation/shape/corner/CornerSize;)V", "getBottomLeft", "()Landroidx/ui/foundation/shape/corner/CornerSize;", "getBottomRight", "getTopLeft", "getTopRight", "component1", "component2", "component3", "component4", "copy", "createOutline", "Landroidx/ui/engine/geometry/Outline$Rounded;", "size", "Landroidx/ui/core/PxSize;", "Landroidx/ui/core/Px;", "equals", "", "other", "", "hashCode", "", "toString", "", "toRadius", "Landroidx/ui/engine/geometry/Radius;", "ui-foundation_release"})
public final class RoundedCornerShape
extends CornerBasedShape {
    @NotNull
    public final CornerSize topLeft;
    @NotNull
    public final CornerSize topRight;
    @NotNull
    public final CornerSize bottomRight;
    @NotNull
    public final CornerSize bottomLeft;

    public RoundedCornerShape(@NotNull CornerSize topLeft, @NotNull CornerSize topRight, @NotNull CornerSize bottomRight, @NotNull CornerSize bottomLeft) {
        Intrinsics.checkParameterIsNotNull((Object)topLeft, (String)"topLeft");
        Intrinsics.checkParameterIsNotNull((Object)topRight, (String)"topRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomLeft, (String)"bottomLeft");
        super(topLeft, topRight, bottomRight, bottomLeft);
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
        this.bottomLeft = bottomLeft;
    }

    @NotNull
    public final CornerSize getTopLeft() {
        return this.topLeft;
    }

    @NotNull
    public final CornerSize getTopRight() {
        return this.topRight;
    }

    @NotNull
    public final CornerSize getBottomRight() {
        return this.bottomRight;
    }

    @NotNull
    public final CornerSize getBottomLeft() {
        return this.bottomLeft;
    }

    @NotNull
    public Outline.Rounded createOutline(@NotNull PxSize size, @NotNull Px topLeft, @NotNull Px topRight, @NotNull Px bottomRight, @NotNull Px bottomLeft) {
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        Intrinsics.checkParameterIsNotNull((Object)topLeft, (String)"topLeft");
        Intrinsics.checkParameterIsNotNull((Object)topRight, (String)"topRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomLeft, (String)"bottomLeft");
        return new Outline.Rounded(RRectKt.RRect((Rect)PxKt.toRect((PxSize)size), (Radius)this.toRadius(topLeft), (Radius)this.toRadius(topRight), (Radius)this.toRadius(bottomRight), (Radius)this.toRadius(bottomLeft)));
    }

    private final Radius toRadius(Px $this$toRadius) {
        return Radius.Companion.circular($this$toRadius.getValue());
    }

    @NotNull
    public final CornerSize component1() {
        return this.getTopLeft();
    }

    @NotNull
    public final CornerSize component2() {
        return this.getTopRight();
    }

    @NotNull
    public final CornerSize component3() {
        return this.getBottomRight();
    }

    @NotNull
    public final CornerSize component4() {
        return this.getBottomLeft();
    }

    @NotNull
    public final RoundedCornerShape copy(@NotNull CornerSize topLeft, @NotNull CornerSize topRight, @NotNull CornerSize bottomRight, @NotNull CornerSize bottomLeft) {
        Intrinsics.checkParameterIsNotNull((Object)topLeft, (String)"topLeft");
        Intrinsics.checkParameterIsNotNull((Object)topRight, (String)"topRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomLeft, (String)"bottomLeft");
        return new RoundedCornerShape(topLeft, topRight, bottomRight, bottomLeft);
    }

    public static /* synthetic */ RoundedCornerShape copy$default(RoundedCornerShape this_, CornerSize topLeft, CornerSize topRight, CornerSize bottomRight, CornerSize bottomLeft, int $mask0, Object $handler) {
        CornerSize cornerSize = ($mask0 & 1) != 0 ? this_.getTopLeft() : topLeft;
        CornerSize cornerSize2 = ($mask0 & 2) != 0 ? this_.getTopRight() : topRight;
        CornerSize cornerSize3 = ($mask0 & 4) != 0 ? this_.getBottomRight() : bottomRight;
        CornerSize cornerSize4 = ($mask0 & 8) != 0 ? this_.getBottomLeft() : bottomLeft;
        return this_.copy(cornerSize, cornerSize2, cornerSize3, cornerSize4);
    }

    @NotNull
    public String toString() {
        return "RoundedCornerShape(topLeft=" + this.getTopLeft() + ", topRight=" + this.getTopRight() + ", bottomRight=" + this.getBottomRight() + ", bottomLeft=" + this.getBottomLeft() + ")";
    }

    public int hashCode() {
        int n = 0;
        n = this.getTopLeft().hashCode();
        n = n * 31 + this.getTopRight().hashCode();
        n = n * 31 + this.getBottomRight().hashCode();
        n = n * 31 + this.getBottomLeft().hashCode();
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RoundedCornerShape)) {
            return false;
        }
        RoundedCornerShape roundedCornerShape = (RoundedCornerShape)other;
        if (!Intrinsics.areEqual((Object)this.getTopLeft(), (Object)roundedCornerShape.getTopLeft())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTopRight(), (Object)roundedCornerShape.getTopRight())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getBottomRight(), (Object)roundedCornerShape.getBottomRight())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getBottomLeft(), (Object)roundedCornerShape.getBottomLeft());
    }
}

