/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation;

import androidx.ui.core.DrawModifier;
import androidx.ui.core.Modifier;
import androidx.ui.foundation.shape.RectangleShapeKt;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.OutlineKt;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.Shape;
import androidx.ui.unit.Density;
import androidx.ui.unit.PxKt;
import androidx.ui.unit.PxSize;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/ui/foundation/DrawBackground;", "Landroidx/ui/core/DrawModifier;", "paint", "Landroidx/ui/graphics/Paint;", "shape", "Landroidx/ui/graphics/Shape;", "(Landroidx/ui/graphics/Paint;Landroidx/ui/graphics/Shape;)V", "component1", "component2", "copy", "draw", "", "density", "Landroidx/ui/unit/Density;", "drawContent", "Lkotlin/Function0;", "canvas", "Landroidx/ui/graphics/Canvas;", "size", "Landroidx/ui/unit/PxSize;", "equals", "", "other", "", "hashCode", "", "toString", "", "ui-foundation_release"})
public final class DrawBackground
implements DrawModifier {
    private final Paint paint;
    private final Shape shape;

    public DrawBackground(@NotNull Paint paint2, @NotNull Shape shape) {
        Intrinsics.checkParameterIsNotNull((Object)paint2, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        this.paint = paint2;
        this.shape = shape;
    }

    public void draw(@NotNull Density density, @NotNull Function0<Unit> drawContent, @NotNull Canvas canvas, @NotNull PxSize size) {
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull(drawContent, (String)"drawContent");
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        if (this.shape == RectangleShapeKt.getRectangleShape()) {
            canvas.drawRect(PxKt.toRect((PxSize)size), this.paint);
        } else {
            Outline outline = this.shape.createOutline(size, density);
            OutlineKt.drawOutline((Canvas)canvas, (Outline)outline, (Paint)this.paint);
        }
        drawContent.invoke();
    }

    private final Paint component1() {
        return this.paint;
    }

    private final Shape component2() {
        return this.shape;
    }

    @NotNull
    public final DrawBackground copy(@NotNull Paint paint2, @NotNull Shape shape) {
        Intrinsics.checkParameterIsNotNull((Object)paint2, (String)"paint");
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        return new DrawBackground(paint2, shape);
    }

    public static /* synthetic */ DrawBackground copy$default(@NotNull DrawBackground this_, @Nullable Paint paint2, @Nullable Shape shape, int $mask0, @Nullable Object $handler) {
        Paint paint3 = ($mask0 & 1) != 0 ? this_.paint : paint2;
        Shape shape2 = ($mask0 & 2) != 0 ? this_.shape : shape;
        return this_.copy(paint3, shape2);
    }

    @NotNull
    public String toString() {
        return "DrawBackground(paint=" + this.paint + ", shape=" + this.shape + ")";
    }

    public int hashCode() {
        return this.paint.hashCode() * 31 + this.shape.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DrawBackground)) {
            return false;
        }
        Object object = other;
        DrawBackground drawBackground = (DrawBackground)object;
        if (!Intrinsics.areEqual((Object)this.paint, (Object)drawBackground.paint)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.shape, (Object)drawBackground.shape);
    }

    @Deprecated(message="use + instead", replaceWith=@ReplaceWith(expression="this + other", imports={}))
    @NotNull
    public Modifier wraps(@NotNull Modifier other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Modifier.DefaultImpls.wraps((Modifier)this, (Modifier)other);
    }

    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)Modifier.Element.DefaultImpls.foldIn((Modifier.Element)this, initial, operation);
    }

    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)Modifier.Element.DefaultImpls.foldOut((Modifier.Element)this, initial, operation);
    }

    @NotNull
    public Modifier plus(@NotNull Modifier other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Modifier.DefaultImpls.plus((Modifier)this, (Modifier)other);
    }
}

