/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.animation;

import androidx.animation.DecayAnimation;
import androidx.ui.foundation.animation.AndroidFlingCalculator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0017"}, d2={"Landroidx/ui/foundation/animation/AndroidFlingDecayAnimation;", "Landroidx/animation/DecayAnimation;", "flingCalculator", "Landroidx/ui/foundation/animation/AndroidFlingCalculator;", "(Landroidx/ui/foundation/animation/AndroidFlingCalculator;)V", "absVelocityThreshold", "", "getAbsVelocityThreshold", "()F", "<set-?>", "getFlingCalculator", "()Landroidx/ui/foundation/animation/AndroidFlingCalculator;", "setFlingCalculator$ui_foundation_release", "flingDistance", "startVelocity", "getTarget", "start", "getValue", "playTime", "", "getVelocity", "isFinished", "", "ui-foundation_release"})
public final class AndroidFlingDecayAnimation
implements DecayAnimation {
    private AndroidFlingCalculator flingCalculator;

    public AndroidFlingDecayAnimation(@NotNull AndroidFlingCalculator flingCalculator) {
        Intrinsics.checkParameterIsNotNull((Object)flingCalculator, (String)"flingCalculator");
        this.flingCalculator = flingCalculator;
    }

    @NotNull
    public final AndroidFlingCalculator getFlingCalculator() {
        return this.flingCalculator;
    }

    public final void setFlingCalculator$ui_foundation_release(@NotNull AndroidFlingCalculator androidFlingCalculator) {
        Intrinsics.checkParameterIsNotNull((Object)androidFlingCalculator, (String)"<set-?>");
        this.flingCalculator = androidFlingCalculator;
    }

    public float getAbsVelocityThreshold() {
        return 0.0f;
    }

    private final float flingDistance(float startVelocity) {
        float f = this.getFlingCalculator().flingDistance(startVelocity);
        boolean bl = false;
        float f2 = Math.signum(startVelocity);
        return f * f2;
    }

    public float getTarget(float start, float startVelocity) {
        return start + this.flingDistance(startVelocity);
    }

    public float getValue(long playTime, float start, float startVelocity) {
        return start + this.getFlingCalculator().flingInfo(startVelocity).position(playTime);
    }

    public float getVelocity(long playTime, float start, float startVelocity) {
        return this.getFlingCalculator().flingInfo(startVelocity).velocity(playTime);
    }

    public boolean isFinished(long playTime, float start, float startVelocity) {
        AndroidFlingCalculator.FlingInfo flingInfo = this.getFlingCalculator().flingInfo(startVelocity);
        if (playTime > flingInfo.getDuration()) {
            return true;
        }
        return MathKt.roundToInt((float)flingInfo.getDistance()) == MathKt.roundToInt((float)flingInfo.position(playTime));
    }
}

