/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.animation;

import kotlin.Metadata;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"EndTension", "", "Inflection", "P1", "P2", "StartTension", "computeSplineInfo", "", "splinePositions", "", "splineTimes", "nbSamples", "", "ui-foundation_release"})
public final class AndroidFlingSplineKt {
    private static final float Inflection = 0.35f;
    private static final float StartTension = 0.5f;
    private static final float EndTension = 1.0f;
    private static final float P1 = 0.175f;
    private static final float P2 = 0.35000002f;

    private static final void computeSplineInfo(float[] splinePositions, float[] splineTimes, int nbSamples) {
        float xMin = 0.0f;
        float yMin = 0.0f;
        int n = 0;
        int n2 = nbSamples + -1;
        if (nbSamples != Integer.MIN_VALUE && n <= n2) {
            do {
                float y;
                float coef;
                float x;
                int i = n++;
                float alpha = (float)i / (float)nbSamples;
                float xMax = 1.0f;
                while (true) {
                    x = xMin + (xMax - xMin) / 2.0f;
                    coef = 3.0f * x * (1.0f - x);
                    float tx = coef * ((1.0f - x) * 0.175f + x * 0.35000002f) + x * x * x;
                    float f = tx - alpha;
                    boolean bl = false;
                    if ((double)Math.abs(f) < 1.0E-5) break;
                    if (tx > alpha) {
                        xMax = x;
                        continue;
                    }
                    xMin = x;
                }
                splinePositions[i] = coef * ((1.0f - x) * 0.5f + x) + x * x * x;
                float yMax = 1.0f;
                while (true) {
                    y = yMin + (yMax - yMin) / 2.0f;
                    coef = 3.0f * y * (1.0f - y);
                    float dy = coef * ((1.0f - y) * 0.5f + y) + y * y * y;
                    float f = dy - alpha;
                    boolean bl = false;
                    if ((double)Math.abs(f) < 1.0E-5) break;
                    if (dy > alpha) {
                        yMax = y;
                        continue;
                    }
                    yMin = y;
                }
                splineTimes[i] = coef * ((1.0f - y) * 0.175f + y * 0.35000002f) + y * y * y;
            } while (n <= n2);
        }
        splineTimes[nbSamples] = 1.0f;
        splinePositions[nbSamples] = splineTimes[nbSamples];
    }

    public static final /* synthetic */ void access$computeSplineInfo$0(float[] splinePositions, float[] splineTimes, int nbSamples) {
        AndroidFlingSplineKt.computeSplineInfo(splinePositions, splineTimes, nbSamples);
    }
}

