/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.shape.corner;

import androidx.ui.foundation.shape.corner.CornerSize;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.Shape;
import androidx.ui.unit.Density;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxKt;
import androidx.ui.unit.PxSize;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000eH&R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/ui/foundation/shape/corner/CornerBasedShape;", "Landroidx/ui/graphics/Shape;", "topLeft", "Landroidx/ui/foundation/shape/corner/CornerSize;", "topRight", "bottomRight", "bottomLeft", "(Landroidx/ui/foundation/shape/corner/CornerSize;Landroidx/ui/foundation/shape/corner/CornerSize;Landroidx/ui/foundation/shape/corner/CornerSize;Landroidx/ui/foundation/shape/corner/CornerSize;)V", "createOutline", "Landroidx/ui/graphics/Outline;", "size", "Landroidx/ui/unit/PxSize;", "density", "Landroidx/ui/unit/Density;", "Landroidx/ui/unit/Px;", "ui-foundation_release"})
public abstract class CornerBasedShape
implements Shape {
    private final CornerSize topLeft;
    private final CornerSize topRight;
    private final CornerSize bottomRight;
    private final CornerSize bottomLeft;

    public CornerBasedShape(@NotNull CornerSize topLeft, @NotNull CornerSize topRight, @NotNull CornerSize bottomRight, @NotNull CornerSize bottomLeft) {
        Intrinsics.checkParameterIsNotNull((Object)topLeft, (String)"topLeft");
        Intrinsics.checkParameterIsNotNull((Object)topRight, (String)"topRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomLeft, (String)"bottomLeft");
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
        this.bottomLeft = bottomLeft;
    }

    @NotNull
    public final Outline createOutline(@NotNull PxSize size, @NotNull Density density) {
        boolean $this$px$iv;
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Px topLeft = this.topLeft.toPx(size, density);
        Px topRight = this.topRight.toPx(size, density);
        Px bottomRight = this.bottomRight.toPx(size, density);
        Px bottomLeft = this.bottomLeft.toPx(size, density);
        boolean bl = false;
        Px px = topLeft;
        Px px2 = new Px((float)$this$px$iv);
        $this$px$iv = px.compareTo(px2) >= 0 && (px = topRight).compareTo(px2 = new Px((float)($this$px$iv = false))) >= 0 && (px = bottomRight).compareTo(px2 = new Px((float)($this$px$iv = false))) >= 0 && (px = bottomLeft).compareTo(px2 = new Px((float)($this$px$iv = false))) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!$this$px$iv) {
            String string = "Corner size in Px can't be negative!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Px this_$iv = topLeft;
        this_$iv = new Px(this_$iv.getValue() + topRight.getValue());
        this_$iv = new Px(this_$iv.getValue() + bottomLeft.getValue());
        boolean this_$iv2 = false;
        px = new Px(this_$iv.getValue() + bottomRight.getValue());
        return Intrinsics.areEqual((Object)px, (Object)(px2 = new Px((float)$this$px$iv))) ? (Outline)new Outline.Rectangle(PxKt.toRect((PxSize)size)) : this.createOutline(size, topLeft, topRight, bottomRight, bottomLeft);
    }

    @NotNull
    public abstract Outline createOutline(@NotNull PxSize var1, @NotNull Px var2, @NotNull Px var3, @NotNull Px var4, @NotNull Px var5);
}

