/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation;

import androidx.ui.core.DrawModifier;
import androidx.ui.core.Modifier;
import androidx.ui.foundation.DrawBorderCache;
import androidx.ui.geometry.RRect;
import androidx.ui.geometry.RRectKt;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Brush;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.PaintingStyle;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.Shape;
import androidx.ui.unit.Density;
import androidx.ui.unit.Dp;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxKt;
import androidx.ui.unit.PxSize;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\"\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\tJ.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/ui/foundation/DrawBorder;", "Landroidx/ui/core/DrawModifier;", "cache", "Landroidx/ui/foundation/DrawBorderCache;", "shape", "Landroidx/ui/graphics/Shape;", "borderWidth", "Landroidx/ui/unit/Dp;", "brush", "Landroidx/ui/graphics/Brush;", "draw", "", "density", "Landroidx/ui/unit/Density;", "drawContent", "Lkotlin/Function0;", "canvas", "Landroidx/ui/graphics/Canvas;", "size", "Landroidx/ui/unit/PxSize;", "drawRoundRectBorder", "borderSize", "", "rect", "Landroidx/ui/geometry/Rect;", "radius", "paint", "Landroidx/ui/graphics/Paint;", "equals", "", "other", "", "hashCode", "", "ui-foundation_release"})
public final class DrawBorder
implements DrawModifier {
    private final DrawBorderCache cache;
    private final Shape shape;
    private final Dp borderWidth;
    private final Brush brush;

    public DrawBorder(@NotNull DrawBorderCache cache, @NotNull Shape shape, @NotNull Dp borderWidth, @NotNull Brush brush) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        Intrinsics.checkParameterIsNotNull((Object)borderWidth, (String)"borderWidth");
        Intrinsics.checkParameterIsNotNull((Object)brush, (String)"brush");
        this.cache = cache;
        this.shape = shape;
        this.borderWidth = borderWidth;
        this.brush = brush;
        this.cache.setLastShape(this.shape);
        this.cache.setBorderSize(this.borderWidth);
    }

    /*
     * WARNING - void declaration
     */
    public void draw(@NotNull Density density, @NotNull Function0<Unit> drawContent, @NotNull Canvas canvas, @NotNull PxSize size) {
        float borderSize;
        Outline outline;
        DrawBorderCache $this$draw_u24lambda_u2d0;
        block8: {
            block7: {
                void $this$px$iv;
                Px px;
                Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
                Intrinsics.checkParameterIsNotNull(drawContent, (String)"drawContent");
                Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
                Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
                DrawBorderCache drawBorderCache = this.cache;
                boolean bl = false;
                boolean bl2 = false;
                $this$draw_u24lambda_u2d0 = drawBorderCache;
                drawContent.invoke();
                $this$draw_u24lambda_u2d0.setModifierSize(size);
                outline = $this$draw_u24lambda_u2d0.modifierSizeOutline(density);
                borderSize = Intrinsics.areEqual((Object)this.borderWidth, (Object)Dp.Companion.getHairline()) ? 1.0f : this.borderWidth.getValue() * density.getDensity();
                this.brush.applyTo($this$draw_u24lambda_u2d0.getPaint());
                $this$draw_u24lambda_u2d0.getPaint().setStrokeWidth(borderSize);
                if (borderSize <= 0.0f) break block7;
                boolean bl3 = false;
                Px px2 = PxKt.getMinDimension((PxSize)size);
                if (px2.compareTo(px = new Px((float)$this$px$iv)) > 0) break block8;
            }
            return;
        }
        if (outline instanceof Outline.Rectangle) {
            this.drawRoundRectBorder(borderSize, ((Outline.Rectangle)outline).getRect(), 0.0f, canvas, $this$draw_u24lambda_u2d0.getPaint());
        } else if (outline instanceof Outline.Rounded && RRectKt.isSimple((RRect)((Outline.Rounded)outline).getRrect())) {
            float radius = ((Outline.Rounded)outline).getRrect().getBottomLeftRadiusY();
            this.drawRoundRectBorder(borderSize, RRectKt.outerRect((RRect)((Outline.Rounded)outline).getRrect()), radius, canvas, $this$draw_u24lambda_u2d0.getPaint());
        } else {
            Path path = $this$draw_u24lambda_u2d0.borderPath(density, borderSize);
            $this$draw_u24lambda_u2d0.getPaint().setStyle(PaintingStyle.fill);
            canvas.drawPath(path, $this$draw_u24lambda_u2d0.getPaint());
        }
    }

    private final void drawRoundRectBorder(float borderSize, Rect rect, float radius, Canvas canvas, Paint paint) {
        boolean fillWithBorder = borderSize * (float)2 >= rect.getShortestSide();
        paint.setStyle(fillWithBorder ? PaintingStyle.fill : PaintingStyle.stroke);
        float delta = fillWithBorder ? 0.0f : borderSize / (float)2;
        canvas.drawRoundRect(rect.getLeft() + delta, rect.getTop() + delta, rect.getRight() - delta, rect.getBottom() - delta, radius, radius, paint);
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? (Class<?>)null : object.getClass())) {
            return false;
        }
        object = other;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.ui.foundation.DrawBorder");
        }
        DrawBorder cfr_ignored_0 = (DrawBorder)object;
        if (!Intrinsics.areEqual((Object)this.shape, (Object)((DrawBorder)other).shape)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.borderWidth, (Object)((DrawBorder)other).borderWidth)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.brush, (Object)((DrawBorder)other).brush);
    }

    public int hashCode() {
        int result = this.shape.hashCode();
        result = 31 * result + this.borderWidth.hashCode();
        result = 31 * result + this.brush.hashCode();
        return result;
    }

    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)Modifier.Element.DefaultImpls.foldIn((Modifier.Element)this, initial, operation);
    }

    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)Modifier.Element.DefaultImpls.foldOut((Modifier.Element)this, initial, operation);
    }

    @NotNull
    public Modifier plus(@NotNull Modifier other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Modifier.DefaultImpls.plus((Modifier)this, (Modifier)other);
    }
}

