/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.gestures;

import androidx.animation.AnimationBuilder;
import androidx.animation.AnimationClockObservable;
import androidx.animation.AnimationClockObserver;
import androidx.animation.AnimationEndReason;
import androidx.animation.BaseAnimatedValue;
import androidx.compose.MutableState;
import androidx.compose.MutableStateKt;
import androidx.ui.foundation.animation.FlingConfig;
import androidx.ui.foundation.animation.FlingConfigKt;
import androidx.ui.foundation.gestures.DeltaAnimatedFloat;
import androidx.ui.foundation.gestures.ScrollableState;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\f\u0018\u00002\u00020\u0001B$\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\bJ)\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u0003H\u0000\u00a2\u0006\u0002\b JH\u0010!\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u000428\b\u0002\u0010\"\u001a2\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u001d0#J\u0006\u0010)\u001a\u00020\u001dR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00048@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Landroidx/ui/foundation/gestures/ScrollableState;", "", "onScrollDeltaConsumptionRequested", "Lkotlin/Function1;", "", "flingConfig", "Landroidx/ui/foundation/animation/FlingConfig;", "animationClock", "Landroidx/animation/AnimationClockObservable;", "animatedFloat", "Landroidx/ui/foundation/gestures/DeltaAnimatedFloat;", "clocksProxy", "androidx/ui/foundation/gestures/ScrollableState$clocksProxy$1", "Landroidx/ui/foundation/gestures/ScrollableState$clocksProxy$1;", "getFlingConfig", "()Landroidx/ui/foundation/animation/FlingConfig;", "isAnimating", "", "()Z", "isAnimationRunningState", "Landroidx/compose/MutableState;", "getOnScrollDeltaConsumptionRequested", "()Lkotlin/jvm/functions/Function1;", "value", "getValue$ui_foundation_release", "()F", "setValue$ui_foundation_release", "(F)V", "fling", "", "velocity", "onScrollEnd", "fling$ui_foundation_release", "smoothScrollBy", "onEnd", "Lkotlin/Function2;", "Landroidx/animation/AnimationEndReason;", "Lkotlin/ParameterName;", "name", "endReason", "finishValue", "stopAnimation", "ui-foundation_release"})
public final class ScrollableState {
    private final Function1<Float, Float> onScrollDeltaConsumptionRequested;
    private final FlingConfig flingConfig;
    private final MutableState<Boolean> isAnimationRunningState;
    private final clocksProxy.1 clocksProxy;
    private final DeltaAnimatedFloat animatedFloat;

    public ScrollableState(@NotNull Function1<? super Float, Float> onScrollDeltaConsumptionRequested, @NotNull FlingConfig flingConfig, @NotNull AnimationClockObservable animationClock) {
        Intrinsics.checkParameterIsNotNull(onScrollDeltaConsumptionRequested, (String)"onScrollDeltaConsumptionRequested");
        Intrinsics.checkParameterIsNotNull((Object)flingConfig, (String)"flingConfig");
        Intrinsics.checkParameterIsNotNull((Object)animationClock, (String)"animationClock");
        this.onScrollDeltaConsumptionRequested = onScrollDeltaConsumptionRequested;
        this.flingConfig = flingConfig;
        this.isAnimationRunningState = MutableStateKt.mutableStateOf$default((Object)false, (Function2)null, (int)2, null);
        this.clocksProxy = new AnimationClockObservable(this, animationClock){
            private final /* synthetic */ ScrollableState $this$ScrollableState;
            private final /* synthetic */ AnimationClockObservable $animationClock;
            {
                this.$this$ScrollableState = $receiver;
                this.$animationClock = $animationClock;
            }

            public void subscribe(@NotNull AnimationClockObserver observer) {
                Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
                ScrollableState.access$prop$isAnimationRunningState$0(this.$this$ScrollableState).setValue((Object)true);
                this.$animationClock.subscribe(observer);
            }

            public void unsubscribe(@NotNull AnimationClockObserver observer) {
                Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
                ScrollableState.access$prop$isAnimationRunningState$0(this.$this$ScrollableState).setValue((Object)false);
                this.$animationClock.unsubscribe(observer);
            }
        };
        this.animatedFloat = new DeltaAnimatedFloat(0.0f, this.clocksProxy, this.getOnScrollDeltaConsumptionRequested());
    }

    @NotNull
    public final Function1<Float, Float> getOnScrollDeltaConsumptionRequested() {
        return this.onScrollDeltaConsumptionRequested;
    }

    @NotNull
    public final FlingConfig getFlingConfig() {
        return this.flingConfig;
    }

    public final void smoothScrollBy(float value, @NotNull Function2<? super AnimationEndReason, ? super Float, Unit> onEnd) {
        Intrinsics.checkParameterIsNotNull(onEnd, (String)"onEnd");
        float to = this.animatedFloat.getValue().floatValue() + value;
        BaseAnimatedValue.animateTo$default((BaseAnimatedValue)((BaseAnimatedValue)this.animatedFloat), (Object)Float.valueOf(to), (AnimationBuilder)null, onEnd, (int)2, null);
    }

    public static /* synthetic */ void smoothScrollBy$default(@NotNull ScrollableState this_, float value, @Nullable Function2 onEnd, int $mask0, @Nullable Object $handler) {
        Function2 function2 = ($mask0 & 2) != 0 ? (Function2)new Function2<AnimationEndReason, Float, Unit>(){

            public final void invoke(@NotNull AnimationEndReason animationEndReason, float f) {
                Intrinsics.checkParameterIsNotNull((Object)animationEndReason, (String)"<anonymous parameter 0>");
            }
        } : onEnd;
        this_.smoothScrollBy(value, (Function2<? super AnimationEndReason, ? super Float, Unit>)function2);
    }

    public final boolean isAnimating() {
        return (Boolean)this.isAnimationRunningState.getValue();
    }

    public final void stopAnimation() {
        this.animatedFloat.stop();
    }

    public final float getValue$ui_foundation_release() {
        return this.animatedFloat.getValue().floatValue();
    }

    public final void setValue$ui_foundation_release(float value) {
        this.animatedFloat.snapTo(value);
    }

    public final void fling$ui_foundation_release(float velocity, @NotNull Function1<? super Float, Unit> onScrollEnd) {
        Intrinsics.checkParameterIsNotNull(onScrollEnd, (String)"onScrollEnd");
        FlingConfig config2 = FlingConfig.copy$default(this.getFlingConfig(), null, (Function3)new Function3<AnimationEndReason, Float, Float, Unit>(this, onScrollEnd){
            private final /* synthetic */ ScrollableState $this$fling;
            private final /* synthetic */ Function1<Float, Unit> $onScrollEnd;
            {
                this.$this$fling = $receiver;
                this.$onScrollEnd = $onScrollEnd;
                super(3);
            }

            public final void invoke(@NotNull AnimationEndReason endReason, float valueLeft, float velocityLeft) {
                Intrinsics.checkParameterIsNotNull((Object)endReason, (String)"endReason");
                Function3<AnimationEndReason, Float, Float, Unit> function3 = this.$this$fling.getFlingConfig().getOnAnimationEnd();
                if (function3 != null) {
                    function3.invoke((Object)endReason, (Object)Float.valueOf(valueLeft), (Object)Float.valueOf(velocityLeft));
                }
                this.$onScrollEnd.invoke((Object)Float.valueOf(velocityLeft));
            }
        }, null, 5, null);
        FlingConfigKt.fling(this.animatedFloat, config2, velocity);
    }

    public static final /* synthetic */ MutableState access$prop$isAnimationRunningState$0(ScrollableState $this) {
        return $this.isAnimationRunningState;
    }
}

