/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation.shape.corner;

import androidx.ui.foundation.shape.corner.CornerBasedShape;
import androidx.ui.foundation.shape.corner.CornerSize;
import androidx.ui.geometry.RRectKt;
import androidx.ui.geometry.Radius;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Outline;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxKt;
import androidx.ui.unit.PxSize;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u0015H\u0002R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006 "}, d2={"Landroidx/ui/foundation/shape/corner/RoundedCornerShape;", "Landroidx/ui/foundation/shape/corner/CornerBasedShape;", "topLeft", "Landroidx/ui/foundation/shape/corner/CornerSize;", "topRight", "bottomRight", "bottomLeft", "getBottomLeft", "()Landroidx/ui/foundation/shape/corner/CornerSize;", "getBottomRight", "getTopLeft", "getTopRight", "component1", "component2", "component3", "component4", "copy", "createOutline", "Landroidx/ui/graphics/Outline$Rounded;", "size", "Landroidx/ui/unit/PxSize;", "Landroidx/ui/unit/Px;", "equals", "", "other", "", "hashCode", "", "toString", "", "toRadius", "Landroidx/ui/geometry/Radius;", "ui-foundation_release"})
public final class RoundedCornerShape
extends CornerBasedShape {
    private final CornerSize topLeft;
    private final CornerSize topRight;
    private final CornerSize bottomRight;
    private final CornerSize bottomLeft;

    public RoundedCornerShape(@NotNull CornerSize topLeft, @NotNull CornerSize topRight, @NotNull CornerSize bottomRight, @NotNull CornerSize bottomLeft) {
        Intrinsics.checkParameterIsNotNull((Object)topLeft, (String)"topLeft");
        Intrinsics.checkParameterIsNotNull((Object)topRight, (String)"topRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomLeft, (String)"bottomLeft");
        super(topLeft, topRight, bottomRight, bottomLeft);
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
        this.bottomLeft = bottomLeft;
    }

    @NotNull
    public final CornerSize getTopLeft() {
        return this.topLeft;
    }

    @NotNull
    public final CornerSize getTopRight() {
        return this.topRight;
    }

    @NotNull
    public final CornerSize getBottomRight() {
        return this.bottomRight;
    }

    @NotNull
    public final CornerSize getBottomLeft() {
        return this.bottomLeft;
    }

    @NotNull
    public Outline.Rounded createOutline(@NotNull PxSize size, @NotNull Px topLeft, @NotNull Px topRight, @NotNull Px bottomRight, @NotNull Px bottomLeft) {
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        Intrinsics.checkParameterIsNotNull((Object)topLeft, (String)"topLeft");
        Intrinsics.checkParameterIsNotNull((Object)topRight, (String)"topRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomLeft, (String)"bottomLeft");
        return new Outline.Rounded(RRectKt.RRect((Rect)PxKt.toRect((PxSize)size), (Radius)this.toRadius(topLeft), (Radius)this.toRadius(topRight), (Radius)this.toRadius(bottomRight), (Radius)this.toRadius(bottomLeft)));
    }

    private final Radius toRadius(Px $this$toRadius) {
        return Radius.Companion.circular($this$toRadius.getValue());
    }

    @NotNull
    public final CornerSize component1() {
        return this.topLeft;
    }

    @NotNull
    public final CornerSize component2() {
        return this.topRight;
    }

    @NotNull
    public final CornerSize component3() {
        return this.bottomRight;
    }

    @NotNull
    public final CornerSize component4() {
        return this.bottomLeft;
    }

    @NotNull
    public final RoundedCornerShape copy(@NotNull CornerSize topLeft, @NotNull CornerSize topRight, @NotNull CornerSize bottomRight, @NotNull CornerSize bottomLeft) {
        Intrinsics.checkParameterIsNotNull((Object)topLeft, (String)"topLeft");
        Intrinsics.checkParameterIsNotNull((Object)topRight, (String)"topRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomRight, (String)"bottomRight");
        Intrinsics.checkParameterIsNotNull((Object)bottomLeft, (String)"bottomLeft");
        return new RoundedCornerShape(topLeft, topRight, bottomRight, bottomLeft);
    }

    public static /* synthetic */ RoundedCornerShape copy$default(@NotNull RoundedCornerShape this_, @Nullable CornerSize topLeft, @Nullable CornerSize topRight, @Nullable CornerSize bottomRight, @Nullable CornerSize bottomLeft, int $mask0, @Nullable Object $handler) {
        CornerSize cornerSize = ($mask0 & 1) != 0 ? this_.topLeft : topLeft;
        CornerSize cornerSize2 = ($mask0 & 2) != 0 ? this_.topRight : topRight;
        CornerSize cornerSize3 = ($mask0 & 4) != 0 ? this_.bottomRight : bottomRight;
        CornerSize cornerSize4 = ($mask0 & 8) != 0 ? this_.bottomLeft : bottomLeft;
        return this_.copy(cornerSize, cornerSize2, cornerSize3, cornerSize4);
    }

    @NotNull
    public String toString() {
        return "RoundedCornerShape(topLeft=" + this.topLeft + ", topRight=" + this.topRight + ", bottomRight=" + this.bottomRight + ", bottomLeft=" + this.bottomLeft + ")";
    }

    public int hashCode() {
        return ((this.topLeft.hashCode() * 31 + this.topRight.hashCode()) * 31 + this.bottomRight.hashCode()) * 31 + this.bottomLeft.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RoundedCornerShape)) {
            return false;
        }
        Object object = other;
        RoundedCornerShape roundedCornerShape = (RoundedCornerShape)object;
        if (!Intrinsics.areEqual((Object)this.topLeft, (Object)roundedCornerShape.topLeft)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.topRight, (Object)roundedCornerShape.topRight)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bottomRight, (Object)roundedCornerShape.bottomRight)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bottomLeft, (Object)roundedCornerShape.bottomLeft);
    }
}

