/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.foundation;

import androidx.ui.core.ContentDrawScope;
import androidx.ui.core.DrawModifier;
import androidx.ui.core.Modifier;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Outline;
import androidx.ui.graphics.OutlineKt;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.RectangleShapeKt;
import androidx.ui.graphics.Shape;
import androidx.ui.unit.Density;
import androidx.ui.unit.PxKt;
import androidx.ui.unit.PxSize;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0012\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/ui/foundation/DrawBackground;", "Landroidx/ui/core/DrawModifier;", "paint", "Landroidx/ui/graphics/Paint;", "shape", "Landroidx/ui/graphics/Shape;", "lastOutline", "Landroidx/ui/graphics/Outline;", "lastSize", "Landroidx/ui/unit/PxSize;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "draw", "", "Landroidx/ui/core/ContentDrawScope;", "ui-foundation_release"})
public final class DrawBackground
implements DrawModifier {
    private final Paint paint;
    private final Shape shape;
    private PxSize lastSize;
    private Outline lastOutline;

    public DrawBackground(@NotNull Paint paint, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.paint = paint;
        this.shape = shape;
    }

    public void draw(@NotNull ContentDrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (this.shape == RectangleShapeKt.getRectangleShape()) {
            $this$draw.drawRect(PxKt.toRect((PxSize)$this$draw.getSize()), this.paint);
        } else {
            Outline outline;
            if (Intrinsics.areEqual((Object)$this$draw.getSize(), (Object)this.lastSize)) {
                Outline outline2 = this.lastOutline;
                Intrinsics.checkNotNull((Object)outline2);
                outline = outline2;
            } else {
                outline = this.shape.createOutline($this$draw.getSize(), (Density)$this$draw);
            }
            Outline localOutline = outline;
            OutlineKt.drawOutline((Canvas)((Canvas)$this$draw), (Outline)localOutline, (Paint)this.paint);
            this.lastOutline = localOutline;
            this.lastSize = $this$draw.getSize();
        }
        $this$draw.drawContent();
    }

    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return (R)Modifier.Element.DefaultImpls.foldIn((Modifier.Element)this, initial, operation);
    }

    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return (R)Modifier.Element.DefaultImpls.foldOut((Modifier.Element)this, initial, operation);
    }

    @NotNull
    public Modifier plus(@NotNull Modifier other) {
        return Modifier.DefaultImpls.plus((Modifier)this, (Modifier)other);
    }

    private final Paint component1() {
        return this.paint;
    }

    private final Shape component2() {
        return this.shape;
    }

    @NotNull
    public final DrawBackground copy(@NotNull Paint paint, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return new DrawBackground(paint, shape);
    }

    public static /* synthetic */ DrawBackground copy$default(DrawBackground this_, Paint paint, Shape shape, int n, Object object) {
        if ((n & 1) != 0) {
            paint = this_.paint;
        }
        if ((n & 2) != 0) {
            shape = this_.shape;
        }
        return this_.copy(paint, shape);
    }

    @NotNull
    public String toString() {
        return "DrawBackground(paint=" + this.paint + ", shape=" + this.shape + ")";
    }

    public int hashCode() {
        return this.paint.hashCode() * 31 + this.shape.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DrawBackground)) {
            return false;
        }
        Object object = other;
        DrawBackground drawBackground = (DrawBackground)object;
        if (!Intrinsics.areEqual((Object)this.paint, (Object)drawBackground.paint)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.shape, (Object)drawBackground.shape);
    }
}

